package com.artfess.bpm.plugin.usercalc.samenode.runtime;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.BpmConstants;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.plugin.core.def.BpmPluginDef;
import com.artfess.bpm.api.plugin.core.session.BpmUserCalcPluginSession;
import com.artfess.bpm.plugin.core.runtime.AbstractUserCalcPlugin;
import com.artfess.bpm.plugin.usercalc.samenode.def.SameNodePluginDef;
import com.artfess.uc.api.model.IUser;

public class SameNodePlugin  extends AbstractUserCalcPlugin{

	@Override
	public List<BpmIdentity> queryByPluginDef(BpmUserCalcPluginSession pluginSession, BpmPluginDef pluginDef) {
		String processInstanceId = (String) pluginSession.getVariables().get(BpmConstants.PROCESS_INST_ID);
		SameNodePluginDef sameNodeDef = (SameNodePluginDef)pluginDef;
		List<BpmIdentity> bpmIdentities = new ArrayList<BpmIdentity>();
		
		Map<String, Set<String>> auditorSet =  pluginSession.getBpmxEngine().getBpmOpinionService().getHisAuditorByInstId(processInstanceId, false);
		
		if(BeanUtils.isNotEmpty(auditorSet) && auditorSet.containsKey(sameNodeDef.getNodeId()) ){
			List<IUser> users = pluginSession.getOrgEngine().getUserService().getUserByIds(StringUtil.join(auditorSet.get(sameNodeDef.getNodeId())));
			bpmIdentities = getBpmIdentityConverter().convertUserList(users);
		}
		
		return bpmIdentities;
	}

	@Override
	public boolean supportPreView() {
		return false;
	}

}
