/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.kh.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.portal.kh.dao.KhAssessSchemeDao;
import com.artfess.portal.kh.manager.KhAssessDetailsManager;
import com.artfess.portal.kh.manager.KhAssessSchemeManager;
import com.artfess.portal.kh.model.KhAssessDetails;
import com.artfess.portal.kh.model.KhAssessScheme;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import java.io.Serializable;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class KhAssessSchemeManagerImpl
extends BaseManagerImpl<KhAssessSchemeDao, KhAssessScheme>
implements KhAssessSchemeManager {
    @Autowired
    private KhAssessDetailsManager detailsManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(KhAssessScheme t) {
        t.setStatus("0");
        boolean save = this.save((Object)t);
        if (save) {
            this.processDetail(t);
            return save;
        }
        return false;
    }

    private void processDetail(KhAssessScheme t) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(KhAssessDetails::getAssessId, (Object)t.getId());
        lambdaQueryWrapper.eq(KhAssessDetails::getIsDele, (Object)DelStatusEnum.N.getType());
        this.detailsManager.remove((Wrapper)lambdaQueryWrapper);
        if (CollectionUtils.isEmpty(t.getDetailsList())) {
            return;
        }
        t.getDetailsList().forEach(detail -> {
            Assert.notNull((Object)detail.getMinValue(), (String)"\u8bf7\u586b\u5199\u6700\u5c0f\u503c");
            Assert.notNull((Object)detail.getMaxValue(), (String)"\u8bf7\u586b\u5199\u6700\u5927\u503c");
            detail.setAssessId(t.getId());
        });
        this.detailsManager.saveBatch(t.getDetailsList());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(KhAssessScheme t) {
        boolean save = this.updateById((Object)t);
        if (save) {
            this.processDetail(t);
            return save;
        }
        return false;
    }

    @Override
    public KhAssessScheme findById(String id) {
        KhAssessScheme khAssessScheme = (KhAssessScheme)this.get((Serializable)((Object)id));
        Assert.notNull((Object)((Object)khAssessScheme), (String)"\u8bc4\u7ea7\u65b9\u6848\u4e0d\u5b58\u5728");
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(KhAssessDetails::getAssessId, (Object)id);
        lambdaQueryWrapper.eq(KhAssessDetails::getIsDele, (Object)DelStatusEnum.N.getType());
        List list = this.detailsManager.list((Wrapper)lambdaQueryWrapper);
        khAssessScheme.setDetailsList(list);
        return khAssessScheme;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateStatus(List<String> ids, String status) {
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.in(KhAssessScheme::getId, ids);
        List list = this.list((Wrapper)lambdaQueryWrapper);
        list.forEach(khAssessScheme -> khAssessScheme.setStatus(status));
        boolean b = this.updateBatchById(list);
        return b;
    }
}

