/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.manager.SysCategoryManager;
import com.artfess.sysConfig.persistence.model.SysCategory;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/category/v1/"})
@Api(tags={"\u7cfb\u7edf\u5206\u7c7b\u7ba1\u7406"})
@ApiGroup(group={"group_system"})
public class SysCategoryController
extends BaseController<SysCategoryManager, SysCategory> {
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    IdGenerator idGenerator;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u7c7b\u6807\u8bc6\u5217\u8868", httpMethod="POST")
    public PageList<SysCategory> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysCategory> queryFilter) throws Exception {
        return this.sysCategoryManager.query(queryFilter);
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6807\u8bc6json", httpMethod="GET")
    public SysCategory edit(@ApiParam(name="id", value="\u4e3b\u952e") @RequestParam String id) throws Exception {
        SysCategory sysCategory = null;
        if (StringUtil.isNotEmpty((String)id)) {
            sysCategory = (SysCategory)this.sysCategoryManager.get((Serializable)((Object)id));
        }
        return sysCategory;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5206\u7c7b\u6807\u8bc6", httpMethod="POST")
    public CommonResult<String> save(@ApiParam(name="sysCategory", value="\u6807\u8bc6\u5bf9\u8c61") @RequestBody SysCategory sysCategory) throws Exception {
        boolean isKeyExist;
        String id = sysCategory.getId();
        String groupKey = sysCategory.getGroupKey();
        if (StringUtil.isEmpty((String)id)) {
            id = null;
        }
        if (isKeyExist = this.sysCategoryManager.isKeyExist(id, groupKey).booleanValue()) {
            return new CommonResult(false, "\u8f93\u5165\u7684\u5206\u7c7b\u7ec4\u4e3b\u952e\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728!");
        }
        try {
            if (StringUtil.isEmpty((String)id)) {
                sysCategory.setId(this.idGenerator.getSuid());
                sysCategory.setFlag(Integer.valueOf(0));
                sysCategory.setSn(Integer.valueOf(0));
                sysCategory.setCreateOrgId(ContextUtil.getCurrentGroupId());
                this.sysCategoryManager.create((Model)sysCategory);
                return new CommonResult(true, "\u6dfb\u52a0\u7cfb\u7edf\u5206\u7c7b\u7ec4\u503c\u8868\u6210\u529f");
            }
            sysCategory.setGroupKey(groupKey);
            this.sysCategoryManager.update((Model)sysCategory);
            return new CommonResult(true, "\u66f4\u65b0\u7cfb\u7edf\u5206\u7c7b\u7ec4\u503c\u8868\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25");
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6807\u8bc6", httpMethod="DELETE", notes="\u5206\u7c7b\u6807\u8bc6")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u591a\u4e2a\u7528\u201c,\u201d\u53f7\u5206\u9694") @RequestParam String ids) throws Exception {
        String[] aryIds = StringUtil.getStringAryByStr((String)ids);
        this.sysCategoryManager.removeByIds(aryIds);
        return new CommonResult(true, "\u5220\u9664\u6210\u529f");
    }
}

