/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.activemq.model.JmsSysTypeChangeMessage;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.context.BaseContext;
import com.artfess.base.controller.BaseController;
import com.artfess.base.exception.NotFoundException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.jms.JmsProducer;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.constants.CategoryConstants;
import com.artfess.sysConfig.persistence.manager.DataDictManager;
import com.artfess.sysConfig.persistence.manager.SysCategoryManager;
import com.artfess.sysConfig.persistence.manager.SysTypeManager;
import com.artfess.sysConfig.persistence.model.SysCategory;
import com.artfess.sysConfig.persistence.model.SysType;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/sysType/v1"})
@Api(tags={"\u7cfb\u7edf\u5206\u7c7b"})
@ApiGroup(group={"group_system"})
public class SysTypeController
extends BaseController<SysTypeManager, SysType> {
    @Resource
    SysTypeManager sysTypeManager;
    @Resource
    SysCategoryManager sysCategoryManager;
    @Resource
    IUserService iUserService;
    @Resource
    JmsProducer jmsProducer;
    @Resource
    DataDictManager dataDictManager;
    @Resource
    BaseContext baseContext;

    @RequestMapping(value={"list"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5206\u7c7b", httpMethod="POST", notes="\u7cfb\u7edf\u5206\u7c7b")
    public PageList<SysType> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysType> queryFilter) throws Exception {
        return this.sysTypeManager.query(queryFilter);
    }

    @RequestMapping(value={"editJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u603b\u5206\u7c7b\u8868\u3002\u7528\u4e8e\u663e\u793a\u5e73\u7ea7\u6216\u6811\u5c42\u6b21\u7ed3\u6784\u7684\u5206\u7c7b\uff0c\u53ef\u4ee5\u5141\u8bb8\u4efb\u4f55\u5c42\u6b21\u7ed3\u6784", httpMethod="GET", notes="\u7cfb\u7edf\u5206\u7c7b")
    public Map<String, Object> editJson(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id, @ApiParam(name="isRoot", value="\u662f\u5426\u662f\u6839\u8282\u70b9\uff0c1=\u6839\u8282\u70b9\uff0c0=\u5176\u4ed6\u8282\u70b9", required=false) @RequestParam int isRoot, @ApiParam(name="parentId", value="\u7236\u8282\u70b9ID", required=false) @RequestParam String parentId, @ApiParam(name="isPriNode", value="\u662f\u5426\u662f\u79c1\u6709\u7684\u8282\u70b9\uff0c1=\u79c1\u6709\u8282\u70b9\uff0c0=\u666e\u901a\u8282\u70b9", required=false) @RequestParam int isPriNode) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        String parentName = "";
        SysType sysType = null;
        boolean isAdd = false;
        boolean isDict = false;
        if (StringUtil.isNotEmpty((String)id)) {
            sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)id));
            parentId = sysType.getParentId();
            isDict = CategoryConstants.CAT_DIC.key().equals(sysType.getTypeGroupKey());
            if (!"0".equals(sysType.getOwnerId())) {
                isPriNode = 1;
            }
        } else {
            SysType sysTypeTemp = this.sysTypeManager.getInitSysType(isRoot, parentId);
            parentName = sysTypeTemp.getName();
            sysType = new SysType();
            sysType.setStruType(sysTypeTemp.getStruType());
            sysType.setTypeGroupKey(sysTypeTemp.getTypeGroupKey());
            isDict = CategoryConstants.CAT_DIC.key().equals(sysTypeTemp.getTypeGroupKey());
            isAdd = true;
        }
        map.put("sysType", sysType);
        map.put("isAdd", isAdd);
        map.put("isRoot", isRoot);
        map.put("isDict", isDict);
        map.put("parentId", parentId);
        map.put("parentName", parentName);
        map.put("isPriNode", isPriNode);
        map.put("isPriNode", isPriNode);
        return map;
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7cfb\u7edf\u5206\u7c7b\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u7cfb\u7edf\u5206\u7c7b")
    public SysType getJson(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id) throws Exception {
        SysType sysType = new SysType();
        if (StringUtil.isNotEmpty((String)id) && BeanUtils.isEmpty((Object)(sysType = (SysType)this.sysTypeManager.get((Serializable)((Object)id))))) {
            sysType = this.sysTypeManager.getByKey(id);
        }
        return sysType;
    }

    @RequestMapping(value={"getSysTypeByType"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7ec4\u522b\u540d\u548c\u5206\u7c7b\u522b\u540d\u83b7\u53d6\u7cfb\u7edf\u5206\u7c7b", httpMethod="GET", notes="\u7cfb\u7edf\u5206\u7c7b")
    public SysType getSysTypeByType(@ApiParam(name="group", value="\u5206\u7ec4\u7f16\u7801", required=true) @RequestParam String group, @ApiParam(name="typeKey", value="\u5206\u7c7b\u7f16\u7801", required=true) @RequestParam String typeKey) throws Exception {
        return this.sysTypeManager.getByTypeKeyAndGroupKey(group, typeKey);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5206\u7c7b\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u7cfb\u7edf\u5c5e\u6027\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="sysType", value="\u5206\u7c7b", required=true) @RequestBody SysType sysType, @ApiParam(name="parentId", value="\u7236\u8282\u70b9", required=true) @RequestParam String parentId, @ApiParam(name="isRoot", value="\u662f\u5426\u6839\u8282\u70b9", required=false) @RequestParam int isRoot, @ApiParam(name="isPriNode", value="\u662f\u5426\u662f\u79c1\u6709\u7684\u5206\u7c7b", required=false) @RequestParam int isPriNode) throws Exception {
        boolean isKeyExist;
        String resultMsg = null;
        String id = sysType.getId();
        String typeKey = sysType.getTypeKey();
        String typeGroupKey = sysType.getTypeGroupKey();
        String curUserId = ContextUtil.getCurrentUserId();
        if (StringUtil.isEmpty((String)id)) {
            id = null;
        }
        if (isKeyExist = this.sysTypeManager.isKeyExist(id, typeGroupKey, typeKey)) {
            resultMsg = "\u8f93\u5165\u7684\u5206\u7c7bkey\u3010" + typeKey + "\u3011\u5df2\u5b58\u5728!";
            return new CommonResult(false, resultMsg);
        }
        try {
            if (StringUtil.isEmpty((String)id)) {
                SysType parentSysType;
                if (isRoot != 1 && BeanUtils.isNotEmpty((Object)(parentSysType = (SysType)this.sysTypeManager.get((Serializable)((Object)parentId))))) {
                    parentSysType.setIsLeaf('N');
                    this.sysTypeManager.update((Model)parentSysType);
                }
                SysType sysTypeTemp = this.sysTypeManager.getInitSysType(isRoot, parentId);
                if (!typeGroupKey.equals(CategoryConstants.CAT_DIC.key())) {
                    sysType.setStruType(sysTypeTemp.getStruType());
                }
                if (isPriNode == 1) {
                    sysType.setOwnerId(curUserId);
                } else {
                    sysType.setOwnerId("0");
                }
                sysType.setTypeGroupKey(typeGroupKey);
                sysType.setTypeKey(typeKey);
                sysType.setPath(sysTypeTemp.getPath());
                sysType.setParentId(parentId);
                sysType.setId(sysTypeTemp.getId());
                sysType.setDepth(Integer.valueOf(1));
                sysType.setSn(Integer.valueOf(0));
                sysType.setIsLeaf('Y');
                this.sysTypeManager.create((Model)sysType);
                resultMsg = "\u6dfb\u52a0\u5206\u7c7b\u6210\u529f";
                return new CommonResult(true, resultMsg);
            }
            sysType.setSn(Integer.valueOf(0));
            SysType oldType = (SysType)this.sysTypeManager.get((Serializable)((Object)sysType.getId()));
            this.sysTypeManager.update((Model)sysType);
            this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage(typeGroupKey, sysType.getId(), sysType.getName(), oldType.getName(), Integer.valueOf(1)));
            resultMsg = "\u66f4\u65b0\u5206\u7c7b\u6210\u529f";
            return new CommonResult(true, resultMsg);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u66f4\u65b0\u5931\u8d25");
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u5206\u7c7b", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u5206\u7c7b")
    public CommonResult<String> remove(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id) throws Exception {
        try {
            this.dataDictManager.delByDictTypeId(id);
            this.sysTypeManager.delByIds(id);
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25");
        }
    }

    @RequestMapping(value={"sysTypeTree"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u7c7b\u6811", httpMethod="POST", notes="\u5206\u7c7b\u6811")
    public Map<String, Object> tree() throws Exception {
        List list = this.sysCategoryManager.list();
        SysCategory sysCategory = (SysCategory)list.get(0);
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("sysCategoryList", list);
        map.put("sysCategory", sysCategory);
        return map;
    }

    @RequestMapping(value={"getByParentId"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u7236\u8282\u70b9\u83b7\u53d6\u5206\u7c7b", httpMethod="GET", notes="\u6839\u636e\u7236\u8282\u70b9\u83b7\u53d6\u5206\u7c7b")
    public List<SysType> getByParentId(@ApiParam(name="catId", value="\u5206\u7c7bid", required=true, defaultValue="0") @RequestParam String catId) throws Exception {
        ArrayList<SysType> listSysType = new ArrayList<SysType>();
        SysCategory sysCategory = (SysCategory)this.sysCategoryManager.get((Serializable)((Object)catId.toString()));
        if (BeanUtils.isEmpty((Object)sysCategory)) {
            return listSysType;
        }
        SysType sysType = new SysType();
        sysType.setId(sysCategory.getId());
        sysType.setName(sysCategory.getName());
        sysType.setParentId("0");
        sysType.setOpen("true");
        sysType.setTypeKey(sysCategory.getGroupKey());
        List list = this.sysTypeManager.getByGroupKey(sysCategory.getGroupKey());
        for (SysType entity : list) {
            SysType sysTypes = new SysType();
            sysTypes = entity;
            sysTypes.setOpen("true");
            List sys_Type = this.sysTypeManager.getByParentId(sysTypes.getId());
            if (sys_Type != null && sys_Type.size() == 0) {
                sysTypes.setIsParent("false");
            }
            listSysType.add(entity);
        }
        listSysType.add(0, sysType);
        return listSysType;
    }

    @RequestMapping(value={"sysTypeSortList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f\u5217\u8868\u9875\u9762", httpMethod="POST", notes="\u6392\u5e8f\u5217\u8868\u9875\u9762")
    public List<SysType> sortList(@ApiParam(name="id", value="\u4e3b\u952e", required=true, defaultValue="-1") @RequestParam String id) throws Exception {
        String curUserId = ContextUtil.getCurrentUserId();
        List sysTypes = this.sysTypeManager.getPrivByPartId(id, curUserId);
        return sysTypes;
    }

    @RequestMapping(value={"sort"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6392\u5e8f", httpMethod="POST", notes="\u6392\u5e8f")
    public CommonResult<String> sort(@ApiParam(name="typeIds", value="\u5206\u7c7bid", required=true) @RequestParam String[] typeIds) throws Exception {
        try {
            if (BeanUtils.isNotEmpty((Object)typeIds)) {
                for (int i = 0; i < typeIds.length; ++i) {
                    String typeId = typeIds[i];
                    int sn = i + 1;
                    this.sysTypeManager.updSn(typeId, sn);
                }
            }
        }
        catch (Exception e) {
            return new CommonResult(false, "\u6392\u5e8f\u5931\u8d25");
        }
        return new CommonResult(true, "\u6392\u5e8f\u5b8c\u6210");
    }

    @RequestMapping(value={"getTypesByKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b")
    public List<SysType> getTypesByKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        SysCategory sysCategory = this.sysCategoryManager.getByTypeKey(typeKey);
        ArrayList<SysType> listSysType = new ArrayList<SysType>();
        if (BeanUtils.isEmpty((Object)sysCategory)) {
            return listSysType;
        }
        SysType sysType = new SysType();
        sysType.setId(sysCategory.getId());
        sysType.setName(sysCategory.getName());
        sysType.setParentId("0");
        sysType.setOpen("true");
        sysType.setTypeKey(sysCategory.getGroupKey());
        List list = this.sysTypeManager.getByGroupKey(sysCategory.getGroupKey());
        listSysType.addAll(list);
        listSysType.add(sysType);
        List rtnList = BeanUtils.listToTree(listSysType);
        return rtnList;
    }

    @RequestMapping(value={"getTreeDateByTypeKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b\u6811", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5key\u83b7\u53d6\u5206\u7c7b\u6811")
    public List<SysType> getTreeDateByTypeKey(@ApiParam(name="typeKey", value="\u5206\u7c7bkey", required=true) @RequestParam String typeKey) throws Exception {
        List groupTypes = null;
        if (StringUtil.isNotEmpty((String)typeKey)) {
            groupTypes = this.sysTypeManager.getChildByTypeKey(typeKey);
        }
        List rtnList = BeanUtils.listToTree(groupTypes);
        return rtnList;
    }

    @RequestMapping(value={"getByGroupKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u53ef\u4ee5\u7ec4key\u83b7\u53d6\u5206\u7c7b", httpMethod="GET", notes="\u6839\u636e\u53ef\u4ee5\u7ec4key\u83b7\u53d6\u5206\u7c7b")
    public List<SysType> getByGroupKey(@ApiParam(name="groupKey", value="\u5206\u7c7b\u7ec4key", required=true) @RequestParam String groupKey) throws Exception {
        List types = null;
        if (StringUtil.isNotEmpty((String)groupKey)) {
            types = this.sysTypeManager.getByGroupKey(groupKey);
        }
        List rtnList = BeanUtils.listToTree(types);
        return rtnList;
    }

    @RequestMapping(value={"updateEntitySysType"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u66f4\u65b0\u5bf9\u8c61\u7684\u5206\u7c7b\u4fe1\u606f", httpMethod="GET", notes="\u66f4\u65b0\u5bf9\u8c61\u7684\u5206\u7c7b\u4fe1\u606f")
    public CommonResult<String> updateEntitySysType(@ApiParam(name="typeID", value="\u8981\u8bbe\u7f6e\u4e3a\u7684\u5206\u7c7bid", required=true) @RequestParam String typeID, @ApiParam(name="entityIds", value="\u8981\u66f4\u65b0\u7684\u5b9e\u4f53id", required=true) @RequestParam String entityIds) throws Exception {
        SysType type = (SysType)this.sysTypeManager.get((Serializable)((Object)typeID));
        if (StringUtil.isEmpty((String)entityIds)) {
            throw new RequiredException("\u8bf7\u4f20\u5165\u8981\u66f4\u65b0\u7684\u5b9e\u4f53id");
        }
        if (BeanUtils.isEmpty((Object)type)) {
            throw new NotFoundException("\u6839\u636e\u6240\u4f20\u5206\u7c7bID\u672a\u627e\u5230\u5206\u7c7b");
        }
        String currentTenantId = this.baseContext.getCurrentTenantId();
        this.jmsProducer.sendToTopic((Object)new JmsSysTypeChangeMessage(type.getTypeGroupKey(), type.getId(), type.getName(), Integer.valueOf(3), entityIds, currentTenantId));
        return new CommonResult("\u66f4\u65b0\u5206\u7c7b\u6210\u529f");
    }
}

