/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.id.IdGenerator;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.HttpUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.ZipUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.sysConfig.persistence.manager.SysIdentityManager;
import com.artfess.sysConfig.persistence.model.SysIdentity;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.File;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@RestController
@RequestMapping(value={"/sys/identity/v1"})
@Api(tags={"\u5355\u636e\u53f7\u89c4\u5219"})
@ApiGroup(group={"group_system"})
public class SysIdentityController
extends BaseController<SysIdentityManager, SysIdentity> {
    @Resource
    SysIdentityManager identityManager;
    @Resource
    protected IdGenerator idGenerator;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5355\u636e\u53f7\u89c4\u5219\u751f\u6210\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u5355\u636e\u53f7\u89c4\u5219\u751f\u6210\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<SysIdentity> listJson(HttpServletRequest request, HttpServletResponse reponse, @ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIdentity> queryFilter) throws Exception {
        return this.identityManager.query(queryFilter);
    }

    @RequestMapping(value={"getAll"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u5355\u636e\u53f7\u89c4\u5219", httpMethod="POST", notes="\u5355\u636e\u53f7\u89c4\u5219\u751f\u6210\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public List<SysIdentity> getAll() throws Exception {
        return this.identityManager.list();
    }

    @RequestMapping(value={"getById"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636eid\u83b7\u53d6\u5355\u636e\u53f7\u89c4\u5219", httpMethod="GET", notes="\u6839\u636eid\u83b7\u53d6\u5355\u636e\u53f7\u89c4\u5219")
    public Object getById(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="id", value="\u5355\u636e\u53f7\u89c4\u5219\u5b9a\u4e49Id", required=true) @RequestParam String id) throws Exception {
        SysIdentity identity = (SysIdentity)this.identityManager.get((Serializable)((Object)id));
        return identity;
    }

    @RequestMapping(value={"getJson"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5355\u636e\u53f7\u89c4\u5219\u660e\u7ec6\u9875\u9762", httpMethod="GET", notes="\u5355\u636e\u53f7\u89c4\u5219\u660e\u7ec6\u9875\u9762")
    public Object get(HttpServletRequest request, HttpServletResponse response, @ApiParam(name="id", value="\u5355\u636e\u53f7\u89c4\u5219\u5b9a\u4e49Id", required=true) @RequestParam String id) throws Exception {
        SysIdentity identity = null;
        if (StringUtil.isNotEmpty((String)id)) {
            identity = (SysIdentity)this.identityManager.get((Serializable)((Object)id));
        }
        return identity;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5355\u636e\u53f7\u89c4\u5219", httpMethod="POST", notes="\u4fdd\u5b58\u5355\u636e\u53f7\u89c4\u5219")
    public Object save(@ApiParam(name="identity", value="\u5355\u636e\u53f7\u89c4\u5219\u5b9a\u4e49", required=true) @RequestBody SysIdentity identity) throws Exception {
        String resultMsg = null;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", identity.getId());
        params.put("alias", identity.getAlias());
        boolean rtn = this.identityManager.isAliasExisted(params);
        if (rtn) {
            return new CommonResult(false, "\u5355\u636e\u53f7\u89c4\u5219\u522b\u540d\u5df2\u7ecf\u5b58\u5728", null);
        }
        try {
            if (StringUtil.isEmpty((String)identity.getId())) {
                identity.setId(this.idGenerator.getSuid());
                this.identityManager.create((Model)identity);
                resultMsg = "\u6dfb\u52a0\u5355\u636e\u53f7\u89c4\u5219\u751f\u6210\u6210\u529f";
            } else {
                this.identityManager.update((Model)identity);
                resultMsg = "\u66f4\u65b0\u5355\u636e\u53f7\u89c4\u5219\u751f\u6210\u6210\u529f";
            }
            return new CommonResult(true, resultMsg, null);
        }
        catch (Exception e) {
            return new CommonResult(false, resultMsg, null);
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u5355\u636e\u53f7\u89c4\u5219", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u5355\u636e\u53f7\u89c4\u5219")
    public Object remove(@ApiParam(name="ids", value="\u5355\u636e\u53f7\u89c4\u5219\u5b9a\u4e49Ids", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = StringUtil.getStringAryByStr((String)ids);
            this.identityManager.removeByIds(Arrays.asList(aryIds));
            return new CommonResult(true, "\u5220\u9664\u6210\u529f", null);
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u5931\u8d25", null);
        }
    }

    @RequestMapping(value={"preview"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5355\u636e\u53f7\u89c4\u5219\u9884\u89c8", httpMethod="GET", notes="\u5355\u636e\u53f7\u89c4\u5219\u9884\u89c8")
    public PageList<SysIdentity> preview(@ApiParam(name="alias", value="\u5355\u636e\u53f7\u89c4\u5219\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        List identities = this.identityManager.getPreviewIden(alias);
        return new PageList(identities);
    }

    @RequestMapping(value={"getNextIdByAlias"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u4e0b\u4e00\u4e2a\u5355\u636e\u53f7\u89c4\u5219", httpMethod="GET", notes="\u83b7\u53d6\u4e0b\u4e00\u4e2a\u5355\u636e\u53f7\u89c4\u5219")
    public CommonResult<String> getNextIdByAlias(@ApiParam(name="alias", value="\u5355\u636e\u53f7\u89c4\u5219\u522b\u540d", required=true) @RequestParam String alias) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("id", null);
        params.put("alias", alias);
        if (this.identityManager.isAliasExisted(params)) {
            String nextId = this.identityManager.nextId(alias);
            return new CommonResult(true, "\u83b7\u53d6\u5355\u636e\u53f7\u89c4\u5219\u6210\u529f\uff01", (Object)nextId);
        }
        return new CommonResult(false, "\u83b7\u53d6\u5355\u636e\u53f7\u89c4\u5219\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"export"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u51fa\u6570\u636e", httpMethod="GET", notes="\u5bfc\u51fa\u6570\u636e")
    public void export(HttpServletResponse response, HttpServletRequest request, @ApiParam(name="ids", value="ids", required=true) @RequestParam String ids) throws Exception {
        String[] idList = ids.split(",");
        String fileName = "identity_" + DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"yyyy_MMdd_HHmm");
        String json = this.identityManager.export(idList);
        HttpUtil.downLoadFile((HttpServletRequest)request, (HttpServletResponse)response, (String)json, (String)"identity.json", (String)fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"import"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u5355\u636e\u53f7\u89c4\u5219", httpMethod="POST", notes="\u5bfc\u5165\u5355\u636e\u53f7\u89c4\u5219")
    public CommonResult<String> importIdentity(MultipartHttpServletRequest request, HttpServletResponse response) throws Exception {
        MultipartFile file = request.getFile("file");
        String unZipFilePath = "";
        try {
            String rootRealPath = (FileUtil.getIoTmpdir() + "/attachFiles/unZip/").replace("/", File.separator);
            FileUtil.createFolder((String)rootRealPath, (boolean)true);
            String name = file.getOriginalFilename();
            String fileDir = StringUtil.substringBeforeLast((String)name, (String)".");
            ZipUtil.unZipFile((MultipartFile)file, (String)rootRealPath);
            unZipFilePath = rootRealPath + File.separator + fileDir;
            this.identityManager.importFile(unZipFilePath);
            CommonResult commonResult = new CommonResult(true, "\u5bfc\u5165\u6210\u529f");
            return commonResult;
        }
        catch (Exception e) {
            CommonResult commonResult = new CommonResult(false, "\u5bfc\u5165\u5931\u8d25\uff1a" + e.getMessage());
            return commonResult;
        }
        finally {
            File zipFile;
            if (StringUtil.isNotEmpty((String)unZipFilePath) && (zipFile = new File(unZipFilePath)).exists()) {
                zipFile.delete();
            }
        }
    }
}

