/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.Base64;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.portal.model.SysIndexColumn;
import com.artfess.portal.model.SysIndexLayout;
import com.artfess.portal.model.SysIndexMyLayout;
import com.artfess.portal.params.MyLayoutVo;
import com.artfess.portal.persistence.manager.SysIndexColumnManager;
import com.artfess.portal.persistence.manager.SysIndexLayoutManager;
import com.artfess.portal.persistence.manager.SysIndexMyLayoutManager;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserService;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/portal/sysIndexMyLayout/v1/"})
@Api(tags={"\u6211\u7684\u95e8\u6237\u5e03\u5c40"})
@ApiGroup(group={"group_system"})
public class SysIndexMyLayoutController
extends BaseController<SysIndexMyLayoutManager, SysIndexMyLayout> {
    @Resource
    private SysIndexLayoutManager sysIndexLayoutManager;
    @Resource
    private SysIndexMyLayoutManager sysIndexMyLayoutManager;
    @Resource
    protected SysIndexColumnManager sysIndexColumnManager;
    @Resource
    IUserService ius;
    @Resource
    private SysIndexColumnManager sysIndexColumnService;

    @RequestMapping(value={"setValid"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4e00\u4e2a\u6709\u6548\u5e03\u5c40", httpMethod="GET", notes="\u8bbe\u7f6e\u4e00\u4e2a\u6709\u6548\u5e03\u5c40")
    public CommonResult<String> setValid(@RequestParam String id) throws Exception {
        this.sysIndexMyLayoutManager.setValid(id);
        return new CommonResult(true, "\u8bbe\u7f6e\u6210\u529f");
    }

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6211\u7684\u6240\u6709\u5e03\u5c40", httpMethod="POST", notes="\u83b7\u53d6\u6211\u7684\u6240\u6709\u5e03\u5c40")
    public PageList<SysIndexMyLayout> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexMyLayout> queryFilter) throws Exception {
        queryFilter.addFilter("USER_ID", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL);
        return this.sysIndexMyLayoutManager.query(queryFilter);
    }

    @RequestMapping(value={"design"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u8ba1\u6211\u7684\u9996\u9875\u5e03\u5c40", httpMethod="GET", notes="\u8bbe\u8ba1\u6211\u7684\u9996\u9875\u5e03\u5c40")
    public MyLayoutVo design() throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        List list = this.sysIndexLayoutManager.list();
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("IS_PUBLIC", (Object)0, QueryOP.EQUAL);
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<SysIndexColumn> columnList = this.sysIndexColumnManager.getHashRightColumnList((QueryFilter<SysIndexColumn>)queryFilter, params, true, (short)0, user);
        Map<String, List<SysIndexColumn>> columnMap = this.sysIndexColumnManager.getColumnMap(columnList);
        SysIndexMyLayout sysIndexMyLayout = this.sysIndexMyLayoutManager.getLayoutList(user.getUserId(), columnList);
        for (SysIndexLayout sysIndexLayout : list) {
            sysIndexLayout.setTemplateHtml(Base64.getFromBase64((String)sysIndexLayout.getTemplateHtml()));
        }
        return new MyLayoutVo(list, columnMap, sysIndexMyLayout);
    }

    @RequestMapping(value={"designMyLayout"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u8ba1\u6211\u7684\u9996\u9875\u5e03\u5c40", httpMethod="GET", notes="\u8bbe\u8ba1\u6211\u7684\u9996\u9875\u5e03\u5c40")
    public Map<String, Object> designMyLayout(@ApiParam(name="id", value="\u4e3b\u952e", required=false) @RequestParam String id, @ApiParam(name="layoutType", value="\u90e8\u95e8id", required=false) @RequestParam short layoutType) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        IUser user = ContextUtil.getCurrentUser();
        QueryFilter queryFilter = QueryFilter.build().withPage(new PageBean(Integer.valueOf(1), PageBean.WITHOUT_PAGE));
        queryFilter.addFilter("IS_PUBLIC", (Object)layoutType, QueryOP.EQUAL);
        HashMap<String, Object> params = new HashMap<String, Object>();
        List<SysIndexColumn> columnList = this.sysIndexColumnService.getHashRightColumnList((QueryFilter<SysIndexColumn>)queryFilter, params, false, layoutType, user);
        Map<String, List<Map<String, Object>>> columnMap = this.sysIndexColumnService.getColumnMap2(columnList);
        SysIndexMyLayout sysIndexMyLayout = (SysIndexMyLayout)this.sysIndexMyLayoutManager.get((Serializable)((Object)id));
        map.put("columnMap", columnMap);
        map.put("sysIndexLayout", (Object)sysIndexMyLayout);
        return map;
    }

    @RequestMapping(value={"getSysIndexLayoutList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u7cfb\u7edf\u9996\u9875\u5e03\u5c40\u96c6\u5408", httpMethod="POST", notes="\u83b7\u53d6\u7cfb\u7edf\u9996\u9875\u5e03\u5c40\u96c6\u5408")
    public List<SysIndexLayout> getSysIndexLayoutList() throws Exception {
        List list = this.sysIndexLayoutManager.list();
        return list;
    }

    @RequestMapping(value={"getLayoutList"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5e03\u5c40\u96c6\u5408", httpMethod="GET", notes="\u83b7\u53d6\u5e03\u5c40\u96c6\u5408")
    public List<SysIndexLayout> getLayoutList() throws Exception {
        List list = this.sysIndexLayoutManager.list();
        for (SysIndexLayout sysIndexLayout : list) {
            sysIndexLayout.setTemplateHtml(Base64.getFromBase64((String)sysIndexLayout.getTemplateHtml()));
        }
        return list;
    }

    @RequestMapping(value={"getColumnMap"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5c55\u793a\u7684\u5e03\u5c40", httpMethod="POST", notes="\u83b7\u53d6\u5c55\u793a\u7684\u5e03\u5c40")
    public Map<String, List<SysIndexColumn>> getColumnMap(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexColumn> queryFilter, @ApiParam(name="param", value="\u8bf7\u6c42\u53c2\u6570") @RequestParam String param) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        Map params = JsonUtil.toMap((String)param);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        queryFilter.setPageBean(pageBean);
        queryFilter.addFilter("IS_PUBLIC", (Object)0, QueryOP.EQUAL);
        List<SysIndexColumn> columnList = this.sysIndexColumnManager.getHashRightColumnList(queryFilter, params, true, (short)0, user);
        Map<String, List<SysIndexColumn>> columnMap = this.sysIndexColumnManager.getColumnMap(columnList);
        return columnMap;
    }

    @RequestMapping(value={"getSysIndexMyLayout"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u5f53\u524d\u7684\u5e03\u5c40", httpMethod="POST", notes="\u83b7\u53d6\u5f53\u524d\u7684\u5e03\u5c40")
    public SysIndexMyLayout getSysIndexMyLayout(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<SysIndexColumn> queryFilter, @ApiParam(name="param", value="\u8bf7\u6c42\u53c2\u6570") @RequestParam String param) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        String userId = user.getUserId();
        Map params = JsonUtil.toMap((String)param);
        PageBean pageBean = queryFilter.getPageBean();
        pageBean.setPageSize(PageBean.WITHOUT_PAGE.intValue());
        queryFilter.setPageBean(pageBean);
        queryFilter.addFilter("IS_PUBLIC", (Object)0, QueryOP.EQUAL);
        List<SysIndexColumn> columnList = this.sysIndexColumnManager.getHashRightColumnList(queryFilter, params, true, (short)0, user);
        SysIndexMyLayout sysIndexMyLayout = this.sysIndexMyLayoutManager.getLayoutList(userId, columnList);
        return sysIndexMyLayout;
    }

    @RequestMapping(value={"saveLayout"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u9996\u9875\u5e03\u5c40", httpMethod="POST", notes="\u4fdd\u5b58\u9996\u9875\u5e03\u5c40")
    public CommonResult<String> saveLayout(@ApiParam(name="designHtml", value="\u8bbe\u8ba1\u6a21\u677f", required=true) @RequestBody String designHtml) throws Exception {
        try {
            String userId = ContextUtil.getCurrentUserId();
            this.sysIndexMyLayoutManager.save("", designHtml, userId);
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage());
        }
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u6211\u7684\u5e03\u5c40", httpMethod="POST", notes="\u4fdd\u5b58\u9996\u9875\u5e03\u5c40")
    public CommonResult<String> save(@ApiParam(name="designHtml", value="\u8bbe\u8ba1\u6a21\u677f", required=true) @RequestBody SysIndexMyLayout sysIndexMyLayout) throws Exception {
        try {
            sysIndexMyLayout.setUserId(ContextUtil.getCurrentUserId());
            if (StringUtil.isEmpty((String)sysIndexMyLayout.getId())) {
                this.sysIndexMyLayoutManager.save((Object)sysIndexMyLayout);
                return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f");
            }
            this.sysIndexMyLayoutManager.update((Model)sysIndexMyLayout);
            return new CommonResult(true, "\u66f4\u65b0\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage());
        }
    }

    @RequestMapping(value={"getMyLayout"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u9996\u9875\u5e03\u5c40\u6a21\u677f\uff08\u9ed8\u8ba4\uff0cbase64\u7f16\u7801\uff09", httpMethod="GET", notes="\u83b7\u53d6\u9996\u9875\u5e03\u5c40\u6a21\u677f\uff08\u9ed8\u8ba4\uff0cbase64\u7f16\u7801\uff09")
    public CommonResult<String> getMyLayout() throws Exception {
        try {
            String currentUserId = ContextUtil.getCurrentUserId();
            SysIndexMyLayout myLayout = this.sysIndexMyLayoutManager.getByUser(currentUserId);
            if (BeanUtils.isNotEmpty((Object)((Object)myLayout))) {
                return new CommonResult(true, "\u83b7\u53d6\u6211\u7684\u5e03\u5c40\u6210\u529f\uff01", (Object)myLayout.getDesignHtml());
            }
        }
        catch (Exception e) {
            return new CommonResult(false, "\u83b7\u53d6\u6211\u7684\u5e03\u5c40\u5931\u8d25\uff01", (Object)"");
        }
        return new CommonResult(false, "\u672a\u8bbe\u7f6e\u6211\u7684\u9996\u9875\u5e03\u5c40\uff01", (Object)"");
    }

    @RequestMapping(value={"deleteLayout"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u9996\u9875\u5e03\u5c40", httpMethod="DELETE", notes="\u5220\u9664\u9996\u9875\u5e03\u5c40")
    public CommonResult<String> deleteLayout(@ApiParam(name="ids", value="\u4e3b\u952e", required=true) @RequestParam String ids) throws Exception {
        try {
            this.sysIndexMyLayoutManager.removeByIds(new String[]{ids});
            return new CommonResult(true, "\u5220\u9664\u6210\u529f");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage());
        }
    }

    @RequestMapping(value={"deleteMyLayout"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5220\u9664\u6211\u7684\u5e03\u5c40", httpMethod="DELETE", notes="\u5220\u9664\u6211\u7684\u5e03\u5c40")
    public CommonResult<String> deleteMyLayout() throws Exception {
        try {
            String userId = ContextUtil.getCurrentUserId();
            this.sysIndexMyLayoutManager.removeByUserId(userId);
            return new CommonResult(true, "\u6210\u529f\u5220\u9664\u6211\u7684\u5e03\u5c40");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage());
        }
    }
}

