/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.kh.manager.impl;

import com.artfess.base.id.IdGenerator;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.portal.kh.dao.KhResultDao;
import com.artfess.portal.kh.manager.KhResultDetailsManager;
import com.artfess.portal.kh.manager.KhResultManager;
import com.artfess.portal.kh.manager.KhSchemePlanManager;
import com.artfess.portal.kh.model.KhAssessScheme;
import com.artfess.portal.kh.model.KhResult;
import com.artfess.portal.kh.model.KhResultDetails;
import com.artfess.portal.kh.model.KhSchemePlan;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class KhResultManagerImpl
extends BaseManagerImpl<KhResultDao, KhResult>
implements KhResultManager {
    @Autowired
    private KhSchemePlanManager schemePlanManager;
    @Autowired
    private KhResultDetailsManager resultDetailsManager;
    @Resource
    IdGenerator idGenerator;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createResult(String planId) {
        KhSchemePlan plan = this.schemePlanManager.findById(planId);
        Assert.notNull((Object)((Object)plan), (String)"\u8003\u6838\u8ba1\u5212\u4e0d\u5b58\u5728");
        ArrayList list = Lists.newArrayList();
        ArrayList details = Lists.newArrayList();
        plan.getPlanObjectList().forEach(khPlanObject -> {
            long id = this.idGenerator.nextId();
            KhResult result = new KhResult();
            result.setId(String.valueOf(id));
            result.setPlanId(planId);
            result.setSchemeId(plan.getSchemeId());
            result.setTaskName(plan.getPlanName());
            result.setStartDate(plan.getStartDate());
            result.setEndDate(plan.getEndDate());
            result.setObjType(khPlanObject.getObjType());
            result.setObjId(khPlanObject.getObjId());
            result.setObjName(khPlanObject.getObjName());
            result.setPeriod(plan.getPeriod());
            result.setAppraiserId(plan.getAppraiserId());
            result.setAppraiserName(plan.getAppraiserName());
            result.setReviewId(plan.getReviewId());
            result.setReviewName(plan.getReviewName());
            LocalDate now = LocalDate.now();
            if (plan.getStartDate().isAfter(now)) {
                result.setStatus("draft");
            } else {
                result.setStatus("edit");
            }
            list.add(result);
            plan.getScheme().getSchemeIndicatorsList().forEach(khSchemeIndicators -> {
                KhResultDetails resultDetails = new KhResultDetails();
                resultDetails.setResultId(result.getId());
                resultDetails.setSubjectId(khSchemeIndicators.getSubjectId());
                resultDetails.setNature(khSchemeIndicators.getNature());
                resultDetails.setName(khSchemeIndicators.getName());
                resultDetails.setCode(khSchemeIndicators.getCode());
                resultDetails.setContents(khSchemeIndicators.getContents());
                resultDetails.setMode(khSchemeIndicators.getMode());
                resultDetails.setTargetValue(khSchemeIndicators.getTargetValue());
                resultDetails.setUnit(khSchemeIndicators.getUnit());
                resultDetails.setWeight(khSchemeIndicators.getWeight());
                details.add(resultDetails);
            });
        });
        boolean b = this.saveBatch(list);
        if (b) {
            return this.resultDetailsManager.saveBatch(details);
        }
        return b;
    }

    @Override
    public KhResult findById(String id) {
        KhResult result = (KhResult)this.get((Serializable)((Object)id));
        Assert.notNull((Object)((Object)result), (String)"\u8003\u6838\u7ed3\u679c\u4e0d\u5b58\u5728");
        LambdaQueryWrapper lambdaQueryWrapper = new LambdaQueryWrapper();
        lambdaQueryWrapper.eq(KhResultDetails::getResultId, (Object)id);
        List list = this.resultDetailsManager.list((Wrapper)lambdaQueryWrapper);
        result.setDetailsList(list);
        return result;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean createInfo(KhResult t) {
        return false;
    }

    @Override
    public boolean updateInfo(KhResult t) {
        KhResult khResult = (KhResult)this.get((Serializable)((Object)t.getId()));
        Assert.notNull((Object)((Object)khResult), (String)"\u8003\u6838\u7ed3\u679c\u4e0d\u5b58\u5728");
        khResult.setFillDate(LocalDate.now());
        khResult.setAppraiserId(t.getAppraiserId());
        khResult.setAppraiserName(t.getAppraiserName());
        khResult.setReviewId(t.getReviewId());
        khResult.setReviewName(t.getReviewName());
        khResult.setStatus(t.getStatus());
        if ("review".equals(t.getStatus())) {
            khResult.setReviewId(ContextUtil.getCurrentUserId());
            khResult.setReviewName(ContextUtil.getCurrentUserName());
        }
        if ("end".equals(t.getStatus())) {
            khResult.setAppraiserId(ContextUtil.getCurrentUserId());
            khResult.setAppraiserName(ContextUtil.getCurrentUserName());
        }
        BigDecimal totalScore = BigDecimal.ZERO;
        boolean flag = true;
        for (KhResultDetails details : t.getDetailsList()) {
            if (null != details.getActualValue() && null != details.getWeight()) {
                details.setActualScore(details.getWeight().multiply(details.getActualValue()).setScale(2, 4));
                totalScore = totalScore.add(details.getActualScore());
                continue;
            }
            flag = false;
        }
        if (flag) {
            khResult.setStatus("end");
        }
        khResult.setTotalScore(totalScore);
        KhSchemePlan plan = this.schemePlanManager.findById(khResult.getPlanId());
        KhAssessScheme assessScheme = plan.getAssessScheme();
        BigDecimal finalTotalScore = totalScore;
        assessScheme.getDetailsList().forEach(khAssessDetails -> {
            if (khAssessDetails.getMinValue() <= finalTotalScore.doubleValue() && khAssessDetails.getMaxValue() >= finalTotalScore.doubleValue()) {
                khResult.setLevel(khAssessDetails.getName());
            }
        });
        Assert.notNull((Object)((Object)plan), (String)"\u8003\u6838\u8ba1\u5212\u4e0d\u5b58\u5728");
        boolean update = this.updateById((Object)khResult);
        if (update) {
            return this.resultDetailsManager.updateBatchById(t.getDetailsList());
        }
        return update;
    }
}

