/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.portal.util.jvm;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.List;

public class JVMGCUtils {
    private static GarbageCollectorMXBean youngGC;
    private static GarbageCollectorMXBean fullGC;

    public static String getYoungGCName() {
        return youngGC == null ? "" : youngGC.getName();
    }

    public static long getYoungGCCollectionCount() {
        return youngGC == null ? 0L : youngGC.getCollectionCount();
    }

    public static long getYoungGCCollectionTime() {
        return youngGC == null ? 0L : youngGC.getCollectionTime();
    }

    public static String getFullGCName() {
        return fullGC == null ? "" : fullGC.getName();
    }

    public static long getFullGCCollectionCount() {
        return fullGC == null ? 0L : fullGC.getCollectionCount();
    }

    public static long getFullGCCollectionTime() {
        return fullGC == null ? 0L : fullGC.getCollectionTime();
    }

    public static void main(String[] args) {
        ArrayList listRoot = new ArrayList();
        while (true) {
            System.out.println("=======================================================================");
            System.out.println("getYoungGCName: " + JVMGCUtils.getYoungGCName());
            System.out.println("getYoungGCCollectionCount: " + JVMGCUtils.getYoungGCCollectionCount());
            System.out.println("getYoungGCCollectionTime: " + JVMGCUtils.getYoungGCCollectionTime());
            System.out.println("getFullGCName: " + JVMGCUtils.getFullGCName());
            System.out.println("getFullGCCollectionCount: " + JVMGCUtils.getFullGCCollectionCount());
            System.out.println("getFullGCCollectionTime: " + JVMGCUtils.getFullGCCollectionTime());
            ArrayList list = new ArrayList(1000);
            listRoot.add(list);
            try {
                Thread.sleep(3000L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            if (list.size() > 1) {
                list.remove(0);
            }
            Runtime.getRuntime().gc();
        }
    }

    static {
        List<GarbageCollectorMXBean> gcMXBeanList = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcMXBean : gcMXBeanList) {
            String gcName = gcMXBean.getName();
            if (gcName == null) continue;
            if (fullGC == null && (gcName.endsWith("Old Collector") || "ConcurrentMarkSweep".equals(gcName) || "MarkSweepCompact".equals(gcName) || "PS MarkSweep".equals(gcName))) {
                fullGC = gcMXBean;
                continue;
            }
            if (youngGC != null || !gcName.endsWith("Young Generation") && !"ParNew".equals(gcName) && !"Copy".equals(gcName) && !"PS Scavenge".equals(gcName)) continue;
            youngGC = gcMXBean;
        }
    }
}

