package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

/**
 * 归口管理部门
 */
@Getter
public enum TaskTypeEnum {
    //（1：新人三级培训、2：岗前培训、3：转岗培训、4：岗位培训）
    ONE("1", "新人三级培训"),

    TWO("2", "岗前培训"),

    THREE("3", "转岗培训"),

    FOUR("4", "岗位培训"),



    ;

    TaskTypeEnum(String type, String desc){
        this.type = type;
        this.desc = desc;
    }

    private String type;

    private String desc;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        TaskTypeEnum[] values = values();
        for (TaskTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }

    public static String getDesc(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        TaskTypeEnum[] values = values();
        for (TaskTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state.getDesc();
            }
        }
        return null;
    }
}
