/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.StringUtil;
import com.artfess.form.model.Form;
import com.artfess.form.model.FormBusSet;
import com.artfess.form.persistence.manager.FormBusManager;
import com.artfess.form.persistence.manager.FormBusSetManager;
import com.artfess.form.persistence.manager.FormManager;
import com.fasterxml.jackson.databind.JsonNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/formBus/v1"})
@Api(tags={"\u8868\u5355\u6570\u636e\u5904\u7406"})
@ApiGroup(group={"group_form"})
public class FormBusController
extends BaseController<FormBusSetManager, FormBusSet> {
    @Resource
    FormManager bpmFormManager;
    @Resource
    FormBusManager formBusManager;

    @RequestMapping(value={"getList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u6570\u636e", httpMethod="POST", notes="\u83b7\u53d6\u6240\u6709\u7684\u4e1a\u52a1\u6570\u636e")
    public JsonNode getList(@ApiParam(name="formKey", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6eKey") @RequestBody String formKey, @ApiParam(name="param", value="\u4e0a\u4e0b\u6587\u7684\u8bf7\u6c42") @RequestBody Map<String, Object> param) throws Exception {
        return this.formBusManager.getList(formKey, param);
    }

    @RequestMapping(value={"getData"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u660e\u7ec6\u9875\u9762", httpMethod="POST", notes="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u660e\u7ec6\u9875\u9762")
    public JsonNode getJson(@ApiParam(name="id", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6eId") @RequestBody String id, @ApiParam(name="readonly", value="\u662f\u5426\u53ea\u8bfb") @RequestBody boolean readonly, @ApiParam(name="formKey", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6ekey") @RequestBody String formKey) throws Exception {
        return ((FormBusSetManager)this.baseService).getDetail(id, readonly, formKey);
    }

    @RequestMapping(value={"edit"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u7f16\u8f91\u9875\u9762", httpMethod="POST", notes="\u7f16\u8f91\u9875\u9762")
    public CommonResult edit(@ApiParam(name="formKey", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6ekey") @RequestBody String formKey, @ApiParam(name="id", value="id") @RequestBody String id, @ApiParam(name="parentId_", value="\u7236\u7ea7ID") @RequestBody String parentId_) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("url", "/form/form/formBusEdit");
        map.put("id", id);
        map.put("formKey", formKey);
        if (StringUtil.isNotEmpty((String)parentId_)) {
            String[] parentSet = parentId_.split("\\$");
            if (parentSet.length != 2) {
                return new CommonResult(true, null, map);
            }
            map.put("parentKey", parentSet[0]);
            map.put("parentVal", parentSet[1]);
        }
        return new CommonResult(true, null, map);
    }

    @RequestMapping(value={"get"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8be6\u7ec6\u9875\u9762", httpMethod="POST", notes="\u8be6\u7ec6\u9875\u9762")
    public CommonResult get(@ApiParam(name="formKey", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6ekey") @RequestBody String formKey, @ApiParam(name="id", value="id") @RequestBody String id) throws Exception {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("url", "/form/form/formBusEdit");
        map.put("id", id);
        map.put("formKey", formKey);
        map.put("readonly", true);
        return new CommonResult(true, null, map);
    }

    @RequestMapping(value={"treeList"})
    @ResponseBody
    public CommonResult treeList(HttpServletRequest request, HttpServletResponse response, @PathVariable(value="formKey") String formKey) throws Exception {
        FormBusSet formBusSet = ((FormBusSetManager)this.baseService).getByFormKey(formKey);
        Form form = this.bpmFormManager.getMainByFormKey(formKey);
        if (formBusSet.getIsTreeList() != 1) {
            throw new RuntimeException("\u6539\u8868\u5355\u4e0d\u652f\u6301\u6811\u5f62\u5217\u8868\uff01\u8bf7\u4fee\u6539\u8868\u5355\u7684\u4e1a\u52a1\u6570\u636e\u4fdd\u5b58\u7684\u8bbe\u7f6e\uff01");
        }
        HashMap<String, String> mv = new HashMap<String, String>();
        mv.put("url", "/form/form/formBusTreeList");
        mv.put("formName", form.getName());
        mv.put("formKey", formKey);
        mv.put("treeConf", formBusSet.getTreeConf());
        return new CommonResult(true, null, mv);
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value=" \u4fdd\u5b58bo\u6570\u636e", httpMethod="POST", notes="\u4fdd\u5b58bo\u6570\u636e")
    public CommonResult save(@ApiParam(name="formKey", value="\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u4fe1\u606fKey") @RequestBody String formKey, @ApiParam(name="json", value="boJson\u6570\u636e") @RequestBody String json) throws Exception {
        this.formBusManager.saveData(formKey, json);
        return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f", null);
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u8bb0\u5f55", httpMethod="POST", notes="\u6279\u91cf\u5220\u9664\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u8bb0\u5f55")
    public CommonResult remove(@ApiParam(name="id", value="\u4e3b\u952e!\u591a\u4e2aID\u7528,\u5206\u5272") @RequestBody String id, @ApiParam(name="formKey", value="key") @RequestBody String formKey) throws Exception {
        String[] aryIds = null;
        if (!StringUtil.isEmpty((String)id)) {
            aryIds = id.split(",");
        }
        this.formBusManager.removeByIds(aryIds, formKey);
        return new CommonResult(true, "\u5220\u9664\u8868\u5355\u4e1a\u52a1\u8bbe\u7f6e\u6210\u529f", null);
    }
}

