/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.form.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.feign.SystemConfigFeignService;
import com.artfess.base.feign.WorkflowFeignService;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.form.model.FormPrintTemplate;
import com.artfess.form.persistence.manager.FormPrintTemplateManager;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/form/printTemplate/v1/"})
@Api(tags={"\u5957\u6253\u6a21\u677f"})
@ApiGroup(group={"group_form"})
public class FormPrintTemplateController
extends BaseController<FormPrintTemplateManager, FormPrintTemplate> {
    @Resource
    WorkflowFeignService workflowFeignService;
    @Resource
    FormPrintTemplateManager formPrintTemplateManager;
    @Resource
    SystemConfigFeignService systemConfigFeignService;

    @RequestMapping(value={"getPrintList"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6253\u5370\u6a21\u677f\u5217\u8868", httpMethod="POST", notes="\u6253\u5370\u6a21\u677f\u5217\u8868")
    @ResponseBody
    public PageList<FormPrintTemplate> getPrintList(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FormPrintTemplate> queryFilter) throws Exception {
        Page list = (Page)((FormPrintTemplateManager)this.baseService).getPrintList(queryFilter);
        return new PageList((IPage)list);
    }

    @PostMapping(value={"/save"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> save(@ApiParam(name="model", value="\u6253\u5370\u6a21\u677f") @RequestBody FormPrintTemplate formPrintTemplate) {
        ((FormPrintTemplateManager)this.baseService).saveFormPrintTemplate(formPrintTemplate);
        return new CommonResult("\u4e0a\u4f20\u6a21\u677f\u6210\u529f");
    }

    @RequestMapping(value={"removes"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664bo\u5b9a\u4e49")
    public CommonResult<String> batchRemove(String ... ids) throws Exception {
        this.formPrintTemplateManager.removeByIds(ids);
        return new CommonResult("\u5220\u9664\u6a21\u677f\u6210\u529f");
    }

    @RequestMapping(value={"setDefaultVersion"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u8bbe\u7f6e\u4e3a\u4e3b\u7248\u672c", httpMethod="GET", notes="\u8bbe\u7f6e\u4e3a\u4e3b\u7248\u672c")
    public CommonResult<String> setDefaultVersion(@ApiParam(name="id", value="\u4e3b\u952e", required=true) @RequestParam String id, @ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey, @ApiParam(name="printType", value="\u6253\u5370\u7c7b\u578b", required=true) @RequestParam String printType) throws Exception {
        ((FormPrintTemplateManager)this.baseService).setDefaultVersion(formKey, id, printType);
        return new CommonResult("\u8bbe\u7f6e\u4e3b\u7248\u672c\u6210\u529f");
    }

    @RequestMapping(value={"print"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6253\u5370\u6a21\u677f", httpMethod="GET", notes="\u6253\u5370\u6a21\u677f")
    public CommonResult<String> print(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9ID", required=true) @RequestParam Optional<String> nodeId, @ApiParam(name="procInstId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String procInstId) throws Exception {
        ObjectNode objectNode = this.workflowFeignService.printBoAndFormKey(defId, nodeId.orElse(""), procInstId);
        String formKey = objectNode.get("formKey").asText();
        String formName = objectNode.get("formName").asText();
        FormPrintTemplate formPrintTemplate = ((FormPrintTemplateManager)this.baseService).getMainFormPrintTemplate(formKey);
        if (BeanUtils.isEmpty((Object)((Object)formPrintTemplate))) {
            return new CommonResult(true, formName + "\u8868\u5355\u6ca1\u6709\u8bbe\u7f6e\u6253\u5370\u6a21\u677f", (Object)"");
        }
        String fileId = formPrintTemplate.getFileId();
        objectNode.put("scriptStr", formPrintTemplate.getScriptStr());
        objectNode.put("fileId", fileId);
        String id = this.systemConfigFeignService.wordPrint(objectNode);
        try {
            ObjectNode record = JsonUtil.getMapper().createObjectNode();
            record.put("procInstId", procInstId);
            record.put("nodeId", nodeId.orElse(""));
            record.put("procDefId", defId);
            record.put("formKey", formKey);
            record.put("templateId", formPrintTemplate.getId());
            record.put("templateName", formPrintTemplate.getFileName());
            record.put("fileId", id);
            this.workflowFeignService.addPrintLog(record);
        }
        catch (Exception e) {
            System.out.println("\u65b0\u589e\u6253\u5370\u8bb0\u5f55\u5931\u8d25\uff1a" + e.getMessage());
        }
        return new CommonResult(true, "", (Object)id);
    }

    @RequestMapping(value={"wordPrint"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6253\u5370word\u6a21\u677f", httpMethod="GET", notes="\u6253\u5370word\u6a21\u677f")
    public CommonResult<String> wordPrint(@ApiParam(name="id", value="id", required=true) @RequestParam String id, @ApiParam(name="defId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9ID", required=true) @RequestParam Optional<String> nodeId, @ApiParam(name="procInstId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String procInstId) throws Exception {
        ObjectNode objectNode = this.workflowFeignService.printBoAndFormKey(defId, nodeId.orElse(""), procInstId);
        FormPrintTemplate formPrintTemplate = (FormPrintTemplate)((FormPrintTemplateManager)this.baseService).get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)((Object)formPrintTemplate))) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u6b63\u786e\u7684\u6253\u5370\u6a21\u677f");
        }
        String fileId = formPrintTemplate.getFileId();
        objectNode.put("fileId", fileId);
        objectNode.put("defId", defId);
        objectNode.put("nodeId", nodeId.orElse(""));
        objectNode.put("scriptStr", StringUtil.isNotEmpty((String)formPrintTemplate.getScriptStr()) ? formPrintTemplate.getScriptStr() : "");
        String printId = this.systemConfigFeignService.wordPrint(objectNode);
        return new CommonResult(true, "", (Object)printId);
    }

    @RequestMapping(value={"getFormKey"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u83b7\u53d6\u8868\u5355Key", httpMethod="GET", notes="\u83b7\u53d6\u8868\u5355Key")
    public ObjectNode getFormKey(@ApiParam(name="defId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String defId, @ApiParam(name="nodeId", value="\u8282\u70b9ID", required=true) @RequestParam Optional<String> nodeId, @ApiParam(name="procInstId", value="\u6d41\u7a0b\u5b9e\u4f8bId", required=true) @RequestParam String procInstId) throws Exception {
        return this.workflowFeignService.printBoAndFormKey(defId, nodeId.orElse(""), procInstId);
    }

    @RequestMapping(value={"getMainTemlate"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u5217\u8868", httpMethod="GET", notes="\u901a\u8fc7\u8868\u5355key\u83b7\u53d6\u5217\u8868")
    public FormPrintTemplate getMainTemlate(@ApiParam(name="formKey", value="\u8868\u5355key", required=true) @RequestParam String formKey, @ApiParam(name="printType", value="\u6253\u5370\u7c7b\u578b", required=true) @RequestParam String printType) throws Exception {
        return ((FormPrintTemplateManager)this.baseService).getMailPrintTemplates(formKey, printType);
    }
}

