/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.sqlbuilder;

import com.artfess.base.query.QueryOP;
import com.artfess.base.sqlbuilder.AbstractSqlBuilder;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.text.ParseException;

public class OracleSqlBuilder
extends AbstractSqlBuilder {
    @Override
    public void handleDbTypeEqualDate(StringBuffer sql, String field, QueryOP op, Object value, String format) {
        if (op == QueryOP.BETWEEN) {
            ObjectNode value1 = (ObjectNode)value;
            String start = JsonUtil.getString((JsonNode)value1, "start", "");
            String end = JsonUtil.getString((JsonNode)value1, "end", "");
            if (StringUtil.isEmpty(format)) {
                format = "yyyy-mm-dd hh24:mi:ss";
            }
            String newStart = start;
            String newEnd = end;
            try {
                newStart = DateFormatUtil.format(DateFormatUtil.parseDate(start, format).getTime(), format);
                newEnd = DateFormatUtil.format(DateFormatUtil.parseDate(newEnd, format).getTime(), format);
            }
            catch (ParseException e) {
                newStart = start;
            }
            if (StringUtil.isNotEmpty(newStart)) {
                sql.append(" and " + field + " " + ">=" + " to_date('" + newStart + "','" + format + "')");
            }
            if (StringUtil.isNotEmpty(newEnd)) {
                sql.append(" and " + field + " " + "<=" + " to_date('" + newEnd + "','" + format + "')");
            }
        } else {
            if (StringUtil.isEmpty(format)) {
                format = "yyyy-mm-dd hh24:mi:ss";
            }
            Object newValue = value;
            try {
                newValue = DateFormatUtil.format(DateFormatUtil.parseDate(value.toString(), format).getTime(), format);
            }
            catch (ParseException e) {
                newValue = value;
            }
            sql.append(" and " + field + " " + op.op() + " to_date('" + newValue.toString() + "','" + format + "')");
        }
    }
}

