/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.groovy;

import com.artfess.base.exception.BaseException;
import com.artfess.base.groovy.GroovyBinding;
import com.artfess.base.util.BeanUtils;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class GroovyScriptEngine
implements BeanPostProcessor {
    private Log logger = LogFactory.getLog(this.getClass());
    private GroovyBinding binding = new GroovyBinding();
    private List<String> bindingInterface;

    public List<String> getBindingInterface() {
        return this.bindingInterface;
    }

    public void setBindingInterface(List<String> bindingInterface) {
        this.bindingInterface = bindingInterface;
    }

    public void execute(String script) {
        this.executeObject(script, null);
    }

    public void execute(String script, Map<String, Object> vars) {
        this.executeObject(script, vars);
    }

    public boolean executeBoolean(String script, Map<String, Object> vars) {
        return (Boolean)this.executeObject(script, vars);
    }

    public String executeString(String script, Map<String, Object> vars) {
        return BeanUtils.ObjectToString(this.executeObject(script, vars));
    }

    public int executeInt(String script, Map<String, Object> vars) {
        return (Integer)this.executeObject(script, vars);
    }

    public float executeFloat(String script, Map<String, Object> vars) {
        return ((Float)this.executeObject(script, vars)).floatValue();
    }

    public Object executeObject(String script, Map<String, Object> vars) {
        try {
            this.binding.clearVariables();
            this.logger.debug((Object)("\u6267\u884c:" + script));
            GroovyShell shell = new GroovyShell((Binding)this.binding);
            this.setParameters(shell, vars);
            script = script.replace("&apos;", "'").replace("&quot;", "\"").replace("&gt;", ">").replace("&lt;", "<").replace("&nuot;", "\n").replace("&amp;", "&");
            Object rtn = shell.evaluate(script);
            return rtn;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new BaseException("\u6267\u884c\u811a\u672c" + script + "\u62a5\u9519,\u8bf7\u68c0\u67e5\u811a\u672c");
        }
    }

    private void setParameters(GroovyShell shell, Map<String, Object> vars) {
        if (vars == null) {
            return;
        }
        Set<Map.Entry<String, Object>> set = vars.entrySet();
        for (Map.Entry<String, Object> entry : set) {
            shell.setVariable(entry.getKey(), entry.getValue());
        }
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        ArrayList list = new ArrayList();
        for (String string : this.bindingInterface) {
            try {
                Class<?> clazz = Class.forName(string);
                list.add(clazz);
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                this.logger.debug((Object)e.getException());
            }
        }
        for (Class clazz : list) {
            boolean isImpl = BeanUtils.isInherit(bean.getClass(), clazz);
            if (!isImpl || !isImpl) continue;
            this.binding.setProperty(beanName, bean);
        }
        return bean;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }
}

