/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.interceptor;

import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.ibatis.reflection.DefaultReflectorFactory;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.ReflectorFactory;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.reflection.factory.ObjectFactory;
import org.apache.ibatis.reflection.wrapper.ObjectWrapperFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Intercepts(value={@Signature(type=StatementHandler.class, method="prepare", args={Connection.class, Integer.class})})
public class DataPermissionInterceptor
implements Interceptor {
    private Logger logger = LoggerFactory.getLogger(DataPermissionInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        StatementHandler statementHandler = (StatementHandler)invocation.getTarget();
        MetaObject metaObject = MetaObject.forObject((Object)statementHandler, (ObjectFactory)SystemMetaObject.DEFAULT_OBJECT_FACTORY, (ObjectWrapperFactory)SystemMetaObject.DEFAULT_OBJECT_WRAPPER_FACTORY, (ReflectorFactory)new DefaultReflectorFactory());
        MappedStatement mappedStatement = (MappedStatement)metaObject.getValue("delegate.mappedStatement");
        BoundSql boundSql = statementHandler.getBoundSql();
        String sql = boundSql.getSql();
        metaObject.setValue("delegate.boundSql.sql", (Object)sql);
        Map<String, Object> mapThreadLocal = AuthenticationUtil.getMapThreadLocal();
        if (BeanUtils.isEmpty(mapThreadLocal)) {
            return invocation.proceed();
        }
        SqlCommandType commondType = mappedStatement.getSqlCommandType();
        if (commondType.compareTo((Enum)SqlCommandType.SELECT) == 0) {
            return invocation.proceed();
        }
        String createBySql = "";
        String createOrgIdSql = "";
        if (mapThreadLocal.containsKey("CREATE_BY_")) {
            createBySql = " CREATE_BY_ =  " + mapThreadLocal.get("CREATE_BY_");
        }
        if (mapThreadLocal.containsKey("CREATE_ORG_ID_")) {
            String inSql;
            Object object = mapThreadLocal.get("CREATE_ORG_ID_");
            Set orgIds = (Set)object;
            createOrgIdSql = inSql = this.getInSql("CREATE_ORG_ID_", orgIds);
        }
        if (StringUtil.isNotEmpty(createBySql)) {
            createOrgIdSql = createBySql + " or " + createOrgIdSql;
        }
        if (StringUtil.isNotEmpty(createOrgIdSql)) {
            sql = sql + " and ( " + createOrgIdSql + ") ";
        }
        this.logger.debug(" custom sql " + sql);
        metaObject.setValue("delegate.boundSql.sql", (Object)sql);
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
        this.logger.debug(" properties " + properties.toString());
    }

    private String getInSql(String field, Set<String> orgIds) {
        StringBuffer sb = new StringBuffer(" (");
        Iterator<String> iterator = orgIds.iterator();
        ArrayList<String> list = new ArrayList<String>();
        int i = 1;
        while (iterator.hasNext()) {
            String next = iterator.next();
            if (i > 500) {
                sb.append(field + " in (" + String.join((CharSequence)",", list) + ")");
                list = new ArrayList();
                i = 1;
            }
            list.add(next);
            ++i;
        }
        if (BeanUtils.isNotEmpty(list)) {
            sb.append(field + " in (" + String.join((CharSequence)",", list) + ")");
        }
        sb.append(")");
        return sb.toString();
    }
}

