/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.security;

import com.artfess.base.security.HtInvocationSecurityMetadataSourceService;
import com.artfess.base.util.AuthenticationUtil;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import java.util.Collection;
import org.springframework.security.access.AccessDecisionManager;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.access.ConfigAttribute;
import org.springframework.security.authentication.InsufficientAuthenticationException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;

public class HtDecisionManager
implements AccessDecisionManager {
    public void decide(Authentication authentication, Object object, Collection<ConfigAttribute> configAttributes) throws AccessDeniedException, InsufficientAuthenticationException {
        try {
            if (BeanUtils.isEmpty(configAttributes)) {
                return;
            }
            Collection authorities = authentication.getAuthorities();
            for (GrantedAuthority grantedAuthority : authorities) {
                if (!"ROLE_SUPER".equals(grantedAuthority.getAuthority())) continue;
                return;
            }
            for (ConfigAttribute configAttribute : configAttributes) {
                if (BeanUtils.isEmpty(configAttribute)) continue;
                String configVal = configAttribute.toString();
                if ("permitAll".equals(configVal)) {
                    return;
                }
                if (!"authenticated".equals(configVal)) continue;
                if (AuthenticationUtil.isAnonymous(authentication)) {
                    throw new InsufficientAuthenticationException("\u9700\u8981\u63d0\u4f9bjwt\u6388\u6743\u7801");
                }
                String attribute = configAttribute.getAttribute();
                if (!StringUtil.isEmpty(attribute)) continue;
                return;
            }
            for (GrantedAuthority grantedAuthority : authorities) {
                for (ConfigAttribute configAttribute : configAttributes) {
                    if (!grantedAuthority.getAuthority().equals(configAttribute.getAttribute())) continue;
                    return;
                }
            }
            throw new AccessDeniedException("\u60a8\u6ca1\u6709\u6743\u9650\uff0c \u8bf7\u8054\u7cfb\u7cfb\u7edf\u7ba1\u7406\u5458");
        }
        finally {
            HtInvocationSecurityMetadataSourceService.clearMapThreadLocal();
        }
    }

    public boolean supports(ConfigAttribute attribute) {
        return true;
    }

    public boolean supports(Class<?> clazz) {
        return true;
    }
}

