package com.artfess.mdm.uc.manager.impl;

import com.alibaba.druid.util.StringUtils;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.mdm.uc.manager.MdmOrgDemensionManager;
import com.artfess.mdm.uc.model.MdmOrgBasic;
import com.artfess.mdm.uc.dao.MdmOrgBasicDao;
import com.artfess.mdm.uc.manager.MdmOrgBasicManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.mdm.uc.model.MdmOrgDemension;
import com.artfess.uc.api.impl.model.Org;
import com.baomidou.dynamic.datasource.annotation.DS;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.sun.xml.bind.v2.TODO;
import org.apache.ibatis.annotations.Param;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * 组织机构表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2025-02-08
 */
@Service
@DS("mdm")
@Transactional(rollbackFor = Exception.class)
public class MdmOrgBasicManagerImpl extends BaseManagerImpl<MdmOrgBasicDao, MdmOrgBasic> implements MdmOrgBasicManager {

    static List<MdmOrgBasic> childOrg = new ArrayList<MdmOrgBasic>();

    @Autowired
    MdmOrgDemensionManager demensionService;

    @Override
    public boolean insertObj(MdmOrgBasic org) {
        if (StringUtil.isEmpty(org.getName())) {
            throw new RuntimeException("添加组织失败，组织名称【name】不能为空！");
        }
        if (StringUtil.isEmpty(org.getCode())) {
            throw new RuntimeException("添加组织失败，组织编码【code】不能为空！");
        }
        if (org.getCode().contains(",")) {
            throw new RuntimeException("组织编码中不能包含英文逗号‘,’");
        }
        if (StringUtil.isEmpty(org.getDemId())) {
            throw new RuntimeException("添加组织失败，维度id【demId】不能为空！");
        }
        if (this.getCountByCode(org.getId(),org.getCode(),org.getOrgVersion()) > 0) {
            throw new RuntimeException("添加组织失败，组织编码[" + org.getCode() + "]已存在！");
        }

        MdmOrgDemension dem = demensionService.getObjById(org.getDemId());
        if (BeanUtils.isEmpty(dem)) {
            throw new RuntimeException("添加组织失败，根据输入的demId[" + org.getDemId() + "]没有找到对应的维度信息！");
        }
        MdmOrgBasic pOrg = null;
        if (!"0".equals(org.getParentId()) && StringUtil.isNotEmpty(org.getParentId())) {
            pOrg = this.getObjById(org.getParentId());
            if (BeanUtils.isEmpty(pOrg)) {
                throw new RuntimeException("添加组织失败，根据输入的parentId[" + org.getParentId() + "]没有找到对应的组织信息！");
            }
            if (BeanUtils.isEmpty(pOrg) && !pOrg.getDemId().equals(org.getDemId())) {
                throw new RuntimeException("添加组织失败，根据输入demId与所输入的父组织所对应的维度id不一致！");
            }
            if (BeanUtils.isEmpty(pOrg) && pOrg.getOrgVersion()!=org.getOrgVersion()) {
                throw new RuntimeException("添加组织失败，根据输入的组织版本号与所输入的父组织所对应的版本号不一致！");
            }
            String orgKind = org.getOrgKind();
            if (StringUtil.isEmpty(orgKind)) {
                throw new RuntimeException("添加组织失败，请选择组织类型！");
            }
            if (!orgKind.equals("dept") && pOrg.getOrgKind().equals("dept")) {
                throw new RuntimeException("添加组织失败，该组织的父级类型是【部门】，该组织类型不能为【机构】！");
            }

        }
        org.setId(UniqueIdUtil.getSuid());
        if (StringUtils.isEmpty(org.getParentId())) {
            org.setParentId("0");
        }
        if (BeanUtils.isEmpty(pOrg)) {
            org.setLevel(1);
            org.setPathId("/" + org.getDemId() + "/" + org.getId());
            org.setPathName("/" + org.getName());
            org.setPathCode("/" + org.getCode());
            if(org.getOrgVersion()==null){
                Integer orgVersion = this.getMaxOrgVersion();
                if(orgVersion == 0 ){
                    orgVersion = Integer.parseInt(LocalDate.now().getYear() + "01");
                }else{
                    String orgVersionStr = String.valueOf(orgVersion);
                    if(orgVersionStr.length()>4){
                        int year =Integer.parseInt(orgVersionStr.substring(0, 3));
                        if(year !=LocalDate.now().getYear() ){
                            orgVersion = Integer.parseInt(LocalDate.now().getYear() + "01");
                        }else{
                            orgVersion = orgVersion+1;
                        }
                    }
                }
                org.setOrgVersion(orgVersion);
            }
            if(org.getOrgStartDate()==null){
                org.setOrgStartDate(LocalDate.now());
            }
            org.setOrgEndDate(LocalDate.of(9999, 12, 31));
        } else {
            org.setLevel(pOrg.getLevel()+1);
            org.setPathId(pOrg.getPathId()+"/"+org.getId());
            org.setPathName(pOrg.getPathName() +"/" + org.getName());
            org.setPathCode(pOrg.getPathCode() +"/" + org.getCode());
            org.setOrgVersion(pOrg.getOrgVersion());
            org.setOrgStartDate(pOrg.getOrgStartDate());
            org.setOrgEndDate(pOrg.getOrgEndDate());
        }
        if(org.getLimitNum()==null){
            org.setLimitNum(0);
        }
        if(org.getExceedLimitNum()==null){
            org.setExceedLimitNum(0);
        }
        org.setLastOperateTime(LocalDateTime.now());
        org.setLastTimeSeq(new Date().getTime());
        org.setIsDele("0");
        org.setSn(this.getNextSequenceByParentId(org.getParentId()));
        return this.save(org);
    }

    @Override
    public boolean updateObj(MdmOrgBasic org) {
        if (StringUtil.isEmpty(org.getCode())) {
            throw new RuntimeException("更新组织失败，组织编码【code】必填！");
        }

        MdmOrgDemension dem = demensionService.get(org.getDemId());
        if (StringUtil.isNotEmpty(org.getDemId()) && BeanUtils.isEmpty(dem)) {
            throw new RuntimeException("更新组织失败，根据输入的demId【" + org.getDemId() + "】没有找到对应的维度信息！");
        }
        MdmOrgBasic pOrg = null;
        if (StringUtil.isNotEmpty(org.getParentId()) && !"0".equals(org.getParentId())) {
            pOrg = this.getObjById(org.getParentId());
            if (BeanUtils.isEmpty(pOrg)) {
                throw new RuntimeException("更新组织失败，根据输入的parentId【" + org.getDemId() + "】没有找到对应的组织信息！");
            }
            if (StringUtil.isNotEmpty(org.getDemId()) && BeanUtils.isNotEmpty(pOrg)&& !pOrg.getDemId().equals(org.getDemId())) {
                throw new RuntimeException("更新组织失败，根据输入demId与所输入的父组织所对应的维度id不一致！");
            }
            if (BeanUtils.isEmpty(pOrg) && pOrg.getOrgVersion()!=org.getOrgVersion()) {
                throw new RuntimeException("更新组织失败，根据输入的组织版本号与所输入的父组织所对应的版本号不一致！");
            }
        }
        MdmOrgBasic oldOrg = this.getObjById(org.getId());
        if (BeanUtils.isEmpty(oldOrg)) {
            throw new RuntimeException("更新组织失败，组织ID错误！");
        }
        String orgKind = org.getOrgKind();
        if (orgKind.equals("ogn")) {
            QueryWrapper<MdmOrgBasic> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("ORG_KIND_", "dept").eq("ID_", org.getParentId());
            int num = baseMapper.selectCount(queryWrapper);
            if (num > 0) {
                throw new RuntimeException("更新组织失败，该组织的父级是部门，该组织不能修改为机构！");
            }
        }
        if (orgKind.equals("dept")) {
            QueryWrapper<MdmOrgBasic> queryWrapper = new QueryWrapper<>();
            queryWrapper.eq("ORG_KIND_", "ogn").eq("PARENT_ID_", org.getId());
            int num = baseMapper.selectCount(queryWrapper);
            if (num > 0) {
                throw new RuntimeException("更新组织失败，该组织下已有子组织了，不能修改为部门！");
            }
        }
        
        if (BeanUtils.isEmpty(pOrg)) {
            org.setLevel(1);
            org.setPathId("/" + org.getDemId() + "/" + org.getId());
            org.setPathName("/" + org.getName());
            org.setPathCode("/" + org.getCode());

        } else {
            org.setLevel(pOrg.getLevel()+1);
            org.setPathId(pOrg.getPathId()+"/"+org.getId());
            org.setPathName(pOrg.getPathName() +"/" + org.getName());
            org.setPathCode(pOrg.getPathCode() +"/" + org.getCode());
        }
        org.setOrgVersion(oldOrg.getOrgVersion());
        org.setOrgStartDate(oldOrg.getOrgStartDate());
        org.setOrgEndDate(oldOrg.getOrgEndDate());
        if(org.getSn()==null) {
            org.setSn(oldOrg.getSn());
        }
        if(org.getLimitNum()==null){
            org.setLimitNum(oldOrg.getLimitNum());
        }
        if(org.getExceedLimitNum()==null){
            org.setExceedLimitNum(oldOrg.getExceedLimitNum());
        }
        if(StringUtil.isEmpty(org.getOrgType())){
            org.setOrgType(oldOrg.getOrgType());
        }
        org.setIsDele("0");
        String extName = org.getPathName().substring(0, org.getPathName().indexOf("/" + org.getName()));
        String extCode = org.getPathCode().substring(0, org.getPathCode().indexOf("/" + org.getCode()));
        String extId = org.getPathId().substring(0, org.getPathId().indexOf("/" + org.getId()));
        org.setLastOperateTime(LocalDateTime.now());
        org.setLastTimeSeq(new Date().getTime());
        this.updateById(org);

        String[] ids = {org.getId()};

        // 查找子节点
        List<MdmOrgBasic> allList = this.getAllByVersion(org.getOrgVersion());
        List<MdmOrgBasic> cList = new ArrayList<MdmOrgBasic>();
        for (String id : ids) {
            getChild(allList, id, cList);
        }
        // 更新子节点
        String[] childIds = new String[cList.size()];
        // 子节点是递归往上找的数据，最孙的节点排在list前面，遍历时，先从一级子节点进行修改
        for (int i = cList.size() - 1; i >= 0; i--) {
            String id = cList.get(i).getId();
            childIds[i] = id;
            MdmOrgBasic c = this.get(id);
            if (c.getParentId().equals(org.getId())) {// 一级子组织
                c.setPathName(org.getPathName() + "/" + c.getName());
                c.setPathCode(org.getPathCode() + "/"+ c.getCode() );
                c.setPathId(org.getPathId() + "/"+  c.getId());
            } else {// 二级及以下组织
                String pName = org.getName();
                String pCode = org.getCode();
                String pId = org.getId();
                MdmOrgBasic po = this.getObjById(c.getParentId());
                String pathName = po.getPathName().substring(po.getPathName().indexOf("/" + pName)) + "/" + c.getName();
                String pathCode = po.getPathCode().substring(po.getPathCode().indexOf("/" + pCode)) + "/" + c.getCode();
                String pathId = po.getPathId().substring(po.getPathId().indexOf("/" + pId)) + "/" + c.getId();
                c.setPathName(extName + pathName);
                c.setPathCode(extCode + pathCode);
                c.setPathId(extId + pathId);
            }
            c.setDemId(org.getDemId());
            c.setLastOperateTime(LocalDateTime.now());
            c.setLastTimeSeq(new Date().getTime());
            this.updateById(c);
        }
        return true;
    }

    @Override
    public boolean remove(String id) {
        MdmOrgBasic  org = this.getById(id);
        if(org == null){
            throw new RuntimeException("删除失败，根据输入的Id【" + id + "】错误！");
        }
        org.setLastOperateTime(LocalDateTime.now());
        org.setLastTimeSeq(new Date().getTime());
        this.updateById(org);
        this.removeById(id);
        //TODO 删除节点的用户，参数等信息

        List<MdmOrgBasic> allList = this.getAllByVersion(org.getOrgVersion());
        childOrg.removeAll(childOrg);
        treeOrgList(allList, id);
        List <String> childIds = new ArrayList<>();
        for (int i = 0; i < childOrg.size(); i++) {
            MdmOrgBasic child = childOrg.get(i);
            child.setLastOperateTime(LocalDateTime.now());
            child.setLastTimeSeq(new Date().getTime());
            childIds.add(child.getId());
        }
        this.updateBatchById(childOrg);
        //TODO 删除子节点的用户，参数等信息


        return  this.removeBatchById(childIds);
    }

    @Override
    public boolean removeBatchById(List<String> ids) {
        for (String id : ids) {
            remove(id);
        }
        return true;
    }

    @Override
    public MdmOrgBasic getObjById(String id) {
        Assert.hasText(id, "ID不能为空");
        return this.getById(id);
    }

    @Override
    public List<MdmOrgBasic> getAllByVersion(Integer orgVersion) {
        QueryWrapper<MdmOrgBasic> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq(orgVersion!=null,"ORG_VERSION_", orgVersion);
        List<MdmOrgBasic> list = this.baseMapper.selectList(queryWrapper);
        return list;
    }

    /**
     * 获取某个父节点下面的所有子节点
     *
     * @param orgList
     * @param parentId
     * @return
     */
    public static List<MdmOrgBasic> treeOrgList(List<MdmOrgBasic> orgList, String parentId) {
        for (MdmOrgBasic org : orgList) {
            // 遍历出父id等于参数的id，add进子节点集合
            if (parentId.equals(org.getParentId())) {
                // 递归遍历下一级
                treeOrgList(orgList, org.getId());
                childOrg.add(org);
            }
        }
        return childOrg;
    }

    public static List<MdmOrgBasic> getChild(List<MdmOrgBasic> orgList, String parentId, List<MdmOrgBasic> rtnList) {
        for (MdmOrgBasic org : orgList) {
            // 遍历出父id等于参数的id，add进子节点集合
            if (parentId.equals(org.getParentId())) {
                // 递归遍历下一级
                getChild(orgList, org.getId(), rtnList);
                rtnList.add(org);
            }
        }
        return rtnList;
    }

    private Integer getCountByCode(String id,String code,Integer orgVersion){
        QueryWrapper<MdmOrgBasic> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("CODE_", code);
        queryWrapper.eq(StringUtil.isNotEmpty(id), "ID_",id);
        queryWrapper.eq(BeanUtils.isNotEmpty(orgVersion), "ORG_VERSION_",orgVersion);
        Integer count = this.baseMapper.selectCount(queryWrapper);
        return count;
    }

    private Integer getMaxOrgVersion(){
        QueryWrapper<MdmOrgBasic> queryWrapper = new QueryWrapper<>();
        queryWrapper.select("COALESCE(max(ORG_VERSION_),0) \"orgVersion\"");
        queryWrapper.eq("ORG_END_DATE_", "9999-12-31");
        List<Map<String,Object>> resultList =this.baseMapper.selectMaps(queryWrapper);
        if(resultList!=null && resultList.size()>0){
            Map<String,Object> resultMap = resultList.get(0);
            Integer result =Integer.parseInt(resultMap.get("orgVersion").toString());
            return Integer.valueOf(result == null ? 0 : (result = Integer.valueOf(result.intValue())).intValue());
        }else{
            return 0;
        }
    }
}
