/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataCollect.dao.BizClusterTableFieldDao;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableFieldManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableManager;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataCollect.vo.BizClusterFieldVo;
import com.artfess.dataShare.dataCollect.vo.TableDetailVo;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.poi.util.ExcelTool;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizClusterTableFieldManagerImpl
extends BaseManagerImpl<BizClusterTableFieldDao, BizClusterTableField>
implements BizClusterTableFieldManager {
    @Resource
    BizClusterTableManager tableManager;
    @Resource
    BizClusterInfoModeManager infoModeManager;
    @Resource
    private BizClusterTableFieldManager fieldManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void export(MultipartFile file, String tableId) throws Exception {
        BizClusterTable table = (BizClusterTable)this.tableManager.get((Serializable)((Object)tableId));
        if (null == table) {
            throw new ApplicationException("\u672a\u67e5\u8be2\u5230\u5b9e\u4f53\u8868");
        }
        String tableName = table.getTableNameCh();
        ExcelTool util = new ExcelTool(BizClusterFieldVo.class);
        List list = util.importExcel(file.getInputStream(), Integer.valueOf(2), Integer.valueOf(2));
        list = list.stream().filter(vo -> StringUtil.isNotEmpty((String)vo.getFieldName())).collect(Collectors.toList());
        List<BizClusterTableField> oldFields = this.fieldManager.queryFieldByTableId(tableId);
        Set<Object> manageFields = new HashSet();
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0) {
            manageFields = oldFields.stream().filter(entity -> "1".equals(entity.getFieldType())).map(entity -> entity.getFieldName()).collect(Collectors.toSet());
        }
        for (int i = 1; i < list.size(); ++i) {
            BizClusterFieldVo vo2 = (BizClusterFieldVo)list.get(i);
            if (StringUtil.isEmpty((String)vo2.getFieldName()) || manageFields.contains(vo2.getFieldName()) || !this.checkExistsField(tableId, vo2.getFieldName())) continue;
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u5b57\u6bb5(" + vo2.getFieldName() + ")\u3011\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
        }
        List disFieldList = list.stream().map(p -> p.getFieldName()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < list.size()) {
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
        }
        for (int i = 1; i < list.size(); ++i) {
            BizClusterFieldVo vo3 = (BizClusterFieldVo)list.get(i);
            if (StringUtil.isEmpty((String)vo3.getFieldName()) || manageFields.contains(vo3.getFieldName())) continue;
            BizClusterTableField field = BizClusterFieldVo.parse(vo3);
            field.setTableId(tableId);
            field.setCode(field.getFieldName());
            field.setMouldCode(table.getCode());
            field.setMouldName(table.getTableNameCh());
            field.setIsDele("0");
            this.create((Model)field);
        }
    }

    public boolean checkExistsField(String tableId, String fieldName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID_", (Object)tableId);
        queryWrapper.eq((Object)"FIELD_NAME_", (Object)fieldName);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    public boolean checkExistsField(String tableId, String fieldName, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID_", (Object)tableId);
        queryWrapper.eq((Object)"FIELD_NAME_", (Object)fieldName);
        queryWrapper.ne((Object)"ID_", (Object)id);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    public List<BizClusterTableField> queryFieldByTableId(String tableId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"table_id_", (Object)tableId);
        queryWrapper.orderByAsc((Object)"sn_");
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTableField(TableDetailVo vo) {
        BizClusterTable table = vo.getTable();
        List<BizClusterTableField> listField = vo.getFieldList();
        List disFieldList = listField.stream().map(p -> p.getFieldName()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < listField.size()) {
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        if (StringUtil.isEmpty((String)table.getId())) {
            this.tableManager.create((Model)table);
        } else {
            this.tableManager.update((Model)table);
        }
        for (BizClusterTableField item : listField) {
            if (StringUtil.isEmpty((String)item.getId()) ? this.checkExistsField(table.getTableNameEn(), item.getFieldName()) : this.checkExistsField(table.getTableNameEn(), item.getFieldName(), item.getId())) {
                throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u5b57\u6bb5(" + item.getFieldName() + ")\u3011\u8bf7\u4fee\u6539\u540e\u5728\u5bfc\u5165");
            }
            item.setTableId(table.getId());
        }
        this.saveOrUpdateBatch(listField);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveOrUpdateFields(List<BizClusterTableField> fields) throws Exception {
        if (fields.size() == 0) {
            throw new ApplicationException("\u6ca1\u6709\u4fee\u6539\u7684\u5b57\u6bb5");
        }
        String tableId = fields.get(0).getTableId();
        BizClusterTable table = (BizClusterTable)this.tableManager.get((Serializable)((Object)tableId));
        List disFieldList = fields.stream().map(p -> p.getCode()).distinct().collect(Collectors.toList());
        if (disFieldList.size() < fields.size()) {
            throw new BaseException("\u8868\u3010" + table.getTableNameCh() + "\u4e2d\u5b58\u5728\u91cd\u590d\u5b57\u6bb5\u540d\u8bf7\u4fee\u6539\u540e\u5728\u4fdd\u5b58");
        }
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        String tableName = table.getTableNameEn();
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        for (BizClusterTableField field : fields) {
            field.setIsCreate("1");
            Integer attrLength = field.getAttrLength() == null ? 0 : field.getAttrLength();
            Integer decimalLen = field.getDecimalLen() == null ? 4 : field.getDecimalLen();
            field.setDecimalLen(decimalLen);
            field.setFieldName(field.getCode());
            if (StringUtil.isEmpty((String)field.getId())) {
                if (field.getSn() == null) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("TABLE_ID_", tableId);
                    field.setSn(this.getNextSequence(map));
                }
                field.setMouldCode(fields.get(0).getMouldCode());
                field.setMouldName(fields.get(0).getMouldName());
                String fieldSq = "ALTER TABLE `" + tableName + "` ADD COLUMN `" + field.getFieldName() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " NULL COMMENT '" + field.getDesc() + "' ";
                template.execute(fieldSq);
                continue;
            }
            if (!this.fieldEquals(field)) continue;
            BizClusterTableField oldField = (BizClusterTableField)((Object)this.getById((Serializable)((Object)field.getId())));
            if (field.getFieldName().equals(oldField.getFieldName())) continue;
            String fieldSq = "ALTER TABLE `" + tableName + "` CHANGE `" + oldField.getFieldName() + "`  `" + field.getFieldName() + "` " + FieldUtil.getColumnType(field.getDataType(), attrLength, attrLength, decimalLen) + " DEFAULT NULL COMMENT '" + field.getDesc() + "' ";
            template.execute(fieldSq);
        }
        this.saveOrUpdateBatch(fields);
        String createTableSql = this.tableManager.queryTableSql(tableId);
        table.setCreateTableSql(createTableSql);
        this.tableManager.updateById((Object)table);
    }

    public boolean fieldEquals(BizClusterTableField field) {
        BizClusterTableField oldField = (BizClusterTableField)((Object)this.getById((Serializable)((Object)field.getId())));
        return !field.getFieldName().equals(oldField.getFieldName()) || !field.getDesc().equals(oldField.getDesc());
    }
}

