/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.scheduler.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobLogManager;
import com.artfess.dataShare.scheduler.manager.BizSchedulerJobManager;
import com.artfess.dataShare.scheduler.model.BizSchedulerJob;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/biz/scheduler/schedulerJob/v1/"})
@Api(tags={"\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a--\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizSchedulerJobController
extends BaseController<BizSchedulerJobManager, BizSchedulerJob> {
    @Autowired
    BizSchedulerJobLogManager jobLogManager;

    @PostMapping(value={"/sliceQuery"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f")
    public PageList<BizSchedulerJob> sliceQuery(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<BizSchedulerJob> queryFilter) {
        return ((BizSchedulerJobManager)this.baseService).sliceQuery(queryFilter);
    }

    @PostMapping(value={"/insertSchedulerJob"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f")
    public CommonResult<String> insertSchedulerJob(@RequestParam(name="jobJson") String jobJson, @RequestParam(name="files", required=false) MultipartFile[] files) throws Exception {
        if (StringUtil.isEmpty((String)jobJson)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u65b0\u589e\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!");
        }
        BizSchedulerJob schedulerJob = (BizSchedulerJob)((Object)JsonUtil.toBean((String)jobJson, BizSchedulerJob.class));
        boolean result = ((BizSchedulerJobManager)this.baseService).insertSchedulerJob(schedulerJob, files);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u65b0\u589e\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/updateSchedulerJob"})
    @ApiOperation(value="\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f")
    public CommonResult<String> updateSchedulerJob(@RequestParam(name="jobJson") String jobJson, @RequestParam(name="files", required=false) MultipartFile[] files) throws Exception {
        if (StringUtil.isEmpty((String)jobJson)) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!");
        }
        BizSchedulerJob schedulerJob = (BizSchedulerJob)((Object)JsonUtil.toBean((String)jobJson, BizSchedulerJob.class));
        boolean result = ((BizSchedulerJobManager)this.baseService).updateSchedulerJob(schedulerJob, files);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u4fee\u6539\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f\u5931\u8d25!");
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        try {
            boolean result = false;
            result = ((BizSchedulerJobManager)this.baseService).deleteSchedulerJobById(id);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
            }
            return new CommonResult("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/getSchedulerJobById"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u5b9a\u65f6\u4efb\u52a1\u4f5c\u4e1a\u914d\u7f6e\u4fe1\u606f")
    public BizSchedulerJob getSchedulerJobById(@ApiParam(name="id", value="\u5b9e\u4f53id") @RequestParam String id) {
        BizSchedulerJob schedulerJob = ((BizSchedulerJobManager)this.baseService).getSchedulerJobById(id);
        return schedulerJob;
    }

    @PostMapping(value={"/startUpJob"})
    @ApiOperation(value="\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1", httpMethod="POST", notes="\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1")
    public CommonResult<String> startUpJob(@ApiParam(name="id", value="\u4efb\u52a1\u4f5c\u4e1aid") @RequestParam String id) throws Exception {
        boolean result = ((BizSchedulerJobManager)this.baseService).startUpJob(id);
        if (result) {
            return new CommonResult("\u542f\u52a8\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u542f\u52a8\u4efb\u52a1\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/stopJob"})
    @ApiOperation(value="\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1", httpMethod="POST", notes="\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1")
    public CommonResult<String> stopJob(@ApiParam(name="id", value="\u4efb\u52a1\u4f5c\u4e1aid") @RequestParam String id) throws Exception {
        boolean result = ((BizSchedulerJobManager)this.baseService).stopJob(id);
        if (result) {
            return new CommonResult("\u505c\u6b62\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u505c\u6b62\u4efb\u52a1\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/delJob"})
    @ApiOperation(value="\u5220\u9664\u5b9a\u65f6\u4efb\u52a1", httpMethod="POST", notes="\u5220\u9664\u5b9a\u65f6\u4efb\u52a1")
    public CommonResult<String> delJob(@ApiParam(name="id", value="\u4efb\u52a1\u4f5c\u4e1aid", required=true) @RequestParam String id) throws Exception {
        boolean result = ((BizSchedulerJobManager)this.baseService).delJob(id);
        if (result) {
            return new CommonResult("\u5220\u9664\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u4efb\u52a1\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/executeJob"})
    @ApiOperation(value="\u6267\u884c\u4e00\u6b21\u4f5c\u4e1a\u4efb\u52a1", httpMethod="POST", notes="\u6267\u884c\u4e00\u6b21\u4f5c\u4e1a\u4efb\u52a1")
    public CommonResult<String> executeJob(@ApiParam(name="id", value="\u4efb\u52a1\u4f5c\u4e1aid", required=true) @RequestParam String id) throws Exception {
        boolean result = ((BizSchedulerJobManager)this.baseService).executeJob(id);
        if (result) {
            return new CommonResult("\u6267\u884c\u4f5c\u4e1a\u4efb\u52a1\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u6267\u884c\u4f5c\u4e1a\u4efb\u52a1\u5931\u8d25\uff01");
    }

    @RequestMapping(value={"/validClass"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u7c7b", httpMethod="GET", notes="\u9a8c\u8bc1\u7c7b")
    public CommonResult validClass(@ApiParam(name="className", value="\u7c7b\u540d", required=true) @RequestParam String className) {
        boolean rtn = ((BizSchedulerJobManager)this.baseService).validClass(className);
        if (rtn) {
            return new CommonResult(true, "\u9a8c\u8bc1\u7c7b\u6210\u529f!", null);
        }
        return new CommonResult(false, "\u9a8c\u8bc1\u7c7b\u5931\u8d25!", null);
    }
}

