/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.util;

import java.security.SecureRandom;
import java.util.Base64;

public class AKSKGenerator {
    private static final int ACCESS_KEY_BYTE_SIZE = 16;
    private static final int SECRET_KEY_BYTE_SIZE = 32;

    public static String generateAccessKey() {
        SecureRandom random = new SecureRandom();
        byte[] accessKeyBytes = new byte[16];
        random.nextBytes(accessKeyBytes);
        return Base64.getEncoder().encodeToString(accessKeyBytes).trim();
    }

    public static String generateSecretKey() {
        SecureRandom random = new SecureRandom();
        byte[] secretKeyBytes = new byte[32];
        random.nextBytes(secretKeyBytes);
        return Base64.getEncoder().encodeToString(secretKeyBytes).trim();
    }

    public static boolean validateAKSK(String accessKey, String secretKey) {
        return accessKey != null && secretKey != null && accessKey.length() > 0 && secretKey.length() > 0;
    }

    public static void main(String[] args) {
        String accessKey = AKSKGenerator.generateAccessKey();
        String secretKey = AKSKGenerator.generateSecretKey();
        System.out.println("Access Key: " + accessKey);
        System.out.println("Secret Key: " + secretKey);
        boolean isValid = AKSKGenerator.validateAKSK(accessKey, secretKey);
        System.out.println("AKSK is valid: " + isValid);
    }
}

