/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataCollect.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.dataShare.dataCollect.dao.BizClusterTableDao;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterInfoModeManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableFieldManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTableTriggerManager;
import com.artfess.dataShare.dataCollect.manager.BizClusterTempDataLogManager;
import com.artfess.dataShare.dataCollect.model.BizClusterInfo;
import com.artfess.dataShare.dataCollect.model.BizClusterInfoMode;
import com.artfess.dataShare.dataCollect.model.BizClusterTable;
import com.artfess.dataShare.dataCollect.model.BizClusterTableField;
import com.artfess.dataShare.dataCollect.model.BizClusterTableTrigger;
import com.artfess.dataShare.dataCollect.model.BizClusterTempDataLog;
import com.artfess.dataShare.dataCollect.vo.BizClusterTableVo;
import com.artfess.dataShare.dataCollect.vo.TableDetailVo;
import com.artfess.dataShare.dataResource.ods.vo.CopyTableVo;
import com.artfess.dataShare.factory.QueryDataTableFactory;
import com.artfess.dataShare.factory.QueryParam;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.FieldUtil;
import com.artfess.dataShare.util.MySQLUtils;
import com.artfess.poi.util.ExcelTool;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class BizClusterTableManagerImpl
extends BaseManagerImpl<BizClusterTableDao, BizClusterTable>
implements BizClusterTableManager {
    @Resource
    BizClusterInfoModeManager infoModeManager;
    @Resource
    BizClusterInfoManager infoManager;
    @Resource
    BizClusterTableFieldManager fieldManager;
    @Resource
    BizClusterTempDataLogManager tempDataLogManager;
    @Resource
    BizClusterTableTriggerManager triggerManager;

    public boolean checkTable(String tableName) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)tableName);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    public boolean checkTableCode(String code) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CODE_", (Object)code);
        int count = this.count((Wrapper)queryWrapper);
        return count > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void export(MultipartFile file, String clusterInfoId) throws Exception {
        ExcelTool util = new ExcelTool(BizClusterTableVo.class);
        List list = util.importExcel(file.getInputStream(), Integer.valueOf(3), Integer.valueOf(4));
        if ((list = list.stream().filter(p -> org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)p.getTableName())).collect(Collectors.toList())).size() == 0) {
            throw new BaseException("\u8868\u6ca1\u6709\u68c0\u6d4b\u5230\u9700\u8981\u5bfc\u5165\u7684\u6570\u636e\uff0c\u6ce8\u610f\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        for (BizClusterTableVo vo : list) {
            if (StringUtil.isEmpty((String)vo.getTableCn())) continue;
            if (StringUtil.isEmpty((String)vo.getTableCn())) {
                throw new BaseException("\u8868" + vo.getName() + "\u4e2d\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (StringUtil.isEmpty((String)vo.getTableName())) {
                throw new BaseException("\u8868" + vo.getName() + "\u82f1\u6587\u540d\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (this.checkTable(vo.getTableName())) {
                throw new BaseException("\u8868\u3010" + vo.getName() + "(" + vo.getTableName() + ")\u3011\u5df2\u7ecf\u5b58\u5728");
            }
            if (!this.checkTableCode(vo.getCode())) continue;
            throw new BaseException("\u8868\u3010" + vo.getName() + "(" + vo.getCode() + ")\u3011\u5df2\u7ecf\u5b58\u5728");
        }
        for (BizClusterTableVo vo : list) {
            if (StringUtil.isEmpty((String)vo.getCode())) continue;
            BizClusterTable table = BizClusterTableVo.parseTable(vo);
            BizClusterInfo info = (BizClusterInfo)((Object)this.infoManager.getById((Serializable)((Object)clusterInfoId)));
            BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)clusterInfoId)));
            table.setDbSourceId(infoMode.getDatabaseAlias());
            table.setTableNameCh(vo.getTableCn());
            table.setTableNameEn(info.getSysTableCode() + "_" + table.getTableNameEn());
            table.setClusterId(clusterInfoId);
            table.setIsCreateTable(0);
            table.setDeployed(0);
            table.setIsDele("0");
            table.setTablePrefixCode(info.getSysTableCode());
            this.create((Model)table);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void Deploy(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizClusterTable table = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        if ("1".equals(table.getDeployed())) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u91cd\u590d\u53d1\u5e03");
        }
        List<BizClusterTableField> fieldList = this.fieldManager.queryFieldByTableId(tableId);
        if (fieldList.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        BizClusterInfoMode info = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(this.queryTableSql(tableId));
        template.execute(table.getCreateTableSql());
        this.update((Model)table);
        Map<String, String> triggerMap = MySQLUtils.createTiger(template, table.getTableNameEn(), info.getCompanyName(), info.getSysName(), info.getSysCode(), table.getName(), table.getCode());
        BizClusterTableTrigger triggerInsert = new BizClusterTableTrigger();
        triggerInsert.setIsCreateTable(1);
        triggerInsert.setMouldCode(table.getCode());
        triggerInsert.setMouldName(table.getTableNameCh());
        triggerInsert.setTableId(tableId);
        triggerInsert.setTriggerSql(triggerMap.get("insert"));
        triggerInsert.setTriggerType("1");
        triggerInsert.setName(table.getTableNameCh() + "\u6dfb\u52a0\u6570\u636e\u89e6\u53d1\u5668");
        triggerInsert.setCode(table.getTableNameEn() + "_insert_tiger");
        this.triggerManager.create((Model)triggerInsert);
        BizClusterTableTrigger triggerUpdate = new BizClusterTableTrigger();
        triggerUpdate.setIsCreateTable(1);
        triggerUpdate.setMouldCode(table.getCode());
        triggerUpdate.setMouldName(table.getTableNameCh());
        triggerUpdate.setTableId(tableId);
        triggerUpdate.setTriggerSql(triggerMap.get("update"));
        triggerUpdate.setTriggerType("2");
        triggerUpdate.setName(table.getTableNameCh() + "\u4fee\u6539\u6570\u636e\u89e6\u53d1\u5668");
        triggerUpdate.setCode(table.getTableNameEn() + "_update_tiger");
        this.triggerManager.create((Model)triggerUpdate);
        BizClusterTableTrigger triggerDelete = new BizClusterTableTrigger();
        triggerDelete.setIsCreateTable(1);
        triggerDelete.setMouldCode(table.getCode());
        triggerDelete.setMouldName(table.getTableNameCh());
        triggerDelete.setTableId(tableId);
        triggerDelete.setTriggerSql(triggerMap.get("delete"));
        triggerDelete.setTriggerType("3");
        triggerDelete.setName(table.getTableNameCh() + "\u6dfb\u52a0\u6570\u636e\u89e6\u53d1\u5668");
        triggerDelete.setCode(table.getTableNameEn() + "_delete_tiger");
        this.triggerManager.create((Model)triggerDelete);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveTableVo(TableDetailVo vo) {
        BizClusterTable table = vo.getTable();
        this.saveOrUpdate((Object)table);
        List<BizClusterTableField> oldFields = this.fieldManager.queryFieldByTableId(table.getId());
        if (BeanUtils.isNotEmpty(oldFields) && oldFields.size() > 0) {
            this.fieldManager.removeByIds(oldFields.stream().filter(p -> "2".equals(p.getFieldType())).map(entity -> entity.getId()).collect(Collectors.toList()));
        }
        List<BizClusterTableField> listField = vo.getFieldList();
        if (oldFields.size() == 0) {
            this.addManageField(listField);
        }
        for (BizClusterTableField item : listField) {
            item.setTableId(table.getId());
            item.setFieldName(item.getCode());
            item.setId(null);
        }
        if (listField.size() > 0) {
            this.fieldManager.saveBatch(listField);
        }
    }

    @Override
    public TableDetailVo queryTableVo(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        TableDetailVo vo = new TableDetailVo();
        BizClusterTable table = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        if (null == table) {
            throw new BaseException("\u672a\u67e5\u8be2\u5230\u8868");
        }
        vo.setTable(table);
        vo.setFieldList(this.fieldManager.queryFieldByTableId(tableId));
        return vo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createdTable(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizClusterTable table = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        List<BizClusterTableField> fieldList = this.fieldManager.queryFieldByTableId(tableId);
        BizClusterInfoMode info = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)info.getDatabaseAlias());
        table.setIsCreateTable(1);
        this.update((Model)table);
        String categoryId = "31063";
        String categoryName = "\u9ed8\u8ba4\u5206\u7c7b";
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void createdTrigger(String tableId) throws Exception {
        Assert.notNull((Object)tableId, (String)"\u8868ID\u4e0d\u80fd\u4e3a\u7a7a");
        BizClusterTable table = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        BizClusterInfoMode info = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        MySQLUtils.createTiger(template, table.getTableNameCh(), info.getCompanyName(), info.getSysName(), info.getSysCode(), table.getName(), table.getCode());
    }

    @Override
    public List<Map<String, String>> queryTriggerSql(String tableId) throws Exception {
        BizClusterTable table = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        BizClusterInfoMode info = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        String tableName = table.getTableNameCh();
        String companyName = info.getCompanyName();
        String sysName = info.getSysName();
        String sysCode = info.getSysCode();
        String name = table.getName();
        String code = table.getCode();
        String insertInsertSql = MySQLUtils.initTriggerSql(tableName, companyName, sysName, sysCode, name, code, "INSERT", "1");
        String insertUpdateSql = MySQLUtils.initTriggerSql(tableName, companyName, sysName, sysCode, name, code, "UPDATE", "2");
        String insertDeleteSql = MySQLUtils.initTriggerSql(tableName, companyName, sysName, sysCode, name, code, "DELETE", "2");
        ArrayList<Map<String, String>> triggers = new ArrayList<Map<String, String>>();
        HashMap<String, String> triggerInsertMap = new HashMap<String, String>();
        triggerInsertMap.put("sql", insertInsertSql);
        triggerInsertMap.put("name", tableName + "_insert_tiger ");
        triggerInsertMap.put("type", "INSERT");
        HashMap<String, String> triggerUpdateMap = new HashMap<String, String>();
        triggerUpdateMap.put("sql", insertUpdateSql);
        triggerUpdateMap.put("name", tableName + "_update_tiger ");
        triggerUpdateMap.put("type", "UPDATE");
        HashMap<String, String> triggerDelMap = new HashMap<String, String>();
        triggerDelMap.put("sql", insertDeleteSql);
        triggerDelMap.put("name", tableName + "_delete_tiger ");
        triggerDelMap.put("type", "DELETE");
        triggers.add(triggerInsertMap);
        triggers.add(triggerUpdateMap);
        triggers.add(triggerDelMap);
        return triggers;
    }

    private void addManageField(List<BizClusterTableField> fieldList) {
        BizClusterTableField createBy = new BizClusterTableField();
        createBy.setFieldName("CREATE_BY_");
        createBy.setName("\u521b\u5efa\u4eba");
        createBy.setCode("CREATE_BY_");
        createBy.setDesc("\u521b\u5efa\u4eba");
        createBy.setDataType("varchar");
        createBy.setAttrLength(200);
        createBy.setIsPk("0");
        createBy.setIsRequired("0");
        createBy.setIsEncrypt("0");
        createBy.setDecimalLen(0);
        createBy.setFieldType("1");
        createBy.setIsDele("0");
        BizClusterTableField createOrgId = new BizClusterTableField();
        createOrgId.setFieldName("CREATE_ORG_ID_");
        createOrgId.setName("\u521b\u5efa\u5355\u4f4d");
        createOrgId.setCode("CREATE_ORG_ID_");
        createOrgId.setDesc("\u521b\u5efa\u5355\u4f4d");
        createOrgId.setDataType("varchar");
        createOrgId.setAttrLength(200);
        createOrgId.setIsPk("0");
        createOrgId.setIsRequired("0");
        createOrgId.setIsEncrypt("0");
        createOrgId.setDecimalLen(0);
        createOrgId.setFieldType("1");
        createOrgId.setIsDele("0");
        BizClusterTableField createTime = new BizClusterTableField();
        createTime.setFieldName("CREATE_TIME_");
        createTime.setName("\u521b\u5efa\u65f6\u95f4");
        createTime.setCode("CREATE_TIME_");
        createTime.setDesc("\u521b\u5efa\u65f6\u95f4");
        createTime.setDataType("date");
        createTime.setAttrLength(0);
        createTime.setIsPk("0");
        createTime.setIsRequired("0");
        createTime.setIsEncrypt("0");
        createTime.setDecimalLen(0);
        createTime.setFieldType("1");
        createTime.setIsDele("0");
        BizClusterTableField id = new BizClusterTableField();
        id.setFieldName("ID_");
        id.setName("\u4e3b\u952e");
        id.setCode("ID_");
        id.setDesc("\u4e3b\u952e");
        id.setDataType("varchar");
        id.setAttrLength(500);
        id.setIsPk("1");
        id.setIsRequired("0");
        id.setIsEncrypt("0");
        id.setDecimalLen(0);
        id.setFieldType("1");
        id.setIsDele("0");
        id.setSn(-1);
        Set set = fieldList.stream().map(entity -> entity.getCode()).collect(Collectors.toSet());
        if (!set.contains(createBy.getCode())) {
            fieldList.add(createBy);
        }
        if (!set.contains(createOrgId.getCode())) {
            fieldList.add(createOrgId);
        }
        if (!set.contains(createTime.getCode())) {
            fieldList.add(createTime);
        }
        if (!set.contains(id.getCode())) {
            fieldList.add(id);
        }
    }

    @Override
    public String queryTableSql(String tableId) throws Exception {
        BizClusterTable table = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        if (org.apache.commons.lang3.StringUtils.isNotBlank((CharSequence)table.getCreateTableSql())) {
            return table.getCreateTableSql();
        }
        List<BizClusterTableField> fieldList = this.fieldManager.queryFieldByTableId(tableId);
        StringBuffer sb = new StringBuffer();
        String pkColumn = null;
        sb.append("CREATE TABLE " + table.getTableNameEn() + " (\n");
        for (int i = 0; i < fieldList.size(); ++i) {
            BizClusterTableField cm = fieldList.get(i);
            Integer attrLength = cm.getAttrLength() == null ? 0 : cm.getAttrLength();
            Integer decimalLen = cm.getDecimalLen() == null ? 4 : cm.getDecimalLen();
            sb.append(cm.getFieldName()).append(" ");
            sb.append(FieldUtil.getColumnType(cm.getDataType(), attrLength, attrLength, decimalLen));
            sb.append("1".equals(cm.getIsRequired()) ? " NOT NULL " : " NULL");
            sb.append(" ");
            String defaultValue = cm.getDefaultValue();
            if (StringUtils.isNotEmpty((String)defaultValue) && !"clob".equals(cm.getDataType())) {
                if ("number".equals(cm.getDataType()) || "int".equals(cm.getDataType())) {
                    sb.append(" default " + defaultValue);
                } else {
                    sb.append(" default '" + defaultValue + "' ");
                }
            }
            if ("1".equals(cm.getIsPk())) {
                pkColumn = pkColumn == null ? cm.getFieldName() : pkColumn + "," + cm.getFieldName();
            }
            if (cm.getDesc() != null && cm.getDesc().length() > 0) {
                sb.append(" COMMENT '" + cm.getDesc() + "'");
            }
            if (i >= fieldList.size() - 1) continue;
            sb.append(",\n");
        }
        sb.append("\n)");
        if (table.getDescription() != null && table.getDescription().length() > 0) {
            sb.append(" COMMENT='" + table.getDescription() + "'");
        }
        sb.append(";");
        System.out.println(sb);
        return sb.toString();
    }

    @Override
    public QueryResultData queryTableData(QueryParamVo queryParamVo) throws Exception {
        if (StringUtil.isEmpty((String)queryParamVo.getTableId()) && StringUtil.isEmpty((String)queryParamVo.getTableName())) {
            throw new ApplicationException("\u8868ID\u6216\u8005\u8868\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryParam queryParam = new QueryParam();
        BeanUtils.copyNotNullProperties((Object)queryParam, (Object)queryParamVo);
        BizClusterTable table = null;
        if (StringUtil.isNotEmpty((String)queryParam.getTableId())) {
            table = (BizClusterTable)((Object)this.getById((Serializable)((Object)queryParam.getTableId())));
        } else {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"TABLE_NAME_EN_", (Object)queryParamVo.getTableName());
            table = (BizClusterTable)((Object)((BizClusterTableDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
        }
        if (table == null) {
            return null;
        }
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        queryParam.setTableName(table.getTableNameEn());
        List<BizClusterTableField> fieldList = this.fieldManager.queryFieldByTableId(table.getId());
        HashMap<String, String> field = new HashMap<String, String>();
        for (BizClusterTableField item : fieldList) {
            if (!"2".equals(item.getFieldType())) continue;
            field.put(item.getCode(), item.getName());
        }
        field.put("ID_", "\u4e3b\u952e");
        queryParam.setField(field);
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        queryParam.setJdbcTemplate(template);
        queryParam.setDbType(infoMode.getDatabaseType());
        QueryResultData resultData = QueryDataTableFactory.getTableData(queryParam);
        return resultData;
    }

    @Override
    public List<BizClusterTable> queryDeployed() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"DEPLOYED_", (Object)1);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public List<BizClusterTable> queryTableByClusterId(String clusterId) throws Exception {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"CLUSTER_ID_", (Object)clusterId);
        return this.list((Wrapper)queryWrapper);
    }

    @Override
    public void downloadMainTempFile(HttpServletResponse response, String tableId) throws IOException, Exception {
        BizClusterTable dwTable = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        List<BizClusterTableField> field = this.fieldManager.queryFieldByTableId(tableId);
        if (field.size() == 0) {
            throw new ApplicationException("\u8d44\u6e90\u8868\u672a\u8bbe\u7f6e\u5b57\u6bb5\u3002");
        }
        LinkedHashMap<String, String> exportMap = new LinkedHashMap<String, String>();
        for (BizClusterTableField field1 : field) {
            if (!"2".equalsIgnoreCase(field1.getFieldType())) continue;
            exportMap.put(field1.getName(), field1.getDesc());
        }
        HSSFWorkbook book = ExcelUtil.exportExcel((String)dwTable.getName(), (int)12, exportMap, new ArrayList(), (int)0);
        String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
        FileUtil.createFolder((String)rootRealPath, (boolean)true);
        String path = rootRealPath + File.separator + System.currentTimeMillis() + ".xls";
        book.write(new File(path));
        dwTable.setDatafileDownUrl(path);
        ExcelUtil.downloadExcel((HSSFWorkbook)book, (String)(dwTable.getName() + "_\u5bfc\u5165\u6a21\u677f"), (HttpServletResponse)response);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void importMain(MultipartFile file, String tableId) throws Exception {
        BizClusterTable table = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        List<BizClusterTableField> fieldLists = this.fieldManager.queryFieldByTableId(tableId);
        HashMap<String, String> nameFieldMap = new HashMap<String, String>();
        for (BizClusterTableField field : fieldLists) {
            if (!"2".equalsIgnoreCase(field.getFieldType())) continue;
            nameFieldMap.put(field.getDesc(), field.getFieldName());
        }
        List rows = ExcelUtil.ImportDate((MultipartFile)file);
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        IUser user = ContextUtil.getCurrentUser();
        IGroup org = ContextUtil.getCurrentGroup();
        String uId = user.getUserId();
        String orgId = org.getGroupId();
        for (Map row : rows) {
            StringBuffer sql = new StringBuffer("insert into ");
            ArrayList<String> fields = new ArrayList<String>();
            ArrayList<String> values = new ArrayList<String>();
            fields.add(BizClusterTableField.PK_NAME);
            String bizId = UniqueIdUtil.getSuid();
            values.add(bizId);
            for (Map.Entry map : row.entrySet()) {
                String key;
                String field;
                if (!BeanUtils.isNotEmpty(map.getValue()) || "ID_".equalsIgnoreCase(field = this.getFieldName(key = (String)map.getKey(), fieldLists, (String)nameFieldMap.get(key))) || "F_form_data_rev_".equalsIgnoreCase(field)) continue;
                fields.add(field);
                String dataType = this.getDataType(key, fieldLists, (String)nameFieldMap.get(key));
                if ("number".equals(dataType)) {
                    values.add((String)map.getValue());
                    continue;
                }
                values.add("'" + (String)map.getValue() + "'");
            }
            sql.append(table.getTableNameEn());
            sql.append("(" + String.join((CharSequence)",", fields) + ",CREATE_BY_,CREATE_ORG_ID_,CREATE_TIME_)");
            sql.append(" values ");
            sql.append("(" + String.join((CharSequence)",", values) + ",'" + uId + "','" + orgId + "',now())");
            template.execute(sql.toString());
            BizClusterTempDataLog log = new BizClusterTempDataLog();
            log.setCompanyName(infoMode.getCompanyName());
            log.setSysName(infoMode.getSysName());
            log.setSysCode(infoMode.getSysCode());
            log.setName(table.getName());
            log.setCode(table.getCode());
            log.setDataType(1);
            log.setCreateTime(LocalDateTime.now());
            log.setTableName(table.getTableNameEn());
            log.setSrcId(bizId);
            this.tempDataLogManager.save((Object)log);
        }
    }

    private String getFieldName(String key, List<BizClusterTableField> columnList, String fieldName) {
        for (BizClusterTableField boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getFieldName();
        }
        return "";
    }

    private String getDataType(String key, List<BizClusterTableField> columnList, String fieldName) {
        for (BizClusterTableField boAtt : columnList) {
            if (!boAtt.getDesc().equals(key) && !boAtt.getName().equals(fieldName)) continue;
            return boAtt.getDataType();
        }
        return "";
    }

    @Override
    public IPage<BizClusterTable> getClusterTableQueryList(QueryFilter<BizClusterTable> queryFilter) throws Exception {
        return ((BizClusterTableDao)this.baseMapper).getClusterTableQueryList((IPage<BizClusterTable>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizClusterTable>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
    }

    @Override
    @Transactional
    public void deployHaveTable(String tableId, String createTrigger) throws Exception {
        BizClusterTable table = (BizClusterTable)this.get((Serializable)((Object)tableId));
        if (1 == table.getDeployed()) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        this.update((Model)table);
        if ("1".equals(createTrigger)) {
            BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
            this.createTrigger(template, table);
        }
    }

    @Override
    @Transactional
    public void deployDotHaveTable(String tableId, String tableSql, String createTrigger) throws Exception {
        BizClusterTable table = (BizClusterTable)this.get((Serializable)((Object)tableId));
        List<BizClusterTableField> tableFields = this.fieldManager.queryFieldByTableId(tableId);
        if (1 == table.getDeployed()) {
            throw new ApplicationException("\u8868\u5df2\u7ecf\u53d1\u5e03\uff0c\u4e0d\u80fd\u4ece\u91cd\u590d\uff0c\u5982\u679c\u6709\u95ee\u9898\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
        }
        if (tableFields.size() == 0) {
            throw new ApplicationException("\u8868\u5185\u6ca1\u6709\u5b57\u6bb5\u4e0d\u80fd\u53d1\u5e03");
        }
        table.setCreateTableSql(tableSql);
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        table.setIsCreateTable(1);
        table.setDeployed(1);
        table.setDeployedTime(LocalDateTime.now());
        table.setCreateTableSql(tableSql);
        template.execute(table.getCreateTableSql());
        this.update((Model)table);
        if ("1".equals(createTrigger)) {
            this.createTrigger(template, table);
        }
    }

    public void createTrigger(JdbcTemplate template, BizClusterTable table) {
        String tableId = table.getId();
        BizClusterInfoMode info = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        Map<String, String> triggerMap = MySQLUtils.createTiger(template, table.getTableNameEn(), info.getCompanyName(), info.getSysName(), info.getSysCode(), table.getName(), table.getCode());
        BizClusterTableTrigger triggerInsert = new BizClusterTableTrigger();
        triggerInsert.setIsCreateTable(1);
        triggerInsert.setMouldCode(table.getCode());
        triggerInsert.setMouldName(table.getTableNameCh());
        triggerInsert.setTableId(tableId);
        triggerInsert.setTriggerSql(triggerMap.get("insert"));
        triggerInsert.setTriggerType("1");
        triggerInsert.setName(table.getTableNameCh() + "\u6dfb\u52a0\u6570\u636e\u89e6\u53d1\u5668");
        triggerInsert.setCode(table.getTableNameEn() + "_insert_tiger");
        this.triggerManager.create((Model)triggerInsert);
        BizClusterTableTrigger triggerUpdate = new BizClusterTableTrigger();
        triggerUpdate.setIsCreateTable(1);
        triggerUpdate.setMouldCode(table.getCode());
        triggerUpdate.setMouldName(table.getTableNameCh());
        triggerUpdate.setTableId(tableId);
        triggerUpdate.setTriggerSql(triggerMap.get("update"));
        triggerUpdate.setTriggerType("2");
        triggerUpdate.setName(table.getTableNameCh() + "\u4fee\u6539\u6570\u636e\u89e6\u53d1\u5668");
        triggerUpdate.setCode(table.getTableNameEn() + "_update_tiger");
        this.triggerManager.create((Model)triggerUpdate);
        BizClusterTableTrigger triggerDelete = new BizClusterTableTrigger();
        triggerDelete.setIsCreateTable(1);
        triggerDelete.setMouldCode(table.getCode());
        triggerDelete.setMouldName(table.getTableNameCh());
        triggerDelete.setTableId(tableId);
        triggerDelete.setTriggerSql(triggerMap.get("delete"));
        triggerDelete.setTriggerType("3");
        triggerDelete.setName(table.getTableNameCh() + "\u6dfb\u52a0\u6570\u636e\u89e6\u53d1\u5668");
        triggerDelete.setCode(table.getTableNameEn() + "_delete_tiger");
        this.triggerManager.create((Model)triggerDelete);
    }

    @Override
    @Transactional
    public void copyTable(CopyTableVo vo) throws Exception {
        String sourceTableId = vo.getSourceTableId();
        List<BizClusterTableField> fields = this.fieldManager.queryFieldByTableId(sourceTableId);
        BizClusterTable table = CopyTableVo.parse(vo);
        table.setId(null);
        this.save((Object)table);
        for (BizClusterTableField item : fields) {
            item.setTableId(table.getId());
            item.setFieldName(item.getCode());
            item.setCreateBy(null);
            item.setCreateOrgId(null);
            item.setCreateTime(null);
            item.setUpdateBy(null);
            item.setUpdateOrgId(null);
            item.setUpdateTime(null);
            item.setIsCreate("1");
        }
        if (fields.size() > 0) {
            this.fieldManager.saveOrUpdateBatch(fields);
        }
    }

    @Override
    public boolean checkTableExists(String clusterId, String tableNameEn) throws Exception {
        String sql;
        BizClusterInfo info = (BizClusterInfo)((Object)this.infoManager.getById((Serializable)((Object)clusterId)));
        tableNameEn = info.getSysTableCode() + "_" + tableNameEn;
        if (this.checkTable(tableNameEn)) {
            return true;
        }
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)clusterId)));
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void removeTable(String tableId) throws Exception {
        BizClusterTable table = (BizClusterTable)((Object)this.getById((Serializable)((Object)tableId)));
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)table.getClusterId())));
        boolean exists = this.checkPhysicsTableExists(table.getClusterId(), table.getTableNameEn());
        if (exists && "1".equals(table.getDeployed())) {
            String dropSql = "drop table " + table.getTableNameEn();
            JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
            template.execute(dropSql);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TABLE_ID_", (Object)tableId);
        this.removeById((Serializable)((Object)tableId));
        this.fieldManager.getBaseMapper().delete((Wrapper)queryWrapper);
    }

    @Override
    public boolean checkPhysicsTableExists(String clusterId, String tableNameEn) throws Exception {
        String sql;
        BizClusterInfoMode infoMode = (BizClusterInfoMode)((Object)this.infoModeManager.getById((Serializable)((Object)clusterId)));
        JdbcTemplate template = DataSourceUtil.getJdbcTempByDsAlias((String)infoMode.getDatabaseAlias());
        return (Integer)template.queryForObject(sql = "select count(1) from information_schema.TABLES t where table_name ='" + tableNameEn + "'", Integer.class) > 0;
    }
}

