/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.algorithm.manager.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.ExcelWriter;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.builder.ExcelWriterTableBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.WriteSheet;
import com.alibaba.excel.write.metadata.WriteTable;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.dataShare.algorithm.dao.BizAlgorithmReasonDao;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmCatalogsIndexManager;
import com.artfess.dataShare.algorithm.manager.BizAlgorithmReasonManager;
import com.artfess.dataShare.algorithm.model.BizAlgorithmCatalogsIndex;
import com.artfess.dataShare.algorithm.model.BizAlgorithmReason;
import com.artfess.dataShare.algorithm.vo.TaskReasonVo;
import com.artfess.dataShare.util.ExcelFillCellMergeStrategy;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;

@Service
public class BizAlgorithmReasonManagerImpl
extends BaseManagerImpl<BizAlgorithmReasonDao, BizAlgorithmReason>
implements BizAlgorithmReasonManager {
    @Resource
    BizAlgorithmCatalogsIndexManager indexManager;
    @Resource
    BizAlgorithmReasonDao reasonDao;

    @Override
    public void saveReason(BizAlgorithmReason reason) {
        String id = reason.getId();
        BizAlgorithmReason temp = (BizAlgorithmReason)((Object)this.getById((Serializable)((Object)id)));
        if (null == temp) {
            this.saveTree(reason, false);
        } else {
            this.updateTree(reason, temp.getName(), false);
        }
    }

    @Override
    public List<BizAlgorithmReason> queryByVersionId(String versionId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TASK_VERSON_ID", (Object)versionId);
        queryWrapper.orderByAsc((Object)"FULL_ID_");
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public List<BizAlgorithmReason> queryByTypeAndVersionId(String versionId, Integer type) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"TASK_VERSON_ID", (Object)versionId);
        queryWrapper.eq((Object)"TYPE_", (Object)type);
        queryWrapper.orderByAsc((Object)"FULL_ID_");
        List list = this.list((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public List<BizAlgorithmReason> queryTreeByVersionId(String versionId) {
        BizAlgorithmReason reason = new BizAlgorithmReason();
        reason.setTaskVersonId(versionId);
        return this.getTree(reason);
    }

    @Override
    public List<BizAlgorithmReason> getTree(BizAlgorithmReason entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)entity.getCode())) {
            queryWrapper.like((Object)"code_", (Object)entity.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
            queryWrapper.like((Object)"TASK_VERSON_ID", (Object)entity.getTaskVersonId());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
            queryWrapper.like((Object)"name_", (Object)entity.getName());
        }
        queryWrapper.orderByAsc((Object)"sn_");
        List sysList = ((BizAlgorithmReasonDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        List tree = BeanUtils.listToTree((List)sysList);
        return tree;
    }

    @Override
    public List<TaskReasonVo> queryTaskAndReason(String indexId, String type) {
        List<TaskReasonVo> voList = this.reasonDao.queryTaskReasonList(indexId, type);
        return voList;
    }

    @Override
    public String exportTaskAndReason(String indexId, String type) {
        ArrayList<String> oneHeads;
        BizAlgorithmCatalogsIndex catalogsIndex = (BizAlgorithmCatalogsIndex)((Object)this.indexManager.getById((Serializable)((Object)indexId)));
        List<TaskReasonVo> voList = this.reasonDao.queryTaskReasonList(indexId, type);
        ArrayList dataOneToMoreList = new ArrayList();
        ArrayList dataList = new ArrayList();
        ArrayList headOneToMore = new ArrayList();
        ArrayList headMoreToOne = new ArrayList();
        if ("1".equals(type)) {
            String headOneStr = "\u6307\u6807\u7c7b\u578b,\u6307\u6807\u540d\u79f0,\u63a8\u7406\u7c7b\u578b,\u7b97\u6cd5\u63a8\u7406\u4efb\u52a1\u540d\u79f0,\u4efb\u52a1\u7248\u672c,\u5173\u8054\u6307\u6807\uff08\u4e0b\u7ea7\uff09,\u6307\u6807\u7c7b\u578b,\u5173\u8054\u63cf\u8ff0,\u8ba1\u7b97\u5de5\u5f0f\u8bf4\u660e";
            String head1 = this.getLevelStr(catalogsIndex.getLevel()) + "\u3010" + catalogsIndex.getName() + "\u3011\uff08\u4e00\u63a8\u591a\uff09";
            List<String> oneHead = Arrays.asList(headOneStr.split(","));
            for (String string : oneHead) {
                oneHeads = new ArrayList<String>();
                oneHeads.add(head1);
                oneHeads.add(string);
                headOneToMore.add(oneHeads);
            }
            List typeOneToMore = voList.stream().filter(p -> "1".equals(p.getType())).collect(Collectors.toList());
            Iterator iterator = typeOneToMore.iterator();
            while (iterator.hasNext()) {
                TaskReasonVo vo = (TaskReasonVo)iterator.next();
                ArrayList<String> data = new ArrayList<String>();
                data.add(this.getLevelStr(vo.getLevel()));
                data.add(vo.getName());
                data.add(vo.getContent());
                data.add(vo.getRelationContent());
                data.add(vo.getVersionName());
                data.add(vo.getTaskName());
                data.add("\u4e00\u63a8\u591a");
                data.add(vo.getReasonName());
                data.add(this.getLevelStr(vo.getIndexType()));
                dataOneToMoreList.add(data);
            }
        } else if ("2".equals(type)) {
            String headMoreStr = "\u6307\u6807\u7c7b\u578b,\u6307\u6807\u540d\u79f0,\u5173\u8054\u63cf\u8ff0,\u8ba1\u7b97\u8bf4\u660e,\u4efb\u52a1\u7248\u672c,\u7b97\u6cd5\u63a8\u7406\u4efb\u52a1\u540d\u79f0,\u63a8\u7406\u7c7b\u578b,\u6307\u6807\u540d\u79f0,\u6307\u6807\u7c7b\u578b";
            String head2 = this.getLevelStr(catalogsIndex.getLevel()) + "\u3010" + catalogsIndex.getName() + "\u3011\uff08\u591a\u63a8\u4e00\uff09";
            List<String> oneHead1 = Arrays.asList(headMoreStr.split(","));
            for (String string : oneHead1) {
                oneHeads = new ArrayList();
                oneHeads.add(head2);
                oneHeads.add(string);
                headMoreToOne.add(oneHeads);
            }
            List typeMoreToOne = voList.stream().filter(p -> "2".equals(p.getType())).collect(Collectors.toList());
            for (TaskReasonVo vo : typeMoreToOne) {
                ArrayList<String> data = new ArrayList<String>();
                data.add(this.getLevelStr(vo.getIndexType()));
                data.add(vo.getReasonName());
                data.add(vo.getContent());
                data.add(vo.getRelationContent());
                data.add(vo.getVersionName());
                data.add(vo.getTaskName());
                data.add("\u591a\u63a8\u4e00");
                data.add(vo.getName());
                data.add(this.getLevelStr(vo.getLevel()));
                dataList.add(data);
            }
        }
        String rootRealPath = (FileUtil.getIoTmpdir() + "/temp/").replace("/", File.separator);
        FileUtil.createFolder((String)rootRealPath, (boolean)true);
        String filePath = rootRealPath + File.separator + System.currentTimeMillis() + ".xls";
        try {
            FileOutputStream outputStream = new FileOutputStream(new File(filePath));
            ExcelWriter writer = EasyExcel.write((OutputStream)outputStream).build();
            if ("1".equals(type)) {
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)0).needHead(Boolean.FALSE)).sheetName("\u4e00\u63a8\u591a").build();
                WriteTable table = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)1).head(headOneToMore)).registerWriteHandler((WriteHandler)new ExcelFillCellMergeStrategy(1, new int[]{0, 1, 2, 3, 4}))).needHead(Boolean.TRUE)).build();
                writer.write(dataOneToMoreList, writeSheet, table);
            } else if ("2".equals(type)) {
                WriteSheet writeSheet = ((ExcelWriterSheetBuilder)EasyExcel.writerSheet((Integer)1).needHead(Boolean.FALSE)).sheetName("\u591a\u63a8\u4e00").build();
                WriteTable table1 = ((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)((ExcelWriterTableBuilder)EasyExcel.writerTable((Integer)2).head(headMoreToOne)).registerWriteHandler((WriteHandler)new ExcelFillCellMergeStrategy(1, new int[]{4, 5, 6, 7, 8}))).needHead(Boolean.TRUE)).build();
                writer.write(dataList, writeSheet, table1);
            }
            writer.finish();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return filePath;
    }

    @Override
    public List<BizAlgorithmReason> queryReason(String taskId, String versionId) {
        return this.reasonDao.queryReason(taskId, versionId);
    }

    public String getLevelStr(String level) {
        if ("1".equals(level)) {
            return "\u7ed3\u679c\u6307\u6807";
        }
        if ("12".equals(level)) {
            return "\u95ee\u9898\u6307\u6807";
        }
        if ("3".equals(level)) {
            return "\u5c5e\u6027\u6307\u6807";
        }
        return "";
    }
}

