/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.ods.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsFieldManager;
import com.artfess.dataShare.dataResource.ods.manager.BizOdsTableManager;
import com.artfess.dataShare.dataResource.ods.model.BizOdsField;
import com.artfess.dataShare.dataResource.ods.model.BizOdsTable;
import com.artfess.dataShare.dataResource.ods.vo.BizOdsTableVo;
import com.artfess.dataShare.dataResource.ods.vo.CatalogTableVo;
import com.artfess.dataShare.dataResource.ods.vo.OdsTableDetailVo;
import com.artfess.dataShare.factory.QueryParamVo;
import com.artfess.dataShare.factory.QueryResultData;
import com.artfess.dataShare.util.DorisUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/biz/dataResource/odsTable/v1/"})
@Api(tags={"\u6570\u636e\u8d44\u6e90--ODS\u6570\u636e\u9879\u4fe1\u606f"})
@ApiGroup(group={"group_biz_dataShare"})
public class BizOdsTableController
extends BaseController<BizOdsTableManager, BizOdsTable> {
    @Resource
    BizOdsTableManager tableManager;
    @Resource
    BizOdsFieldManager fieldManager;

    @PostMapping(value={"/importFile"})
    @ApiOperation(value="\u5bfc\u5165\u6570\u636e\u8d44\u4ea7-ODS\u6570\u636e\u9879", httpMethod="POST", notes="\u5bfc\u5165\u6570\u636e\u8d44\u4ea7-ODS\u6570\u636e\u9879")
    public CommonResult export(@RequestParam(value="file", required=true) MultipartFile file, String catalogId) throws Exception {
        this.tableManager.export(file, catalogId);
        return new CommonResult("\u5bfc\u5165\u4e3b\u8868\u6210\u529f");
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u5b9e\u4f53\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u5b9e\u4f53\u4fe1\u606f") @Validated(value={AddGroup.class}) @RequestBody BizOdsTable t) {
        boolean result;
        if (StringUtil.isEmpty((String)t.getId())) {
            t.setDeployed(0);
            t.setIsCreateTable(0);
            t.setIsDele("0");
            t.setTableNameEn("ods_" + t.getTableNameEn().replaceFirst("ods_", ""));
        }
        if (!(result = ((BizOdsTableManager)this.baseService).save((Object)t))) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PostMapping(value={"/saveTable"})
    @ApiOperation(value="\u4ece\u4ea4\u6362\u5e93\u91cc\u9762\u9009\u62e9\u8868\uff0c\u628a\u6a21\u578b\u548c\u5b57\u6bb5\u521b\u5efa\u5230ODS\u5e93", httpMethod="POST", notes="\u4ece\u4ea4\u6362\u5e93\u91cc\u9762\u9009\u62e9\u8868\uff0c\u628a\u6a21\u578b\u548c\u5b57\u6bb5\u521b\u5efa\u5230ODS\u5e93")
    public CommonResult saveTable(@RequestBody CatalogTableVo vo) throws Exception {
        this.tableManager.saveTable(vo.getCatalogId(), vo.getTableId());
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/saveTableBatch"})
    @ApiOperation(value="\u6279\u91cf\u521b\u5efa\u5230ODS\u5e93")
    public CommonResult<String> saveTableBatch(@RequestBody List<CatalogTableVo> list) throws Exception {
        boolean result = this.tableManager.saveTableBatch(list);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION);
        }
        return CommonResult.success(null, (String)"\u64cd\u4f5c\u6210\u529f");
    }

    @GetMapping(value={"/detail/{id}"})
    @ApiOperation(value="\u6839\u636eID\u67e5\u8be2\u8868\u4fe1\u606f\u548c\u5b57\u6bb5\u96c6\u5408", httpMethod="GET", notes="\u6839\u636eID\u67e5\u8be2\u8868\u4fe1\u606f\u548c\u5b57\u6bb5\u96c6\u5408")
    public CommonResult queryDetail(@PathVariable String id) throws Exception {
        BizOdsTable table = (BizOdsTable)((Object)this.tableManager.getById((Serializable)((Object)id)));
        List<BizOdsField> fieldList = this.fieldManager.queryFieldByTableId(id);
        BizOdsTableVo vo = new BizOdsTableVo();
        BeanUtils.copyNotNullProperties((Object)((Object)vo), (Object)((Object)table));
        vo.setFieldList(fieldList);
        return CommonResult.success((Object)((Object)vo), (String)"");
    }

    @PostMapping(value={"/deploy/{tableId}"})
    @ApiOperation(value="\u672a\u6709\u8868\u53d1\u5e03(\u9ed8\u8ba4\u7684\u5efa\u8868SQL)-\u53d1\u5e03\u8868\uff0c\u521b\u5efa\u5b9e\u4f53\u8868")
    public CommonResult Deploy(@PathVariable String tableId) throws Exception {
        this.tableManager.Deploy(tableId);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @PostMapping(value={"/queryTableVo/{tableId}"})
    @ApiOperation(value="\u6839\u636e\u8868\u67e5\u8be2\u8868\u4fe1\u606f\u3001\u5b57\u6bb5\u4fe1\u606f\u3001\u6a21\u578b")
    public OdsTableDetailVo queryTableVo(@PathVariable String tableId) throws Exception {
        OdsTableDetailVo vo = this.tableManager.queryTableVo(tableId);
        return vo;
    }

    @PostMapping(value={"/queryTableData"})
    @ApiOperation(value="\u6570\u636e\u67e5\u8be2  \u5206\u9875\uff0c\u52a0\u641c\u7d22\u3001\u6392\u5e8f")
    public QueryResultData queryTableData(@RequestBody QueryParamVo queryParamVo) throws Exception {
        return this.tableManager.queryTableData(queryParamVo);
    }

    @PostMapping(value={"/removeTable"})
    @ApiOperation(value="\u5220\u9664\u8868\u548c\u5b57\u6bb5-\u5982\u679c\u8868\u5df2\u7ecf\u521b\u5efa\u540c\u6b65\u5220\u9664\u5b9e\u4f53\u8868")
    public CommonResult queryTableData(@RequestParam String tableId) throws Exception {
        this.tableManager.removeTable(tableId);
        return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
    }

    @RequestMapping(value={"downloadMainTempFile/{tableId}"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f", httpMethod="POST", notes="\u4e0b\u8f7d\u5bfc\u5165\u7684\u6a21\u677f")
    public void downloadMainTempFile(HttpServletResponse response, @ApiParam(name="tableId", value="\u6a21\u677f\u522b\u540d", required=true) @PathVariable String tableId) throws Exception {
        ((BizOdsTableManager)this.baseService).downloadMainTempFile(response, tableId);
    }

    @PostMapping(value={"importMain"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5bfc\u5165\u4e3b\u8868\u6570\u636e", httpMethod="POST", notes="\u5bfc\u5165\u4e3b\u8868\u6570\u636e")
    public CommonResult<String> importMain(@RequestParam(value="file", required=true) MultipartFile file, @RequestParam(value="tableId", required=true) String tableId) throws Exception {
        ((BizOdsTableManager)this.baseService).importMain(file, tableId);
        return new CommonResult("\u5bfc\u5165\u4e3b\u8868\u6570\u636e\u6210\u529f");
    }

    @PostMapping(value={"/queryTableSql/{tableId}"})
    @ApiOperation(value="\u6839\u636e\u8868ID\u83b7\u53d6\u5efa\u8868\u8bed\u53e5")
    public CommonResult<String> queryTableSql(@PathVariable String tableId) throws Exception {
        OdsTableDetailVo vo = this.tableManager.queryTableVo(tableId);
        if (StringUtils.isNotBlank((CharSequence)vo.getTable().getCreateTableSql())) {
            return CommonResult.success((Object)vo.getTable().getCreateTableSql(), (String)"\u83b7\u53d6\u6210\u529f");
        }
        String tableDesc = vo.getTable().getTableDesc() == null ? vo.getTable().getTableNameCh() : vo.getTable().getTableDesc();
        String sql = DorisUtils.getOdsTableSql(vo.getTable().getTableNameEn(), tableDesc, vo.getFieldList());
        return CommonResult.success((Object)sql, (String)"\u83b7\u53d6\u6210\u529f");
    }

    @PostMapping(value={"checkTableExists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<String> checkTableExists(@ApiParam(name="tableNameEn", value="\u8868\u82f1\u6587\u540d") @RequestParam String tableNameEn, @ApiParam(name="type", value="\u53d1\u5e03\u7c7b\u578b(0:\u672a\u6709\u8868\u53d1\u5e03\uff0c1:\u5df2\u6709\u8868\u53d1\u5e03)") @RequestParam(required=false) String type) throws Exception {
        boolean isExists = this.tableManager.checkTableExists(tableNameEn);
        if ("1".equals(type)) {
            if (isExists) {
                return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f\uff0c\u53ef\u4ee5\u53d1\u5e03");
            }
            return new CommonResult(false, "\u8868" + tableNameEn + "\u4e0d\u5b58\u5728\uff01");
        }
        if (isExists) {
            return new CommonResult(false, "\u8868" + tableNameEn + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u8868\u540d");
        }
        return new CommonResult(true, "\u53ef\u4ee5\u4f7f\u7528\u8868\u540d");
    }

    @PostMapping(value={"checkPhysicsTableExists"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u7269\u7406\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728", httpMethod="POST", notes="\u9a8c\u8bc1\u8868\u662f\u5426\u5df2\u7ecf\u5b58\u5728")
    public CommonResult<String> checkPhysicsTableExists(@ApiParam(name="tableNameEn", value="\u8868\u82f1\u6587\u540d") @RequestParam String tableNameEn, @ApiParam(name="type", value="\u53d1\u5e03\u7c7b\u578b(0:\u672a\u6709\u8868\u53d1\u5e03\uff0c1:\u5df2\u6709\u8868\u53d1\u5e03)") @RequestParam(required=false) String type) throws Exception {
        boolean isExists = this.tableManager.checkPhysicsTableExists(tableNameEn);
        if ("1".equals(type)) {
            if (isExists) {
                return new CommonResult(true, "\u9a8c\u8bc1\u6210\u529f\uff0c\u53ef\u4ee5\u53d1\u5e03");
            }
            return new CommonResult(false, "\u8868" + tableNameEn + "\u4e0d\u5b58\u5728\uff01");
        }
        if (isExists) {
            return new CommonResult(false, "\u8868" + tableNameEn + "\u5df2\u7ecf\u5b58\u5728\uff0c\u8bf7\u66f4\u6362\u8868\u540d");
        }
        return new CommonResult(true, "\u53ef\u4ee5\u4f7f\u7528\u8868\u540d");
    }

    @PostMapping(value={"saveTableSql"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u5efa\u8868SQL", httpMethod="POST", notes="\u4fdd\u5b58\u5efa\u8868SQL")
    public CommonResult<String> saveTableSql(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId, @ApiParam(name="tableSql", value="\u5efa\u8868\u8bed\u53e5") @RequestParam String tableSql) throws Exception {
        BizOdsTable table = (BizOdsTable)((Object)this.tableManager.getById((Serializable)((Object)tableId)));
        table.setCreateTableSql(tableSql);
        this.tableManager.updateById((Object)table);
        return new CommonResult(true, "\u4fdd\u5b58\u5efa\u8868SQL\u6210\u529f");
    }

    @RequestMapping(value={"deployHaveTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5df2\u6709\u8868\u53d1\u5e03", httpMethod="POST", notes="\u5df2\u6709\u8868\u53d1\u5e03")
    public CommonResult<String> deployHaveTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId) throws Exception {
        this.tableManager.deployHaveTable(tableId);
        return new CommonResult(true, "\u5df2\u6709\u8868\u53d1\u5e03\u6210\u529f");
    }

    @RequestMapping(value={"deployDotHaveTable"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u672a\u6709\u8868\u53d1\u5e03", httpMethod="POST", notes="\u672a\u6709\u8868\u53d1\u5e03")
    public CommonResult<String> deployDotHaveTable(@ApiParam(name="tableId", value="\u6570\u636e\u8868ID") @RequestParam String tableId, @ApiParam(name="tableSql", value="\u5efa\u8868\u8bed\u53e5") @RequestParam String tableSql) throws Exception {
        this.tableManager.deployDotHaveTable(tableId, tableSql);
        return new CommonResult(true, "\u672a\u6709\u8868\u53d1\u5e03");
    }

    @RequestMapping(value={"updateCatalog"}, method={RequestMethod.PUT}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fee\u6539\u8868\u8d44\u6e90\u76ee\u5f55", httpMethod="PUT", notes="\u4fee\u6539\u8868\u8d44\u6e90\u76ee\u5f55")
    public CommonResult<String> updateCatalog(@RequestParam String[] ids, @RequestParam String catalogId) {
        boolean result = this.tableManager.updateCatalog(ids, catalogId);
        if (result) {
            return new CommonResult(true, "\u64cd\u4f5c\u6210\u529f");
        }
        return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25");
    }
}

