/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataShare.manager.impl;

import com.artfess.base.exception.ApplicationException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.DataSourceUtil;
import com.artfess.dataShare.dataShare.dao.BizShareAuthDao;
import com.artfess.dataShare.dataShare.dto.ApiAuthDto;
import com.artfess.dataShare.dataShare.dto.FilesAuthDto;
import com.artfess.dataShare.dataShare.dto.TableAuthDto;
import com.artfess.dataShare.dataShare.manager.BizShareApiManager;
import com.artfess.dataShare.dataShare.manager.BizShareAuthManager;
import com.artfess.dataShare.dataShare.manager.BizShareConsumerManager;
import com.artfess.dataShare.dataShare.manager.BizShareFilesManager;
import com.artfess.dataShare.dataShare.manager.BizShareTableManager;
import com.artfess.dataShare.dataShare.model.BizShareApi;
import com.artfess.dataShare.dataShare.model.BizShareAuth;
import com.artfess.dataShare.dataShare.model.BizShareConsumer;
import com.artfess.dataShare.dataShare.model.BizShareFiles;
import com.artfess.dataShare.dataShare.model.BizShareTable;
import com.artfess.dataShare.dataShare.vo.ConsumerAuthVo;
import com.artfess.dataShare.util.MySQLUtils;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BizShareAuthManagerImpl
extends BaseManagerImpl<BizShareAuthDao, BizShareAuth>
implements BizShareAuthManager {
    @Resource
    private BizShareTableManager tableManager;
    @Resource
    private BizShareConsumerManager consumerManager;
    @Resource
    private BizShareFilesManager filesManager;
    @Resource
    private BizShareApiManager apiManager;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean auth(List<BizShareAuth> list) throws Exception {
        for (BizShareAuth auth : list) {
            if (!this.save((Object)auth) || !"1".equals(auth.getResourceType())) continue;
            BizShareConsumer consumer = (BizShareConsumer)this.consumerManager.get((Serializable)((Object)auth.getMemberId()));
            if (!"1".equals(consumer.getIsOpenDb())) {
                throw new ApplicationException("\u3010" + consumer.getName() + "\u3011\u6ca1\u6709\u5f00\u901a\u5e93\u8868\u5171\u4eab!");
            }
            auth.setResourceId(null);
            String tableId = auth.getTableId();
            BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)tableId));
            String dbAlias = table.getDbAlias();
            String tableCode = table.getTableCode();
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)dbAlias);
            MySQLUtils.createGrant(jdbcTemplate, "SELECT", consumer.getDataBaseName(), tableCode, consumer.getDatabaseUser());
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean revokeAuth(List<String> ids) throws Exception {
        for (String id : ids) {
            BizShareAuth auth = (BizShareAuth)this.get((Serializable)((Object)id));
            if ("1".equals(auth.getResourceType())) {
                BizShareConsumer consumer = (BizShareConsumer)this.consumerManager.get((Serializable)((Object)auth.getMemberId()));
                String tableId = auth.getTableId();
                BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)tableId));
                String dbAlias = table.getDbAlias();
                String tableCode = table.getTableCode();
                JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)dbAlias);
                MySQLUtils.revokeGrant(jdbcTemplate, "SELECT", consumer.getDataBaseName(), tableCode, consumer.getDatabaseUser());
            }
            this.removeById((Serializable)((Object)id));
        }
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean tableAuth(List<BizShareAuth> list) throws Exception {
        for (BizShareAuth auth : list) {
            if (!this.save((Object)auth)) continue;
            BizShareConsumer consumer = (BizShareConsumer)this.consumerManager.get((Serializable)((Object)auth.getMemberId()));
            if (!"1".equals(consumer.getIsOpenDb())) {
                throw new ApplicationException("\u3010" + consumer.getName() + "\u3011\u6ca1\u6709\u5f00\u901a\u5e93\u8868\u5171\u4eab!");
            }
            String tableId = auth.getTableId();
            BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)tableId));
            String dbAlias = table.getDbAlias();
            String tableCode = table.getTableCode();
            JdbcTemplate jdbcTemplate = DataSourceUtil.getJdbcTempByDsAlias((String)dbAlias);
            MySQLUtils.createGrant(jdbcTemplate, "SELECT", consumer.getDataBaseName(), tableCode, consumer.getDatabaseUser());
        }
        return true;
    }

    @Override
    public PageList<ConsumerAuthVo> queryPageByConsumer(QueryFilter<BizShareAuth> queryFilter, String consumerId, String resourceType) {
        IPage<BizShareAuth> iPage = ((BizShareAuthDao)this.baseMapper).queryPageByConsumer((IPage<BizShareAuth>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()), consumerId, resourceType);
        PageList pageList = new PageList(iPage);
        PageList pageVo = new PageList();
        pageVo.setPage(pageList.getPage());
        pageVo.setPageSize(pageList.getPageSize());
        pageVo.setTotal(pageList.getTotal());
        ArrayList<ConsumerAuthVo> authVoList = new ArrayList<ConsumerAuthVo>();
        List authList = pageList.getRows();
        for (BizShareAuth auth : authList) {
            ConsumerAuthVo consumerAuthVo = new ConsumerAuthVo();
            consumerAuthVo.setAuthId(auth.getId());
            BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)auth.getTableId()));
            consumerAuthVo.setTable(table);
            String resourceId = auth.getResourceId();
            if ("2".equals(resourceType)) {
                BizShareFiles files = (BizShareFiles)this.filesManager.get((Serializable)((Object)resourceId));
                consumerAuthVo.setFiles(files);
            }
            if ("3".equals(resourceType)) {
                BizShareApi api = (BizShareApi)this.apiManager.get((Serializable)((Object)resourceId));
                consumerAuthVo.setApi(api);
            }
            authVoList.add(consumerAuthVo);
        }
        pageVo.setRows(authVoList);
        return pageVo;
    }

    @Override
    public PageList<ConsumerAuthVo> queryPageByResource(QueryFilter<BizShareAuth> queryFilter, String resourceId, String resourceType) {
        IPage<BizShareAuth> iPage = ((BizShareAuthDao)this.baseMapper).queryPageByResource((IPage<BizShareAuth>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()), resourceId, resourceType);
        PageList pageList = new PageList(iPage);
        PageList pageVo = new PageList();
        pageVo.setPage(pageList.getPage());
        pageVo.setPageSize(pageList.getPageSize());
        pageVo.setTotal(pageList.getTotal());
        ArrayList<ConsumerAuthVo> authVoList = new ArrayList<ConsumerAuthVo>();
        List authList = pageList.getRows();
        for (BizShareAuth auth : authList) {
            ConsumerAuthVo consumerAuthVo = new ConsumerAuthVo();
            consumerAuthVo.setAuthId(auth.getId());
            BizShareConsumer consumer = (BizShareConsumer)this.consumerManager.get((Serializable)((Object)auth.getMemberId()));
            consumerAuthVo.setConsumer(consumer);
            authVoList.add(consumerAuthVo);
        }
        pageVo.setRows(authVoList);
        return pageVo;
    }

    @Override
    public PageList<TableAuthDto> queryTableAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId) {
        IPage<BizShareAuth> iPage = ((BizShareAuthDao)this.baseMapper).queryTableAuth((IPage<BizShareAuth>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()), consumerId);
        PageList pageList = new PageList(iPage);
        ArrayList<TableAuthDto> resultList = new ArrayList<TableAuthDto>();
        List rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            TableAuthDto tableAuthDto = new TableAuthDto();
            BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)auth.getTableId()));
            tableAuthDto.setAuthId(auth.getId());
            tableAuthDto.setTableId(table.getId());
            tableAuthDto.setTableName(table.getName());
            tableAuthDto.setTableCode(table.getTableCode());
            tableAuthDto.setTableDescription(table.getDescription());
            resultList.add(tableAuthDto);
        }
        PageList result = new PageList();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    public PageList<ApiAuthDto> queryApiAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId) {
        IPage<BizShareAuth> iPage = ((BizShareAuthDao)this.baseMapper).queryApiAuth((IPage<BizShareAuth>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()), consumerId);
        PageList pageList = new PageList(iPage);
        ArrayList<ApiAuthDto> resultList = new ArrayList<ApiAuthDto>();
        List rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            ApiAuthDto apiAuthDto = new ApiAuthDto();
            BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)auth.getTableId()));
            BizShareApi api = (BizShareApi)this.apiManager.get((Serializable)((Object)auth.getResourceId()));
            apiAuthDto.setAuthId(auth.getId());
            apiAuthDto.setTableId(table.getId());
            apiAuthDto.setTableName(table.getName());
            apiAuthDto.setTableCode(table.getTableCode());
            apiAuthDto.setTableDescription(table.getDescription());
            apiAuthDto.setApiName(api.getApiName());
            apiAuthDto.setApiUrl(api.getApiUrl());
            apiAuthDto.setApiMode(api.getApiMode());
            resultList.add(apiAuthDto);
        }
        PageList result = new PageList();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }

    @Override
    public PageList<FilesAuthDto> queryFilesAuth(QueryFilter<BizShareAuth> queryFilter, String consumerId) {
        IPage<BizShareAuth> iPage = ((BizShareAuthDao)this.baseMapper).queryFilesAuth((IPage<BizShareAuth>)this.convert2IPage(queryFilter.getPageBean()), (Wrapper<BizShareAuth>)this.convert2Wrapper(queryFilter, this.currentModelClass()), consumerId);
        PageList pageList = new PageList(iPage);
        ArrayList<FilesAuthDto> resultList = new ArrayList<FilesAuthDto>();
        List rows = pageList.getRows();
        for (BizShareAuth auth : rows) {
            FilesAuthDto filesAuthDto = new FilesAuthDto();
            BizShareTable table = (BizShareTable)this.tableManager.get((Serializable)((Object)auth.getTableId()));
            BizShareFiles files = (BizShareFiles)this.filesManager.get((Serializable)((Object)auth.getResourceId()));
            filesAuthDto.setAuthId(auth.getId());
            filesAuthDto.setTableId(table.getId());
            filesAuthDto.setTableName(table.getName());
            filesAuthDto.setTableCode(table.getTableCode());
            filesAuthDto.setTableDescription(table.getDescription());
            filesAuthDto.setFileName(files.getFileName());
            filesAuthDto.setFileContent(files.getFileContent());
            resultList.add(filesAuthDto);
        }
        PageList result = new PageList();
        result.setPage(pageList.getPage());
        result.setPageSize(pageList.getPageSize());
        result.setTotal(pageList.getTotal());
        result.setRows(resultList);
        return result;
    }
}

