/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.dataShare.dataResource.app.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.dataShare.dataResource.app.dao.BizAppCatalogsDao;
import com.artfess.dataShare.dataResource.app.manager.BizAppCatalogsManager;
import com.artfess.dataShare.dataResource.app.model.BizAppCatalogs;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class BizAppCatalogsManagerImpl
extends BaseManagerImpl<BizAppCatalogsDao, BizAppCatalogs>
implements BizAppCatalogsManager {
    @Override
    public List<BizAppCatalogs> getTree(BizAppCatalogs entity) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)entity.getCode())) {
            queryWrapper.like((Object)"code_", (Object)entity.getCode());
        }
        if (StringUtils.isNotBlank((CharSequence)entity.getName())) {
            queryWrapper.like((Object)"name_", (Object)entity.getName());
        }
        queryWrapper.orderByAsc((Object)"sn_");
        List sysList = ((BizAppCatalogsDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        List tree = BeanUtils.listToTree((List)sysList);
        return tree;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> moveTree(String id, String parentId) throws Exception {
        Assert.hasText((String)id, (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)parentId, (String)"treeId\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtil.isEmpty((String)id) || StringUtil.isEmpty((String)parentId)) {
            throw new RequiredException("\u79fb\u52a8\u8282\u70b9\u6216\u76ee\u6807\u8282\u70b9id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BizAppCatalogs rel = (BizAppCatalogs)this.get((Serializable)((Object)id));
        if (BeanUtils.isEmpty((Object)((Object)rel))) {
            throw new RequiredException("\u6839\u636e\u79fb\u52a8\u8282\u70b9id\u3010" + id + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u8282\u70b9\uff01");
        }
        if (parentId.equals(rel.getParentId())) {
            return new CommonResult(true, "\u8282\u70b9\u3010" + rel.getName() + "\u3011\u5df2\u7ecf\u662f\u5176\u5b50\u8282\u70b9\uff0c\u4e0d\u9700\u8981\u66f4\u65b0\uff01", (Object)"");
        }
        BizAppCatalogs parentRel = (BizAppCatalogs)this.get((Serializable)((Object)parentId));
        List<BizAppCatalogs> childrens = this.getByParentId(parentRel.getId());
        for (BizAppCatalogs userRel : childrens) {
            if (userRel.getId().equals(rel.getId()) || !userRel.getCode().equals(rel.getCode()) || !userRel.getName().equals(rel.getName())) continue;
            throw new RequiredException("\u8282\u70b9\u3010" + parentRel.getName() + "\u3011\u4e0b\u5df2\u5b58\u5728\u8282\u70b9\u3010" + rel.getName() + "\u3011\uff0c\u4e0d\u80fd\u6dfb\u52a0\u591a\u4e2a!");
        }
        if (BeanUtils.isEmpty((Object)((Object)parentRel))) {
            throw new RequiredException("\u6839\u636e\u76ee\u6807\u8282\u70b9id\u3010" + parentId + "\u3011\u672a\u627e\u5230\u5bf9\u5e94\u8282\u70b9\uff01");
        }
        rel.setFullId(parentRel.getFullId() + "/" + rel.getId());
        rel.setParentId(parentId);
        this.update((Model)rel);
        this.updateChildrenRel(rel);
        return new CommonResult(true, "\u66f4\u65b0\u76ee\u5f55\u7ebf\u6210\u529f\uff01", (Object)"");
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateChildrenRel(BizAppCatalogs parentRel) throws Exception {
        List<BizAppCatalogs> childrens = this.getByParentId(parentRel.getId());
        for (BizAppCatalogs rel : childrens) {
            rel.setFullId(parentRel.getFullId() + "/" + rel.getId());
            this.update((Model)rel);
            this.updateChildrenRel(rel);
        }
    }

    public List<BizAppCatalogs> getByParentId(String parentId) throws Exception {
        if (StringUtil.isEmpty((String)parentId)) {
            throw new RequiredException("\u7236\u8282\u70b9id\u201cparentId\u201d\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"parent_id_", (Object)parentId);
        return this.list((Wrapper)queryWrapper);
    }
}

