/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.bpm.engine.task.handler;

import com.artfess.base.model.HtJsonNodeFactory;
import com.artfess.base.model.HtObjectNode;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.api.constant.ActionType;
import com.artfess.bpm.api.context.BpmContextUtil;
import com.artfess.bpm.api.context.ContextThreadUtil;
import com.artfess.bpm.api.model.identity.BpmIdentity;
import com.artfess.bpm.api.model.process.inst.BpmProcessInstance;
import com.artfess.bpm.api.model.process.nodedef.BpmNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.SignNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.UserTaskNodeDef;
import com.artfess.bpm.api.model.process.nodedef.ext.extmodel.DefaultJumpRule;
import com.artfess.bpm.api.model.process.task.BpmTask;
import com.artfess.bpm.api.plugin.core.def.TaskActionHandlerDef;
import com.artfess.bpm.api.plugin.core.session.TaskActionPluginSession;
import com.artfess.bpm.api.service.BoDataService;
import com.artfess.bpm.api.service.BpmDefinitionAccessor;
import com.artfess.bpm.api.service.BpmDefinitionService;
import com.artfess.bpm.api.service.BpmInstService;
import com.artfess.bpm.api.service.BpmTaskActionService;
import com.artfess.bpm.api.service.JumpRuleCalc;
import com.artfess.bpm.engine.task.cmd.DefaultTaskFinishCmd;
import com.artfess.bpm.engine.task.handler.AbstractTaskActionHandler;
import com.artfess.bpm.natapi.inst.NatProInstanceService;
import com.artfess.bpm.natapi.task.NatTaskService;
import com.artfess.bpm.persistence.dao.ActExecutionDao;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.manager.BpmExeStackExecutorManager;
import com.artfess.bpm.persistence.manager.BpmExeStackManager;
import com.artfess.bpm.persistence.manager.BpmSignDataManager;
import com.artfess.bpm.persistence.model.BpmExeStack;
import com.artfess.bpm.util.BpmUtil;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Resource;

public class TaskActionApproveHandler
extends AbstractTaskActionHandler {
    @Resource
    NatTaskService natTaskService;
    @Resource
    JumpRuleCalc jumpRuleCalc;
    @Resource
    BpmDefinitionManager bpmDefinitionManager;
    @Resource
    BpmDefinitionAccessor bpmDefinitionAccessor;
    @Resource
    BpmTaskActionService bpmTaskActionService;
    @Resource
    BpmDefinitionService bpmDefinitionService;
    @Resource
    BpmExeStackManager bpmExeStackManager;
    @Resource
    NatProInstanceService natProInstanceService;
    @Resource
    BpmSignDataManager bpmSignDataManager;
    @Resource
    BpmExeStackExecutorManager bpmExeStackExecutorManager;
    @Resource
    ActExecutionDao actExecutionDao;
    @Resource
    BoDataService boDataService;
    @Resource
    BpmInstService bpmInstService;

    @Override
    public boolean isNeedCompleteTask() {
        return true;
    }

    @Override
    public void preActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        this.setDestination(pluginSession);
        this.signVote(pluginSession);
    }

    private void signVote(TaskActionPluginSession pluginSession) throws Exception {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        String defId = bpmTask.getProcDefId();
        BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(defId, bpmTask.getNodeId());
        if (bpmNodeDef instanceof SignNodeDef) {
            Short index = ((Integer)this.natTaskService.getVariable(bpmTask.getTaskId(), "loopCounter")).shortValue();
            String executeId = bpmTask.getExecId();
            this.bpmSignDataManager.vote(executeId, bpmTask.getNodeId(), index, cmd.getActionName());
        }
    }

    private void setDestination(TaskActionPluginSession pluginSession) throws Exception {
        DefaultTaskFinishCmd cmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        if (StringUtil.isNotEmpty((String)cmd.getDestination())) {
            return;
        }
        String instId = cmd.getInstId();
        BpmTask bpmTask = (BpmTask)cmd.getTransitVars("bpmTask_");
        String nodeId = bpmTask.getNodeId();
        Object tokenObject = this.natProInstanceService.getVariableLocal(bpmTask.getExecId(), "token_");
        String token = tokenObject != null ? tokenObject.toString() : null;
        String targetNode = "";
        String targetToken = "";
        BpmExeStack bpmExeStack = this.bpmExeStackManager.getStack(instId, nodeId, token);
        if (bpmExeStack == null) {
            bpmExeStack = this.bpmExeStackManager.getStack(instId, nodeId, null);
        }
        if (bpmExeStack != null) {
            targetNode = bpmExeStack.getTargetNode();
            targetToken = bpmExeStack.getTargetToken();
            if (StringUtil.isNotEmpty((String)targetNode)) {
                cmd.setDestination(targetNode);
                BpmNodeDef bpmNodeDef = this.bpmDefinitionAccessor.getBpmNodeDef(bpmTask.getProcDefId(), targetNode);
                if (bpmNodeDef instanceof SignNodeDef) {
                    List<BpmIdentity> signBpmIdentity = this.bpmSignDataManager.getByInstanIdAndNodeIdAndNo(instId, targetNode);
                    cmd.addBpmIdentity(targetNode, signBpmIdentity);
                    return;
                }
                BpmExeStack targetStack = this.bpmExeStackManager.getStack(instId, targetNode, targetToken);
                if (targetStack != null) {
                    cmd.addBpmIdentity(targetNode, this.bpmExeStackExecutorManager.getBpmIdentitysByStackId(targetStack.getId()));
                    return;
                }
            }
        }
        this.calcJumpRules(bpmTask, cmd);
    }

    private void calcJumpRules(BpmTask bpmTask, DefaultTaskFinishCmd cmd) throws Exception {
        String nodeId = bpmTask.getNodeId();
        String defId = bpmTask.getProcDefId();
        UserTaskNodeDef bpmNodeDef = (UserTaskNodeDef)this.bpmDefinitionAccessor.getBpmNodeDef(defId, nodeId);
        List<DefaultJumpRule> ruleList = bpmNodeDef.getJumpRuleList();
        if (BeanUtils.isEmpty(ruleList)) {
            return;
        }
        Map<String, Object> vars = this.natTaskService.getVariables(bpmTask.getTaskId());
        Map<String, ObjectNode> boMap = BpmContextUtil.getBoFromContext();
        if (BeanUtils.isEmpty(boMap)) {
            BpmProcessInstance bpmProcessInstance = this.bpmInstService.getProcessInstance(bpmTask.getProcInstId());
            List<ObjectNode> boDatas = this.boDataService.getDataByInst(bpmProcessInstance);
            BpmContextUtil.setBoToContext(boDatas);
            boMap = BpmContextUtil.getBoFromContext();
        }
        if (BeanUtils.isNotEmpty(boMap)) {
            HashMap<String, HtObjectNode> newMap = new HashMap<String, HtObjectNode>();
            for (Map.Entry<String, ObjectNode> next : boMap.entrySet()) {
                ObjectNode obj = next.getValue();
                if (obj.hasNonNull("data") && obj.get("data") instanceof ObjectNode) {
                    obj = (ObjectNode)obj.get("data");
                }
                HtObjectNode htObjectNode = HtJsonNodeFactory.build().htObjectNode(obj);
                newMap.put(next.getKey(), htObjectNode);
                vars.put(next.getKey(), htObjectNode);
            }
            vars.putAll(newMap);
        }
        vars.putAll(cmd.getVariables());
        String targetNode = this.jumpRuleCalc.eval(ruleList, vars);
        if (StringUtil.isNotEmpty((String)targetNode)) {
            cmd.setDestination(targetNode);
        }
    }

    @Override
    public void afterActionHandler(TaskActionPluginSession pluginSession, TaskActionHandlerDef def) throws Exception {
        DefaultTaskFinishCmd finishCmd = (DefaultTaskFinishCmd)pluginSession.getTaskFinishCmd();
        String instId = finishCmd.getInstId();
        BpmTask bpmTask = (BpmTask)finishCmd.getTransitVars("bpmTask_");
        String nodeId = BeanUtils.isEmpty((Object)bpmTask) ? "" : bpmTask.getNodeId();
        this.handSkipTask(instId, nodeId);
    }

    private void handSkipTask(String instId, String curentNodeId) throws Exception {
        Set<BpmTask> set = ContextThreadUtil.getByInstId(instId);
        if (BeanUtils.isEmpty(set)) {
            instId = (String)ContextThreadUtil.getCommuVar("instanceId_", instId);
            set = ContextThreadUtil.getByInstId(instId);
        }
        ContextThreadUtil.clearTaskByInstId(instId);
        if (BeanUtils.isEmpty(set)) {
            return;
        }
        for (BpmTask task : set) {
            if (task.isGateWay()) continue;
            BpmUtil.setTaskSkip(task);
            if (!task.getSkipResult().isSkipTask() || task.getNodeId().equals(curentNodeId)) continue;
            BpmUtil.finishTask(task);
        }
    }

    @Override
    public ActionType getActionType() {
        return ActionType.APPROVE;
    }
}

