/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.table.conf;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.table.factory.DatabaseFactory;
import com.artfess.table.meta.impl.BaseTableMeta;
import com.artfess.table.operator.IIndexOperator;
import com.artfess.table.operator.ITableOperator;
import com.artfess.table.operator.IViewOperator;
import javax.annotation.Resource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class DatabaseFactoryConfig {
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    DatabaseContext databaseContext;

    @Bean
    public ITableOperator initTableOperator() throws Exception {
        ITableOperator tableOperator = DatabaseFactory.getTableOperator(this.databaseContext.getDbType());
        tableOperator.setJdbcTemplate(this.jdbcTemplate);
        return tableOperator;
    }

    @Bean
    public BaseTableMeta initBaseTableMeta() throws Exception {
        BaseTableMeta tableMetaByDbType = DatabaseFactory.getTableMetaByDbType(this.databaseContext.getDbType());
        tableMetaByDbType.setJdbcTemplate(this.jdbcTemplate);
        return tableMetaByDbType;
    }

    @Bean
    public IIndexOperator initIIndexOperator() throws Exception {
        IIndexOperator indexOperator = DatabaseFactory.getIndexOperator(this.databaseContext.getDbType());
        indexOperator.setJdbcTemplate(this.jdbcTemplate);
        return indexOperator;
    }

    @Bean
    public IViewOperator initIViewOperator() throws Exception {
        IViewOperator viewOperator = DatabaseFactory.getViewOperator(this.databaseContext.getDbType());
        viewOperator.setJdbcTemplate(this.jdbcTemplate);
        return viewOperator;
    }
}

