/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.interceptor;

import com.alibaba.druid.pool.DruidPooledResultSet;
import com.alibaba.druid.pool.DruidPooledStatement;
import com.alibaba.druid.proxy.jdbc.NClobProxyImpl;
import com.alibaba.druid.proxy.jdbc.PreparedStatementProxyImpl;
import dm.jdbc.desc.Column;
import dm.jdbc.driver.DmdbNClob;
import dm.jdbc.driver.DmdbPreparedStatement;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.ibatis.plugin.Invocation;

public class MapIntercept {
    public static Object interceptMap(Invocation invocation) throws Throwable {
        ArrayList resultList;
        Object result = invocation.proceed();
        if (result != null && result instanceof ArrayList && (resultList = (ArrayList)result).size() != 0 && resultList.get(0) instanceof Map) {
            return MapIntercept.handelResultMap(resultList, MapIntercept.getColumns(invocation));
        }
        return result;
    }

    private static Object handelResultMap(ArrayList resultList, Column[] columns) {
        Map<String, String> columnsToMap = MapIntercept.columnsToMap(columns);
        ArrayList res = new ArrayList();
        for (int i = 0; i < resultList.size(); ++i) {
            Map oldMap = (Map)resultList.get(i);
            HashMap newMap = new HashMap(oldMap.size());
            for (Map.Entry entry : oldMap.entrySet()) {
                Object value = entry.getValue();
                if (value instanceof NClobProxyImpl) {
                    NClobProxyImpl nClobProxy = (NClobProxyImpl)value;
                    DmdbNClob rawClob = (DmdbNClob)nClobProxy.getRawClob();
                    value = rawClob.data;
                }
                if (columnsToMap.get(entry.getKey()) == null) {
                    newMap.put(entry.getKey(), value);
                    continue;
                }
                newMap.put(columnsToMap.get(entry.getKey()), value);
            }
            res.add(newMap);
        }
        return res;
    }

    public static Map<String, String> columnsToMap(Column[] columns) {
        if (columns == null || columns.length == 0) {
            throw new RuntimeException("Mybatis\u62e6\u622a\u5668\u672a\u83b7\u53d6\u5230\u539fSQL\u4e2d\u7684\u5217\u540d");
        }
        HashMap<String, String> columnsToMap1 = new HashMap<String, String>(8);
        for (Column column : columns) {
            String name = column.name;
            if ("LABEL".equals(name)) {
                columnsToMap1.put(name.toUpperCase(), "label");
                continue;
            }
            columnsToMap1.put(name.toUpperCase(), column.name);
        }
        return columnsToMap1;
    }

    public static Column[] getColumns(Invocation invocation) throws SQLException {
        PreparedStatement statement = (PreparedStatement)invocation.getArgs()[0];
        DruidPooledResultSet generatedKeys = (DruidPooledResultSet)statement.getGeneratedKeys();
        DruidPooledStatement poolableStatement = generatedKeys.getPoolableStatement();
        PreparedStatementProxyImpl statement1 = (PreparedStatementProxyImpl)poolableStatement.getStatement();
        DmdbPreparedStatement rawObject = (DmdbPreparedStatement)statement1.getRawObject();
        return rawObject.columns;
    }
}

