/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.thread;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableAsync;

@Configuration
@EnableAsync(proxyTargetClass=true)
public class DefaultAsycTaskConfig {
    @Value(value="${asyc-task.corePoolSize:10}")
    private int corePoolSize;
    @Value(value="${asyc-task.maxPoolSize:20}")
    private int maxPoolSize;
    @Value(value="${asys-task.keepAliveTime:10}")
    private long keepAliveTime;
    @Value(value="${asyc-task.queueCapacity:1000}")
    private int queueCapacity;
    @Value(value="${asyc-task.threadNamePrefix:dmpExecutor-}")
    private String threadNamePrefix;
    private static final AtomicLong COUNTER = new AtomicLong();

    @Bean(name={"bmpExecutorService"})
    public ExecutorService bmpExecutorService() {
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(this.threadNamePrefix + "%d").build();
        ThreadPoolExecutor executor = new ThreadPoolExecutor(this.corePoolSize, this.maxPoolSize, this.keepAliveTime, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(this.queueCapacity), threadFactory, new ThreadPoolExecutor.CallerRunsPolicy());
        return executor;
    }

    @Bean(name={"bmpSchedualedExecutorService"})
    public ScheduledExecutorService bmpSchedualedExecutorService() {
        ScheduledThreadPoolExecutor scheduledExecutorService = new ScheduledThreadPoolExecutor(this.corePoolSize, r -> new Thread(r, "common-scheduled-thread" + COUNTER.getAndIncrement()), new ThreadPoolExecutor.CallerRunsPolicy());
        return scheduledExecutorService;
    }

    public void setCorePoolSize(int corePoolSize) {
        this.corePoolSize = corePoolSize;
    }

    public void setMaxPoolSize(int maxPoolSize) {
        this.maxPoolSize = maxPoolSize;
    }

    public void setKeepAliveTime(long keepAliveTime) {
        this.keepAliveTime = keepAliveTime;
    }

    public void setQueueCapacity(int queueCapacity) {
        this.queueCapacity = queueCapacity;
    }

    public void setThreadNamePrefix(String threadNamePrefix) {
        this.threadNamePrefix = threadNamePrefix;
    }

    public int getCorePoolSize() {
        return this.corePoolSize;
    }

    public int getMaxPoolSize() {
        return this.maxPoolSize;
    }

    public long getKeepAliveTime() {
        return this.keepAliveTime;
    }

    public int getQueueCapacity() {
        return this.queueCapacity;
    }

    public String getThreadNamePrefix() {
        return this.threadNamePrefix;
    }
}

