/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.application.controller;

import com.artfess.application.model.RemindConfig;
import com.artfess.application.persistence.manager.RemindConfigManager;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.valid.AddGroup;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/remindConfig/v1"})
@Api(tags={"\u5de5\u4f5c\u63d0\u9192"})
@ApiGroup(group={"group_application"})
public class RemindConfigController
extends BaseController<RemindConfigManager, RemindConfig> {
    private static final Logger log = LoggerFactory.getLogger(RemindConfigController.class);

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<RemindConfig> query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<RemindConfig> queryFilter) {
        return ((RemindConfigManager)this.baseService).findByPage(queryFilter);
    }

    @RequestMapping(value={"validClass"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u9a8c\u8bc1\u7c7b", httpMethod="GET", notes="\u9a8c\u8bc1\u7c7b")
    public CommonResult validClass(@ApiParam(name="className", value="\u7c7b\u540d", required=true) @RequestParam String className) throws Exception {
        boolean rtn = BeanUtils.validClass((String)className);
        if (rtn) {
            return new CommonResult(true, "\u9a8c\u8bc1\u7c7b\u6210\u529f!", null);
        }
        return new CommonResult(false, "\u9a8c\u8bc1\u7c7b\u5931\u8d25!", null);
    }

    @PostMapping(value={"/saveOrUpdate"})
    @ApiOperation(value="\u6dfb\u52a0\u6216\u6570\u636e\u62bd\u53d6\u63d0\u9192")
    public CommonResult<String> saveOrUpdate(@ApiParam(name="model", value="\u6570\u636e\u62bd\u53d6\u63d0\u9192") @Validated(value={AddGroup.class}) @RequestBody RemindConfig remindConfig) throws Exception {
        boolean rtn = BeanUtils.validClass((String)remindConfig.getPlanClass());
        if (rtn) {
            boolean result = ((RemindConfigManager)this.baseService).saveOrUpdateInfo(remindConfig);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u64cd\u4f5c\u5931\u8d25!");
            }
        } else {
            return new CommonResult(false, "\u64cd\u4f5c\u5931\u8d25!", null);
        }
        return new CommonResult();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        try {
            boolean result = false;
            result = ((RemindConfigManager)this.baseService).deleteRemindConfigById(id);
            if (!result) {
                return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
            }
            return new CommonResult("\u5220\u9664\u6210\u529f\uff01");
        }
        catch (Exception e) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)e.getMessage());
        }
    }

    @PostMapping(value={"/toggleTriggerRun"})
    @ApiOperation(value="\u542f\u7528\u6216\u505c\u6b62\u5de5\u4f5c\u63d0\u9192", httpMethod="POST", notes="\u542f\u7528\u6216\u505c\u6b62\u5de5\u4f5c\u63d0\u9192")
    public CommonResult<String> start(@ApiParam(name="id", value="\u63d0\u9192id", required=false) @RequestParam String id) throws Exception {
        boolean result = ((RemindConfigManager)this.baseService).toggleTriggerRun(id);
        if (result) {
            return new CommonResult("\u64cd\u4f5c\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u64cd\u4f5c\u5931\u8d25\uff01");
    }

    @PostMapping(value={"/executeJob"})
    @ApiOperation(value="\u6267\u884c\u5de5\u4f5c\u63d0\u9192", httpMethod="POST", notes="\u6267\u884c\u5de5\u4f5c\u63d0\u9192")
    public CommonResult<String> executeJob(@ApiParam(name="id", value="\u63d0\u9192id", required=true) @RequestParam String id) throws SchedulerException {
        boolean result = ((RemindConfigManager)this.baseService).executeJob(id);
        if (result) {
            return new CommonResult("\u6267\u884c\u5de5\u4f5c\u63d0\u9192\u6210\u529f\uff01");
        }
        return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u6267\u884c\u5de5\u4f5c\u63d0\u9192\u5931\u8d25\uff01");
    }

    @GetMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u67e5\u8be2\u5b9e\u4f53")
    public RemindConfig getById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        return ((RemindConfigManager)this.baseService).findById(id);
    }
}

