/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.model.dao.ModelTaskDao;
import com.artfess.cssc.model.manager.ModelActuatorManager;
import com.artfess.cssc.model.manager.ModelInfoManager;
import com.artfess.cssc.model.manager.ModelTaskManager;
import com.artfess.cssc.model.model.ModelActuator;
import com.artfess.cssc.model.model.ModelInfo;
import com.artfess.cssc.model.model.ModelTask;
import com.artfess.cssc.util.HttpUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ModelTaskManagerImpl
extends BaseManagerImpl<ModelTaskDao, ModelTask>
implements ModelTaskManager {
    @Resource
    ModelActuatorManager modelActuatorManager;
    @Resource
    ModelInfoManager modelInfoManager;

    @Override
    public PageList<ModelTask> sliceQueryModelTask(QueryFilter<ModelTask> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<ModelTask> result = ((ModelTaskDao)this.baseMapper).sliceQueryModelTask((IPage<ModelTask>)this.convert2IPage(pageBean), (Wrapper<ModelTask>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public boolean insertModelTask(ModelTask modelTask) {
        if (BeanUtils.isNotEmpty((Object)((Object)modelTask))) {
            if (StringUtil.isEmpty((String)modelTask.getModelId())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6a21\u578b\uff01");
            }
            if (StringUtil.isEmpty((String)modelTask.getTaskName())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u4efb\u52a1\u540d\u79f0\uff01");
            }
            if (StringUtil.isEmpty((String)modelTask.getTaskActuator())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6267\u884c\u5668\uff01");
            }
            if (modelTask.getTaskRate() == null || modelTask.getTaskRate() <= 0 || StringUtil.isEmpty((String)modelTask.getTaskRateUnit())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u6267\u884c\u9891\u7387\uff01");
            }
            if (this.checkSameCode(modelTask.getModelId(), modelTask.getTaskName(), modelTask.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8be5\u6a21\u578b\u4efb\u52a1\u3010" + modelTask.getTaskName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            modelTask.setTaskStatus("NONE");
            Integer result = ((ModelTaskDao)this.baseMapper).insert((Object)modelTask);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateModelTask(ModelTask modelTask) {
        if (BeanUtils.isNotEmpty((Object)((Object)modelTask))) {
            ModelTask oldModelTask = (ModelTask)((Object)((ModelTaskDao)this.baseMapper).selectById((Serializable)((Object)modelTask.getId())));
            if (oldModelTask.getTaskStatus().equals("NORMAL")) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u505c\u6b62\u6a21\u578b\uff01");
            }
            if (StringUtil.isEmpty((String)modelTask.getModelId())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6a21\u578b\uff01");
            }
            if (StringUtil.isEmpty((String)modelTask.getTaskName())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u4efb\u52a1\u540d\u79f0\uff01");
            }
            if (StringUtil.isEmpty((String)modelTask.getTaskActuator())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u6267\u884c\u5668\uff01");
            }
            if (modelTask.getTaskRate() == null || modelTask.getTaskRate() <= 0 || StringUtil.isEmpty((String)modelTask.getTaskRateUnit())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u586b\u5199\u6267\u884c\u9891\u7387\uff01");
            }
            if (this.checkSameCode(modelTask.getModelId(), modelTask.getTaskName(), modelTask.getId())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8be5\u6a21\u578b\u4efb\u52a1\u3010" + modelTask.getTaskName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            CommonResult<String> commonResult = this.remoteCommand(modelTask.getId(), "del");
            if (!commonResult.getState().booleanValue()) {
                return false;
            }
            Integer result = ((ModelTaskDao)this.baseMapper).updateById((Object)modelTask);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean deleteModelTaskById(String id) {
        if (StringUtil.isEmpty((String)id)) {
            throw new RequiredException("\u5220\u9664\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u4efb\u52a1\uff01");
        }
        ModelTask oldModelTask = (ModelTask)((Object)((ModelTaskDao)this.baseMapper).selectById((Serializable)((Object)id)));
        if (oldModelTask.getTaskStatus().equals("NORMAL")) {
            throw new RequiredException("\u5220\u9664\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u8bf7\u505c\u6b62\u6a21\u578b\uff01");
        }
        CommonResult<String> commonResult = this.remoteCommand(id, "del");
        if (!commonResult.getState().booleanValue()) {
            return false;
        }
        Integer result = ((ModelTaskDao)this.baseMapper).deleteById((Serializable)((Object)id));
        return null != result && result >= 1;
    }

    @Override
    @Transactional
    public boolean deleteModelTaskByModelId(String modelId) {
        if (StringUtil.isEmpty((String)modelId)) {
            throw new RequiredException("\u5220\u9664\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"model_id_", (Object)modelId);
        queryWrapper.eq((Object)"task_status_", (Object)"NORMAL");
        int count = ((ModelTaskDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        if (count == 0) {
            queryWrapper.clear();
            queryWrapper.eq((Object)"model_id_", (Object)modelId);
            List list = ((ModelTaskDao)this.baseMapper).selectList((Wrapper)queryWrapper);
            for (ModelTask modelTask : list) {
                CommonResult<String> result = this.remoteCommand(modelTask.getId(), "del");
                if (result.getState().booleanValue()) continue;
                throw new RequiredException("\u5220\u9664\u6a21\u578b\u4efb\u52a1\u5931\u8d25:" + result.getMessage());
            }
            Integer result = ((ModelTaskDao)this.baseMapper).delete((Wrapper)queryWrapper);
            return null != result && result >= 1;
        }
        throw new RequiredException("\u5220\u9664\u6a21\u578b\u4efb\u52a1\u5931\u8d25\uff0c\u6709\u4efb\u52a1\u6b63\u5728\u8fd0\u884c\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
    }

    @Override
    public CommonResult<String> remoteCommand(String id, String command) {
        if (StringUtil.isEmpty((String)id)) {
            return new CommonResult(false, "\u8bf7\u9009\u62e9\u8981\u542f\u52a8\u7684\u4efb\u52a1\uff01");
        }
        if (StringUtil.isEmpty((String)command)) {
            return new CommonResult(false, "\u8bf7\u8f93\u5165\u547d\u4ee4\uff01");
        }
        String uri = "";
        if (command.equals("startUp")) {
            uri = "/biz/model/modelTask/v1/startUpJob";
        } else if (command.equals("stop")) {
            uri = "/biz/model/modelTask/v1/stopJob";
        } else if (command.equals("del")) {
            uri = "/biz/model/modelTask/v1/delJob";
        } else {
            return new CommonResult(false, "\u65e0\u6cd5\u8bc6\u522b\u8fd9\u9879\u64cd\u4f5c\uff01");
        }
        ModelTask modelTask = (ModelTask)((Object)((ModelTaskDao)this.baseMapper).selectById((Serializable)((Object)id)));
        ModelInfo modelInfo = (ModelInfo)((Object)this.modelInfoManager.getById((Serializable)((Object)modelTask.getModelId())));
        String taskActuator = modelTask.getTaskActuator();
        ModelActuator modelActuator = (ModelActuator)((Object)this.modelActuatorManager.getById((Serializable)((Object)taskActuator)));
        if (BeanUtils.isNotEmpty((Object)((Object)modelActuator))) {
            if (modelActuator.getActuatorStatus().equals("NORMAL")) {
                String ip = modelActuator.getActuatorIp();
                int port = modelActuator.getActuatorPort();
                uri = "http://" + ip + ":" + port + uri;
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("taskId", id);
                params.put("modelId", modelTask.getModelId());
                params.put("modelCode", modelInfo.getModelCode());
                String result = HttpUtil.doPost(uri, params);
                return new CommonResult(true, result);
            }
            return new CommonResult(false, "\u6267\u884c\u5668\u4e0d\u5728\u7ebf\uff01");
        }
        return new CommonResult(true, "\u6ca1\u6709\u627e\u5230\u6267\u884c\uff01");
    }

    private boolean checkSameCode(String modelId, String taskName, String id) {
        Assert.hasText((String)modelId, (String)"\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.hasText((String)taskName, (String)"\u4efb\u52a1\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"model_id_", (Object)modelId);
        queryWrapper.eq((Object)"task_name_", (Object)taskName);
        queryWrapper.ne(StringUtil.isNotEmpty((String)id), (Object)"ID_", (Object)id);
        int num = ((ModelTaskDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

