/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.jkjc.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.cssc.jkjc.manager.JkjcHealthManager;
import com.artfess.cssc.jkjc.model.JkjcHealth;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/jkjc/health/v1/"})
@Api(tags={"\u5065\u5eb7\u76d1\u6d4b-\u5065\u5eb7\u72b6\u6001"})
@ApiGroup(group={"group_biz"})
public class JkjcHealthController
extends BaseController<JkjcHealthManager, JkjcHealth> {
    @RequestMapping(value={"/getJsonHealth"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5065\u5eb7\u76d1\u6d4b-\u8be5\u98ce\u573a\u5404\u79cd\u5065\u5eb7\u72b6\u6001\u7684\u53f0\u6570", httpMethod="GET", notes="\u5065\u5eb7\u76d1\u6d4b-\u8be5\u98ce\u573a\u5404\u79cd\u5065\u5eb7\u72b6\u6001\u7684\u53f0\u6570")
    public CommonResult<Map<String, Object>> getJsonHealth(@ApiParam(name="time", value="yyyy-MM-dd", required=true) @RequestParam String time) throws Exception {
        LocalDate localDate = LocalDate.parse(time, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        Map<String, Object> resultMap = ((JkjcHealthManager)this.baseService).getJsonHealth(localDate);
        return new CommonResult(true, "", resultMap);
    }

    @RequestMapping(value={"/getJsonRemoteOverview"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5065\u5eb7\u76d1\u6d4b-\u603b\u89c8", httpMethod="GET", notes="\u5065\u5eb7\u76d1\u6d4b-\u603b\u89c8")
    public CommonResult<Map<String, Object>> getJsonRemoteOverview() throws Exception {
        Map<String, Object> resultMap = ((JkjcHealthManager)this.baseService).getJsonRemoteOverview();
        return new CommonResult(true, "", resultMap);
    }
}

