/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.base.dao.WindFactoryDao;
import com.artfess.cssc.base.manager.WfLineManager;
import com.artfess.cssc.base.manager.WindFactoryManager;
import com.artfess.cssc.base.model.WfLine;
import com.artfess.cssc.base.model.WindFactory;
import java.io.Serializable;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class WindFactoryManagerImpl
extends BaseManagerImpl<WindFactoryDao, WindFactory>
implements WindFactoryManager {
    @Resource
    WfLineManager wfLineManager;

    @Override
    @Transactional
    public boolean insertWindFactory(WindFactory windFactory) {
        if (BeanUtils.isNotEmpty((Object)((Object)windFactory))) {
            WindFactory win;
            if (StringUtil.isEmpty((String)windFactory.getWfName())) {
                throw new RequiredException("\u6dfb\u52a0\u98ce\u573a\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u98ce\u573a\u540d\u79f0\u5fc5\u586b\uff01");
            }
            if (windFactory.getCapacity() == null || windFactory.getCapacity().floatValue() == 0.0f) {
                throw new RequiredException("\u6dfb\u52a0\u98ce\u573a\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u98ce\u573a\u5bb9\u91cf\u5fc5\u586b\uff01");
            }
            if (windFactory.getSetsNo() == null || windFactory.getSetsNo() == 0) {
                throw new RequiredException("\u6dfb\u52a0\u98ce\u573a\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u98ce\u573a\u673a\u7ec4\u6570\u91cf\u5fc5\u586b\uff01");
            }
            if (windFactory.getLineNo() == null || windFactory.getLineNo() == 0) {
                throw new RequiredException("\u6dfb\u52a0\u98ce\u573a\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u98ce\u573a\u673a\u7ec4\u73af\u7ebf\u6570\u91cf\u5fc5\u586b\uff01");
            }
            if (StringUtil.isNotEmpty((String)windFactory.getId()) && BeanUtils.isNotEmpty((Object)((Object)(win = (WindFactory)((Object)((WindFactoryDao)this.baseMapper).selectById((Serializable)((Object)windFactory.getId()))))))) {
                return this.updateWindFactory(windFactory);
            }
            Integer result = ((WindFactoryDao)this.baseMapper).insert((Object)windFactory);
            if (null != result && result >= 1) {
                for (int i = 1; i <= windFactory.getLineNo(); ++i) {
                    WfLine line = new WfLine();
                    line.setLineName("#" + i);
                    line.setLineCode(String.valueOf(i));
                    this.wfLineManager.insertWfLine(line);
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateWindFactory(WindFactory windFactory) {
        if (BeanUtils.isNotEmpty((Object)((Object)windFactory))) {
            if (StringUtil.isEmpty((String)windFactory.getWfName())) {
                throw new RequiredException("\u66f4\u65b0\u98ce\u573a\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u98ce\u573a\u540d\u79f0\u5fc5\u586b\uff01");
            }
            if (windFactory.getCapacity() == null || windFactory.getCapacity().floatValue() == 0.0f) {
                throw new RequiredException("\u66f4\u65b0\u98ce\u573a\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u98ce\u573a\u5bb9\u91cf\u5fc5\u586b\uff01");
            }
            if (windFactory.getSetsNo() == null || windFactory.getSetsNo() == 0) {
                throw new RequiredException("\u66f4\u65b0\u98ce\u573a\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u98ce\u573a\u673a\u7ec4\u6570\u91cf\u5fc5\u586b\uff01");
            }
            if (windFactory.getLineNo() == null || windFactory.getLineNo() == 0) {
                throw new RequiredException("\u66f4\u65b0\u98ce\u573a\u57fa\u7840\u4fe1\u606f\u5931\u8d25\uff0c\u98ce\u573a\u673a\u7ec4\u73af\u7ebf\u6570\u91cf\u5fc5\u586b\uff01");
            }
            Integer result = ((WindFactoryDao)this.baseMapper).updateById((Object)windFactory);
            return null != result && result >= 1;
        }
        return false;
    }
}

