/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.scada.manager.impl;

import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.base.manager.PointInfoManager;
import com.artfess.cssc.base.manager.SystemInfoManager;
import com.artfess.cssc.base.model.PointInfo;
import com.artfess.cssc.base.model.SystemInfo;
import com.artfess.cssc.scada.dao.PointSystemDao;
import com.artfess.cssc.scada.manager.PointSystemManager;
import com.artfess.cssc.scada.model.PointSystem;
import com.artfess.cssc.scada.params.PointSystemDataVo;
import com.artfess.poi.util.ExcelUtil;
import com.artfess.rabbitmq.config.RabbitMqTemplate;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PointSystemManagerImpl
extends BaseManagerImpl<PointSystemDao, PointSystem>
implements PointSystemManager {
    @Resource
    PointInfoManager pointInfoManager;
    @Resource
    PointSystemDao pointSystemDao;
    @Resource
    SystemInfoManager systemInfoManager;
    @Autowired
    private RabbitMqTemplate rabbitMqTemplate;
    @Resource
    CacheManager cacheManager;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"scada\u91c7\u96c6\u914d\u7f6e\u7f13\u5b58");

    @Override
    public PageList<PointSystem> queryPointSystemPage(QueryFilter<PointSystem> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<PointSystem> result = ((PointSystemDao)this.baseMapper).queryPage((IPage<PointSystem>)this.convert2IPage(pageBean), (Wrapper<PointSystem>)this.convert2Wrapper(queryFilter, this.currentModelClass()));
        return new PageList(result);
    }

    @Override
    @Transactional
    public CommonResult<String> insertPointSystem(String sysId, Integer configType, String lineId, String fanType, List<String> pointIdList) {
        if (StringUtil.isEmpty((String)sysId)) {
            throw new RequiredException("\u6dfb\u52a0\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u4e1a\u52a1\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (BeanUtils.isEmpty((Object)configType)) {
            throw new RequiredException("\u6dfb\u52a0\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (configType == 2 && StringUtil.isEmpty((String)lineId)) {
            throw new RequiredException("\u6dfb\u52a0\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u7ebf\u8defID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (configType == 3 && StringUtil.isEmpty((String)fanType)) {
            throw new RequiredException("\u6dfb\u52a0\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u673a\u7ec4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SYS_ID_", (Object)sysId);
        queryWrapper.eq((Object)"CONFIG_TYPE_", (Object)configType);
        queryWrapper.eq(StringUtil.isNotEmpty((String)lineId), (Object)"LINE_ID_", (Object)lineId);
        queryWrapper.eq(StringUtil.isNotEmpty((String)fanType), (Object)"FAN_TYPE_", (Object)fanType);
        queryWrapper.in((Object)"POINT_ID_", pointIdList);
        ((PointSystemDao)this.baseMapper).delete((Wrapper)queryWrapper);
        ArrayList<PointSystem> list = new ArrayList<PointSystem>();
        ArrayList<String> pid = new ArrayList<String>();
        for (String pointId : pointIdList) {
            PointInfo pointInfo = (PointInfo)this.pointInfoManager.get((Serializable)((Object)pointId));
            if (BeanUtils.isNotEmpty((Object)((Object)pointInfo))) {
                PointSystem pointSystem = new PointSystem();
                pointSystem.setSysId(sysId);
                pointSystem.setFanType(fanType);
                pointSystem.setPointId(pointId);
                pointSystem.setLineId(lineId);
                pointSystem.setConfigType(configType);
                pointSystem.setVarName(pointInfo.getVarName());
                list.add(pointSystem);
                continue;
            }
            pid.add(pointId);
        }
        boolean result = this.saveBatch(list);
        if (result) {
            if (BeanUtils.isNotEmpty(pid)) {
                return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01\u4f46\u662f\u70b9\u4f4did\uff1a\u3010" + ((Object)pid).toString() + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            this.saveScadaPointCache();
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff01");
    }

    @Override
    @Transactional
    public boolean deletePointSystemBySysID(String sysId) {
        if (StringUtil.isEmpty((String)sysId)) {
            throw new RequiredException("\u5220\u9664\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u4e1a\u52a1\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SYS_ID_", (Object)sysId);
        Integer result = ((PointSystemDao)this.baseMapper).delete((Wrapper)queryWrapper);
        if (null != result && result >= 0) {
            this.saveScadaPointCache();
        }
        return null != result && result >= 0;
    }

    @Override
    public List<Map<String, Object>> qureyAllKeys() {
        return this.pointSystemDao.getGatherKeys("", null);
    }

    @Override
    public Map<String, Object> qureyKeysGroupBySystem() {
        List systemInfoList = this.systemInfoManager.list();
        if (BeanUtils.isNotEmpty((Object)systemInfoList)) {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (SystemInfo systemInfo : systemInfoList) {
                HashMap allPointSysMap = new HashMap();
                HashMap windSysMap = new HashMap();
                List<Map<String, Object>> sysWindList = this.pointSystemDao.getGatherKeys(systemInfo.getId(), 1);
                if (sysWindList != null && sysWindList.size() > 0) {
                    ArrayList<String> keys = new ArrayList<String>();
                    ArrayList<String> keysName = new ArrayList<String>();
                    for (Map<String, Object> map : sysWindList) {
                        String key = map.get("keystr").toString();
                        String name = map.get("point_name_").toString();
                        keys.add(key);
                        keysName.add(name);
                    }
                    windSysMap.put("keys", keys);
                    windSysMap.put("names", keysName);
                }
                HashMap fanSysMap = new HashMap();
                List<Map<String, Object>> sysFanList = this.pointSystemDao.getGatherKeys(systemInfo.getId(), 3);
                if (sysFanList != null && sysFanList.size() > 0) {
                    ArrayList<String> keys = new ArrayList<String>();
                    ArrayList<String> keysName = new ArrayList<String>();
                    for (Map<String, Object> map : sysFanList) {
                        String key = map.get("keystr").toString();
                        String name = map.get("point_name_").toString();
                        keys.add(key);
                        keysName.add(name);
                    }
                    fanSysMap.put("keys", keys);
                    fanSysMap.put("names", keysName);
                }
                if (BeanUtils.isNotEmpty(windSysMap)) {
                    allPointSysMap.put("wind", windSysMap);
                }
                if (BeanUtils.isNotEmpty(fanSysMap)) {
                    allPointSysMap.put("fan", fanSysMap);
                }
                if (!BeanUtils.isNotEmpty(allPointSysMap)) continue;
                result.put("hz." + systemInfo.getSysCode() + ".scada", allPointSysMap);
            }
            return result;
        }
        return null;
    }

    @Override
    public void saveScadaPointCache() {
        List<Map<String, Object>> fanModelParamList;
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        HashMap allPointMap = new HashMap();
        List<Map<String, Object>> windList = this.pointSystemDao.getGatherKeys("", 1);
        HashMap windPointMap = new HashMap();
        if (windList != null && windList.size() > 0) {
            ArrayList<Object> keys = new ArrayList<Object>();
            ArrayList<String> keysName = new ArrayList<String>();
            for (Map<String, Object> map : windList) {
                String key = map.get("keystr").toString();
                String string = map.get("point_name_").toString();
                keys.add(key);
                keysName.add(string);
            }
            windPointMap.put("keys", keys);
            windPointMap.put("names", keysName);
        }
        List<Map<String, Object>> fanList = this.pointSystemDao.getGatherKeys("", 3);
        HashMap fanPointMap = new HashMap();
        ArrayList<String> allKeys = new ArrayList<String>();
        ArrayList<String> allKeysName = new ArrayList<String>();
        if (fanList != null && fanList.size() > 0) {
            for (Map map : fanList) {
                String string = map.get("keystr").toString();
                String name = map.get("point_name_").toString();
                allKeys.add(string);
                allKeysName.add(name);
            }
        }
        if ((fanModelParamList = this.pointSystemDao.getModelScadaParams()) != null && fanModelParamList.size() > 0) {
            for (Map<String, Object> map : fanModelParamList) {
                String paramKey = map.get("keystr").toString();
                String paramName = map.get("param_name_").toString();
                if (allKeys.contains(paramKey)) continue;
                allKeys.add(paramKey);
                allKeysName.add(paramName);
            }
        }
        if (allKeys != null && allKeys.size() > 0) {
            fanPointMap.put("keys", allKeys);
            fanPointMap.put("names", allKeysName);
        }
        allPointMap.put("wind", windPointMap);
        allPointMap.put("fan", fanPointMap);
        cache.delByKey("BIZ:SCADA:POINT:ALL");
        cache.put((Object)"BIZ:SCADA:POINT:ALL", (Object)JsonUtil.toJsonString(allPointMap), Long.valueOf(0L));
        cache.delByKey("BIZ:SCADA:POINT:SYSTEM");
        List list = this.systemInfoManager.list();
        ArrayList<String> arrayList = new ArrayList<String>();
        if (BeanUtils.isNotEmpty((Object)list)) {
            HashMap result = new HashMap();
            for (SystemInfo systemInfo : list) {
                if (StringUtil.isNotEmpty((String)systemInfo.getSysCode())) {
                    arrayList.add("hz." + systemInfo.getSysCode() + ".scada");
                }
                HashMap allPointSysMap = new HashMap();
                HashMap windSysMap = new HashMap();
                List<Map<String, Object>> sysWindList = this.pointSystemDao.getGatherKeys(systemInfo.getId(), 1);
                if (sysWindList != null && sysWindList.size() > 0) {
                    ArrayList<String> keys = new ArrayList<String>();
                    ArrayList<String> keysName = new ArrayList<String>();
                    for (Map<String, Object> map : sysWindList) {
                        String key = map.get("keystr").toString();
                        String name = map.get("point_name_").toString();
                        keys.add(key);
                        keysName.add(name);
                    }
                    windSysMap.put("keys", keys);
                    windSysMap.put("names", keysName);
                }
                HashMap fanSysMap = new HashMap();
                List<Map<String, Object>> sysFanList = this.pointSystemDao.getGatherKeys(systemInfo.getId(), 3);
                ArrayList<String> sysKeys = new ArrayList<String>();
                ArrayList<String> sysKeysName = new ArrayList<String>();
                if (sysFanList != null && sysFanList.size() > 0) {
                    for (Map<String, Object> map : sysFanList) {
                        String key = map.get("keystr").toString();
                        String name = map.get("point_name_").toString();
                        sysKeys.add(key);
                        sysKeysName.add(name);
                    }
                }
                if (systemInfo.getSysCode().equals("WindPlat") && fanModelParamList != null && fanModelParamList.size() > 0) {
                    for (Map<String, Object> paramMap : fanModelParamList) {
                        String paramKey = paramMap.get("keystr").toString();
                        String paramName = paramMap.get("param_name_").toString();
                        if (sysKeys.contains(paramKey)) continue;
                        sysKeys.add(paramKey);
                        sysKeysName.add(paramName);
                    }
                }
                if (sysKeys != null && sysKeys.size() > 0) {
                    fanSysMap.put("keys", sysKeys);
                    fanSysMap.put("names", sysKeysName);
                }
                if (BeanUtils.isNotEmpty(windSysMap)) {
                    allPointSysMap.put("wind", windSysMap);
                }
                if (BeanUtils.isNotEmpty(fanSysMap)) {
                    allPointSysMap.put("fan", fanSysMap);
                }
                if (!BeanUtils.isNotEmpty(allPointSysMap)) continue;
                result.put("hz." + systemInfo.getSysCode() + ".scada", allPointSysMap);
            }
            cache.put((Object)"BIZ:SCADA:POINT:SYSTEM", (Object)JsonUtil.toJsonString(result), Long.valueOf(0L));
        }
        ObjectNode obj = JsonUtil.getMapper().createObjectNode();
        obj.put("code", 200);
        if (arrayList != null && arrayList.size() > 0) {
            try {
                obj.put("data", (JsonNode)JsonUtil.listToArrayNode(arrayList));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        obj.put("time", new Date().getTime());
        this.rabbitMqTemplate.sendNotTTLMessage("exchange.hz", "scada.point.msg", (Object)obj);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public CommonResult<String> importData(String sysId, Integer configType, String lineId, String fanType, MultipartFile file) {
        if (StringUtil.isEmpty((String)sysId)) {
            throw new RequiredException("\u6dfb\u52a0\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u4e1a\u52a1\u7cfb\u7edfID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (BeanUtils.isEmpty((Object)configType)) {
            throw new RequiredException("\u6dfb\u52a0\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u914d\u7f6e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (configType == 2 && StringUtil.isEmpty((String)lineId)) {
            throw new RequiredException("\u6dfb\u52a0\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u7ebf\u8defID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (configType == 3 && StringUtil.isEmpty((String)fanType)) {
            throw new RequiredException("\u6dfb\u52a0\u91c7\u96c6\u914d\u7f6e\u5931\u8d25\uff0c\u673a\u7ec4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List list = ExcelUtil.readExcel(PointSystemDataVo.class, (MultipartFile)file);
        ArrayList<PointInfo> pointInfos = new ArrayList<PointInfo>();
        ArrayList<String> noneVarName = new ArrayList<String>();
        for (PointSystemDataVo pointSystemDataVo : list) {
            if (!StringUtils.isNotEmpty((CharSequence)pointSystemDataVo.getVarName())) continue;
            QueryWrapper pointInfoQueryWrapper = new QueryWrapper();
            pointInfoQueryWrapper.eq((Object)"var_name_", (Object)pointSystemDataVo.getVarName());
            PointInfo pointInfo = (PointInfo)((Object)this.pointInfoManager.getOne((Wrapper)pointInfoQueryWrapper));
            if (pointInfo != null) {
                pointInfos.add(pointInfo);
                continue;
            }
            noneVarName.add(pointSystemDataVo.getVarName());
        }
        String ids = pointInfos.stream().map(PointInfo::getId).collect(Collectors.joining(","));
        List<String> pointIdList = Arrays.asList(ids.split(","));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"SYS_ID_", (Object)sysId);
        queryWrapper.eq((Object)"CONFIG_TYPE_", (Object)configType);
        queryWrapper.eq(StringUtil.isNotEmpty((String)lineId), (Object)"LINE_ID_", (Object)lineId);
        queryWrapper.eq(StringUtil.isNotEmpty((String)fanType), (Object)"FAN_TYPE_", (Object)fanType);
        queryWrapper.in((Object)"POINT_ID_", pointIdList);
        ((PointSystemDao)this.baseMapper).delete((Wrapper)queryWrapper);
        ArrayList<PointSystem> listPointSystem = new ArrayList<PointSystem>();
        for (String pointId : pointIdList) {
            PointInfo pointInfo = (PointInfo)this.pointInfoManager.get((Serializable)((Object)pointId));
            if (!BeanUtils.isNotEmpty((Object)((Object)pointInfo))) continue;
            PointSystem pointSystem = new PointSystem();
            pointSystem.setSysId(sysId);
            pointSystem.setFanType(fanType);
            pointSystem.setPointId(pointId);
            pointSystem.setLineId(lineId);
            pointSystem.setConfigType(configType);
            pointSystem.setVarName(pointInfo.getVarName());
            listPointSystem.add(pointSystem);
        }
        boolean result = this.saveBatch(listPointSystem);
        if (result) {
            if (BeanUtils.isNotEmpty(noneVarName)) {
                return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01\u4f46\u662f\u70b9\u4f4d\uff1a\u3010" + noneVarName.toString() + "\u3011\u4e0d\u5b58\u5728\uff01");
            }
            this.saveScadaPointCache();
            return new CommonResult(true, "\u4fdd\u5b58\u6210\u529f\uff01");
        }
        return new CommonResult(false, "\u4fdd\u5b58\u5931\u8d25\uff01");
    }
}

