/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.manager.impl;

import com.artfess.base.datasource.DatabaseContext;
import com.artfess.base.datasource.DatabaseSwitchResult;
import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.CommonManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.FieldSort;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.FileUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.time.DateFormatUtil;
import com.artfess.cssc.model.dao.ModelInfoDao;
import com.artfess.cssc.model.dao.ModelParamsDao;
import com.artfess.cssc.model.manager.ModelFanManager;
import com.artfess.cssc.model.manager.ModelInfoManager;
import com.artfess.cssc.model.manager.ModelParamsManager;
import com.artfess.cssc.model.manager.ModelTaskManager;
import com.artfess.cssc.model.model.ModelInfo;
import com.artfess.cssc.model.model.ModelParams;
import com.artfess.cssc.util.RemoteExecuteCommandUtil;
import com.artfess.cssc.util.SshUtil;
import com.artfess.sysConfig.util.SysPropertyUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.File;
import java.io.InputStream;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ModelInfoManagerImpl
extends BaseManagerImpl<ModelInfoDao, ModelInfo>
implements ModelInfoManager {
    @Resource
    ModelFanManager modelFanManager;
    @Resource
    ModelParamsDao modelParamsDao;
    @Resource
    ModelParamsManager modelParamsManager;
    @Resource
    ModelTaskManager modelTaskManager;
    @Resource
    JdbcTemplate jdbcTemplate;
    @Resource
    DatabaseContext databaseContext;
    @Resource
    CommonManager commonManager;

    @Override
    @Transactional
    public String insertModelInfo(ModelInfo modelInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)modelInfo))) {
            if (StringUtil.isEmpty((String)modelInfo.getModelCode())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u4fe1\u606f\u5931\u8d25\uff0c\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameCode(modelInfo.getModelCode(), modelInfo.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u4fe1\u606f\u5931\u8d25\uff0c\u6a21\u578b\u7f16\u7801\u3010" + modelInfo.getModelCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            modelInfo.setSn(this.getNextSequence(null));
            modelInfo.setResultTable("R_" + modelInfo.getModelCode().toUpperCase());
            Integer result = ((ModelInfoDao)this.baseMapper).insert((Object)modelInfo);
            ArrayList<ModelParams> paramsList = new ArrayList<ModelParams>();
            ModelParams paramsFan = new ModelParams();
            paramsFan.setModelId(modelInfo.getId());
            paramsFan.setModelCode(modelInfo.getModelCode());
            paramsFan.setParamNature(1);
            paramsFan.setParamType("result");
            paramsFan.setParamName("\u673a\u7ec4\u7f16\u7801");
            paramsFan.setParamCode("fan_code_");
            paramsFan.setParamDataType("S");
            paramsFan.setParamWidth(80);
            paramsFan.setSn(1);
            ModelParams paramsTime = new ModelParams();
            paramsTime.setModelId(modelInfo.getId());
            paramsTime.setModelCode(modelInfo.getModelCode());
            paramsTime.setParamNature(1);
            paramsTime.setParamType("result");
            paramsTime.setParamName("\u8c03\u5ea6\u65f6\u95f4");
            paramsTime.setParamCode("scheduler_time_");
            paramsTime.setParamDataType("T");
            paramsTime.setParamWidth(125);
            paramsTime.setSn(2);
            ModelParams paramsCreate = new ModelParams();
            paramsCreate.setModelId(modelInfo.getId());
            paramsCreate.setModelCode(modelInfo.getModelCode());
            paramsCreate.setParamNature(1);
            paramsCreate.setParamType("result");
            paramsCreate.setParamName("\u5165\u5e93\u65f6\u95f4");
            paramsCreate.setParamCode("create_time_");
            paramsCreate.setParamDataType("T");
            paramsCreate.setParamWidth(125);
            paramsCreate.setSn(3);
            paramsList.add(paramsFan);
            paramsList.add(paramsTime);
            paramsList.add(paramsCreate);
            this.modelParamsManager.insertBatchModelParams(paramsList);
            return modelInfo.getId();
        }
        return null;
    }

    @Override
    @Transactional
    public boolean updateModelInfo(ModelInfo modelInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)modelInfo))) {
            if (this.checkSameCode(modelInfo.getModelCode(), modelInfo.getId())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u4fe1\u606f\u5931\u8d25\uff0c\u6a21\u578b\u7f16\u7801\u3010" + modelInfo.getModelCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((ModelInfoDao)this.baseMapper).updateById((Object)modelInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean deleteModelById(String id) {
        if (StringUtil.isNotEmpty((String)id)) {
            this.modelFanManager.deleteByModel(id);
            this.modelParamsManager.deleteByModel(id, null);
            this.modelTaskManager.deleteModelTaskByModelId(id);
            return this.removeById((Serializable)((Object)id));
        }
        throw new RequiredException("\u5220\u9664\u6a21\u578b\u4fe1\u606f\u5931\u8d25\uff0cid\u4e3a\u7a7a\uff01");
    }

    @Override
    public boolean creatTaosTable(String modelId) throws Exception {
        if (StringUtil.isEmpty((String)modelId)) {
            throw new RequiredException("\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ModelInfo modelInfo = (ModelInfo)((Object)((ModelInfoDao)this.baseMapper).selectById((Serializable)((Object)modelId)));
        if (BeanUtils.isNotEmpty((Object)((Object)modelInfo)) && modelInfo.getTaosIsCreate() != 1) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"model_id_", (Object)modelInfo.getId());
            queryWrapper.eq((Object)"param_type_", (Object)"param");
            queryWrapper.eq((Object)"param_class_", (Object)"Scada");
            queryWrapper.eq((Object)"param_nature_", (Object)2);
            queryWrapper.orderByAsc((Object)"sn_");
            List list = this.modelParamsDao.selectList((Wrapper)queryWrapper);
            if (list != null && list.size() > 0) {
                StringBuffer sql = new StringBuffer();
                sql.append("CREATE STABLE if not exists ").append(modelInfo.getModelCode()).append("(tm  TIMESTAMP");
                for (ModelParams modelParams : list) {
                    sql.append("," + modelParams.getParamCode());
                    if (modelParams.getParamDataType().toUpperCase().equals("F")) {
                        sql.append(" FLOAT ");
                        continue;
                    }
                    if (modelParams.getParamDataType().toUpperCase().equals("I")) {
                        sql.append(" BIGINT ");
                        continue;
                    }
                    if (!modelParams.getParamDataType().toUpperCase().equals("B")) continue;
                    sql.append(" BOOL ");
                }
                sql.append(") ");
                sql.append(" TAGS (fanCode NCHAR(64), fanType NCHAR(64))");
                try (DatabaseSwitchResult dResult = this.databaseContext.setDataSource("taos");){
                    this.jdbcTemplate.execute(sql.toString());
                }
                catch (Exception e) {
                    throw new BaseException(e.getMessage(), (Throwable)e);
                }
                modelInfo.setTaosIsCreate(1);
                ((ModelInfoDao)this.baseMapper).updateById((Object)modelInfo);
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public boolean creatResultTable(String modelId) throws Exception {
        if (StringUtil.isEmpty((String)modelId)) {
            throw new RequiredException("\u6a21\u578bID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ModelInfo modelInfo = (ModelInfo)((Object)((ModelInfoDao)this.baseMapper).selectById((Serializable)((Object)modelId)));
        if (BeanUtils.isNotEmpty((Object)((Object)modelInfo)) && modelInfo.getResultIsCreate() != 1) {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"model_id_", (Object)modelInfo.getId());
            queryWrapper.eq((Object)"param_type_", (Object)"result");
            queryWrapper.eq((Object)"param_nature_", (Object)2);
            int count = this.modelParamsDao.selectCount((Wrapper)queryWrapper);
            List list = new ArrayList();
            if (count > 0) {
                queryWrapper.clear();
                queryWrapper.eq((Object)"model_id_", (Object)modelInfo.getId());
                queryWrapper.eq((Object)"param_type_", (Object)"result");
                queryWrapper.orderByAsc((Object)"sn_");
                list = this.modelParamsDao.selectList((Wrapper)queryWrapper);
            }
            if (list != null && list.size() > 0) {
                ArrayList<String> sqlList = new ArrayList<String>();
                String tableName = "R_" + modelInfo.getModelCode().toUpperCase();
                StringBuffer sb = new StringBuffer();
                sb.append("CREATE TABLE " + tableName + " (\n");
                sb.append(" ID_ VARCHAR(64) not null");
                for (ModelParams modelParams : list) {
                    String fieldName = modelParams.getParamCode().toUpperCase();
                    sb.append(",\n " + fieldName);
                    if (modelParams.getParamDataType().toUpperCase().equals("F")) {
                        sb.append(" NUMERIC(12,2) ");
                    } else if (modelParams.getParamDataType().toUpperCase().equals("I")) {
                        sb.append(" INT8 ");
                    } else if (modelParams.getParamDataType().toUpperCase().equals("B")) {
                        sb.append(" VARCHAR(32) ");
                    } else if (modelParams.getParamDataType().toUpperCase().equals("S")) {
                        sb.append(" VARCHAR(500) ");
                    } else if (modelParams.getParamDataType().toUpperCase().equals("D")) {
                        sb.append(" DATE ");
                    } else if (modelParams.getParamDataType().toUpperCase().equals("T")) {
                        sb.append(" TIMESTAMP ");
                    }
                    sqlList.add(" COMMENT ON column " + tableName + "." + fieldName + " is '" + modelParams.getParamName() + "';");
                }
                sb.append(",\n TENANT_ID_   VARCHAR(64)          null default '-1' ");
                sb.append(",\n constraint PK_" + modelInfo.getModelCode().toUpperCase() + " primary key (ID_)");
                sb.append("\n);");
                sqlList.add(0, sb.toString());
                String[] sql = new String[sqlList.size()];
                sqlList.toArray(sql);
                this.jdbcTemplate.batchUpdate(sql);
                modelInfo.setResultIsCreate(1);
                modelInfo.setResultTable("R_" + modelInfo.getModelCode().toUpperCase());
                ((ModelInfoDao)this.baseMapper).updateById((Object)modelInfo);
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional
    public boolean uploadForSSH(MultipartFile file, String modelId) throws Exception {
        if (StringUtil.isEmpty((String)modelId)) {
            throw new RequiredException("\u4e0a\u4f20\u6a21\u578b\u5931\u8d25\uff0c\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String fileName = file.getOriginalFilename();
        if (!fileName.matches("^.+\\.(?i)(zip)$")) {
            throw new RequiredException("\u4e0a\u4f20\u6a21\u578b\u5931\u8d25\uff0c\u8bf7\u4e0a\u4f20zip\u683c\u5f0f\u7684\u538b\u7f29\u5305\uff01");
        }
        ModelInfo modelInfo = (ModelInfo)((Object)((ModelInfoDao)this.baseMapper).selectById((Serializable)((Object)modelId)));
        String serverIp = modelInfo.getModelServerIp();
        int port = modelInfo.getModelServerPort();
        String user = modelInfo.getModelServerUser();
        String password = modelInfo.getModelServerPassword();
        String fileLocalPath = SysPropertyUtil.getByAlias((String)"file.upload") + File.separator + modelInfo.getModelCode() + File.separator + fileName;
        FileUtil.createFolder((String)fileLocalPath, (boolean)true);
        FileUtil.writeFile((String)fileLocalPath, (InputStream)file.getInputStream());
        String remotePath = modelInfo.getModelUpload() + "/" + modelInfo.getModelCode();
        SshUtil sshUtil = SshUtil.getSftpUtil(serverIp, port, user, password);
        sshUtil.upload(remotePath, fileLocalPath);
        String cmd = "unzip  -o " + remotePath + "/" + fileName + " -d " + remotePath;
        System.out.println(cmd);
        RemoteExecuteCommandUtil rec = new RemoteExecuteCommandUtil(serverIp, port, user, password);
        rec.execute(cmd);
        modelInfo.setFileIsUpload(1);
        ((ModelInfoDao)this.baseMapper).updateById((Object)modelInfo);
        if (sshUtil != null) {
            SshUtil.release();
        }
        return true;
    }

    @Override
    public PageList sliceQueryModelResult(String modelId, QueryFilter filter) throws Exception {
        if (StringUtil.isEmpty((String)modelId)) {
            throw new RequiredException("\u6a21\u578bid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ModelInfo modelInfo = (ModelInfo)((Object)((ModelInfoDao)this.baseMapper).selectById((Serializable)((Object)modelId)));
        if (StringUtil.isEmpty((String)modelInfo.getResultTable())) {
            throw new RequiredException("\u6a21\u578b\u7ed3\u679c\u8868\u8fd8\u6ca1\u6709\u521b\u5efa\uff01");
        }
        StringBuffer conditionSql = new StringBuffer();
        List queryFieldList = filter.getQuerys();
        if (queryFieldList.size() > 0) {
            for (QueryField queryField : queryFieldList) {
                ArrayList value1;
                QueryOP op;
                String fieldName = queryField.getProperty();
                if (StringUtil.isEmpty((String)fieldName)) continue;
                String relation = queryField.getRelation().value();
                String condition = queryField.getOperation().value();
                Object value = queryField.getValue();
                if (BeanUtils.isEmpty((Object)value)) continue;
                if (relation == null || relation.trim().equals("") || relation.toLowerCase().equals("null")) {
                    relation = "and";
                }
                if (QueryOP.IS_NULL.equals((Object)(op = QueryOP.getByVal((String)condition)))) {
                    conditionSql.append(" " + relation + " " + fieldName + " is null ");
                    continue;
                }
                if (QueryOP.NOTNULL.equals((Object)op)) {
                    conditionSql.append(" " + relation + " " + fieldName + " is not null ");
                    continue;
                }
                if (QueryOP.IN.equals((Object)op)) {
                    String v = "";
                    String[] vals = value.toString().split(",");
                    for (int j = 0; j < vals.length; ++j) {
                        v = v + "'" + vals[j] + "'";
                        if (j == vals.length - 1) continue;
                        v = v + ",";
                    }
                    conditionSql.append(" " + relation + " " + fieldName + " " + op.op() + "(" + v + ") ");
                    continue;
                }
                if (QueryOP.EQUAL.equals((Object)op) || QueryOP.NOT_EQUAL.equals((Object)op)) {
                    conditionSql.append(" " + relation + " " + fieldName + op.op() + "'" + value.toString() + "' ");
                    continue;
                }
                if (QueryOP.LIKE.equals((Object)op)) {
                    conditionSql.append(" " + relation + " " + fieldName + " like '%" + value.toString() + "%' ");
                    continue;
                }
                if (QueryOP.RIGHT_LIKE.equals((Object)op)) {
                    conditionSql.append(" " + relation + " " + fieldName + " like '" + value.toString() + "%' ");
                    continue;
                }
                if (QueryOP.LEFT_LIKE.equals((Object)op)) {
                    conditionSql.append(" " + relation + " " + fieldName + " like '%" + value.toString() + "' ");
                    continue;
                }
                if (QueryOP.EQUAL_IGNORE_CASE.equals((Object)op)) {
                    conditionSql.append(" " + relation + " upper(" + fieldName + ") " + op.op() + "'" + value.toString().toUpperCase() + "' ");
                    continue;
                }
                if (!QueryOP.BETWEEN.equals((Object)op) || (value1 = (ArrayList)value).size() != 2) continue;
                if (BeanUtils.isNotEmpty(value1.get(0))) {
                    String start = value1.get(0).toString();
                    conditionSql.append(" " + relation + " " + fieldName + " " + ">=" + "'" + start + "' ");
                }
                if (!BeanUtils.isNotEmpty(value1.get(1))) continue;
                String end = value1.get(1).toString();
                conditionSql.append(" " + relation + " " + fieldName + " " + "<=" + "'" + end + "' ");
            }
        }
        List sorterList = filter.getSorter();
        StringBuffer sorterSql = new StringBuffer();
        if (sorterList.size() > 0) {
            sorterSql.append(" order by ");
            for (int i = 0; i < sorterList.size(); ++i) {
                FieldSort fieldSort = (FieldSort)sorterList.get(i);
                String fieldName = fieldSort.getProperty();
                if (StringUtil.isEmpty((String)fieldName)) {
                    sorterSql.delete(0, sorterSql.length());
                    continue;
                }
                String sortType = fieldSort.getDirection().name();
                sorterSql.append(fieldName + " " + sortType);
                if (i >= sorterList.size() - 1) continue;
                sorterSql.append(",");
            }
        }
        String sqlStr = "select *  from " + modelInfo.getResultTable() + " where 1=1 " + conditionSql.toString() + sorterSql.toString();
        PageBean pageBean = filter.getPageBean();
        PageBean page = pageBean == null ? new PageBean() : pageBean;
        PageList pageList = this.commonManager.query(sqlStr, page);
        List list = pageList.getRows();
        for (int i = 0; i < list.size(); ++i) {
            Map m = (Map)list.get(i);
            HashMap<String, Object> tm = new HashMap<String, Object>();
            for (String k : m.keySet()) {
                try {
                    if (BeanUtils.isNotEmpty(m.get(k)) && "java.sql.Timestamp".equals(m.get(k).getClass().getCanonicalName())) {
                        Date date = (Date)m.get(k);
                        if (date.getYear() == 70 && date.getMonth() == 0 && date.getDate() == 1) {
                            tm.put(k.toLowerCase(), DateFormatUtil.format((LocalDateTime)LocalDateTime.now(), (String)"HH:mm:ss"));
                        } else if (date.getMinutes() == 0 && date.getHours() == 0 && date.getSeconds() == 0) {
                            tm.put(k.toLowerCase(), DateFormatUtil.parse((Date)date).toLocalDate());
                        } else {
                            tm.put(k.toLowerCase(), DateFormatUtil.parse((Date)date));
                        }
                    } else {
                        tm.put(k.toLowerCase(), m.get(k));
                    }
                }
                catch (Exception e) {
                    tm.put(k.toLowerCase(), m.get(k));
                }
                list.set(i, tm);
            }
        }
        return pageList;
    }

    private boolean checkSameCode(String code, String id) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"model_code_", (Object)code);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"ID_", (Object)id);
        int num = ((ModelInfoDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

