/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.base.dao.WfLineDao;
import com.artfess.cssc.base.manager.FanInfoManager;
import com.artfess.cssc.base.manager.WfLineManager;
import com.artfess.cssc.base.model.FanInfo;
import com.artfess.cssc.base.model.WfLine;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class WfLineManagerImpl
extends BaseManagerImpl<WfLineDao, WfLine>
implements WfLineManager {
    @Resource
    FanInfoManager fanInfoManager;

    @Override
    @Transactional
    public boolean insertWfLine(WfLine wfLine) {
        if (BeanUtils.isNotEmpty((Object)((Object)wfLine))) {
            if (this.checkSameCode(wfLine.getLineCode(), wfLine.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u98ce\u573a\u7ebf\u8def\u5931\u8d25\uff0c\u98ce\u573a\u7ebf\u8def\u7f16\u7801\u3010" + wfLine.getLineCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((WfLineDao)this.baseMapper).insert((Object)wfLine);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateWfLine(WfLine wfLine) {
        if (BeanUtils.isNotEmpty((Object)((Object)wfLine))) {
            if (this.checkSameCode(wfLine.getLineCode(), wfLine.getId())) {
                throw new RequiredException("\u66f4\u65b0\u98ce\u573a\u7ebf\u8def\u5931\u8d25\uff0c\u98ce\u573a\u7ebf\u8def\u7f16\u7801\u3010" + wfLine.getLineCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((WfLineDao)this.baseMapper).updateById((Object)wfLine);
            return null != result && result >= 1;
        }
        return false;
    }

    @Transactional
    public boolean removeById(Serializable id) {
        if (StringUtil.isNotEmpty((String)id.toString())) {
            WfLine wfLine = (WfLine)((Object)this.getById(id));
            if (BeanUtils.isNotEmpty((Object)((Object)wfLine))) {
                boolean flag = this.isCodeExistFan(wfLine.getLineCode());
                if (flag) {
                    throw new RequiredException("\u5220\u9664\u98ce\u573a\u7ebf\u8def\u5931\u8d25\uff0c\u98ce\u573a\u7ebf\u8def\u7f16\u7801\u3010" + wfLine.getLineCode() + "\u3011\u4e0b\u5df2\u7ed1\u5b9a\u673a\u7ec4\uff0c\u4e0d\u80fd\u5220\u9664\uff01");
                }
                ((WfLineDao)this.baseMapper).deleteById(id);
            }
            return true;
        }
        return false;
    }

    @Transactional
    public boolean removeByIds(Collection<? extends Serializable> idList) {
        if (CollectionUtils.isNotEmpty(idList)) {
            ArrayList<Serializable> delIds = new ArrayList<Serializable>();
            for (Serializable serializable : idList) {
                WfLine wfLine = (WfLine)((Object)this.getById(serializable));
                if (!BeanUtils.isNotEmpty((Object)((Object)wfLine))) continue;
                boolean flag = this.isCodeExistFan(wfLine.getLineCode());
                if (!flag) {
                    delIds.add(serializable);
                }
                ((WfLineDao)this.baseMapper).deleteBatchIds(delIds);
            }
            return true;
        }
        throw new RequiredException("\u5220\u9664\u98ce\u573a\u7ebf\u8def\u5931\u8d25,\u98ce\u573a\u7ebf\u8defID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }

    private boolean isCodeExistFan(String code) {
        List<FanInfo> list = this.fanInfoManager.queryFanByLine(code, null);
        return list != null && list.size() > 0;
    }

    private boolean checkSameCode(String code, String id) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"line_code_", (Object)code);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"ID_", (Object)id);
        int num = ((WfLineDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

