/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.cache.CacheManager;
import com.artfess.base.cache.ICache;
import com.artfess.base.cache.setting.CacheSetting;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.cssc.base.manager.FanInfoManager;
import com.artfess.cssc.base.model.FanInfo;
import com.artfess.cssc.base.params.FanInfoVo;
import com.artfess.cssc.scada.manager.PointSystemManager;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.Serializable;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/biz/base/fanInfo/v1/"})
@Api(tags={"\u673a\u7ec4\u57fa\u7840\u4fe1\u606f"})
@ApiGroup(group={"group_biz"})
public class FanInfoController
extends BaseController<FanInfoManager, FanInfo> {
    @Resource
    PointSystemManager pointSystemManager;
    @Resource
    CacheManager cacheManager;
    private static final CacheSetting cacheSetting = CacheSetting.buildDefault((String)"\u6a21\u578b\u53c2\u6570\u91c7\u96c6\u7f13\u5b58");

    @PostMapping(value={"/queryFanInfo"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u7ed3\u679c")
    public PageList<FanInfoVo> queryFanInfo(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<FanInfo> queryFilter) {
        queryFilter.addFilter("f.is_dele_", (Object)"1", QueryOP.NOT_EQUAL);
        return ((FanInfoManager)this.baseService).queryFanInfo(queryFilter);
    }

    @PostMapping(value={"/"})
    @ApiOperation(value="\u6dfb\u52a0\u673a\u7ec4\u4fe1\u606f\u7684\u63a5\u53e3")
    public CommonResult<String> create(@ApiParam(name="model", value="\u673a\u7ec4\u4fe1\u606f") @RequestBody FanInfo fanInfo) {
        boolean result = ((FanInfoManager)this.baseService).insertFanInfo(fanInfo);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult();
    }

    @PutMapping(value={"/"})
    @ApiOperation(value="\u66f4\u65b0\u673a\u7ec4\u4fe1\u606f")
    public CommonResult<String> updateById(@ApiParam(name="model", value="\u673a\u7ec4\u4fe1\u606f") @RequestBody FanInfo fanInfo) {
        boolean result = ((FanInfoManager)this.baseService).updateFanInfo(fanInfo);
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u65b0\u673a\u7ec4\u4fe1\u606f\u5931\u8d25");
        }
        this.pointSystemManager.saveScadaPointCache();
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        return new CommonResult();
    }

    @DeleteMapping(value={"/{id}"})
    @ApiOperation(value="\u6839\u636eid\u5220\u9664")
    public CommonResult<String> deleteById(@ApiParam(name="id", value="\u5b9e\u4f53id") @PathVariable String id) {
        boolean result = ((FanInfoManager)this.baseService).removeById((Serializable)((Object)id));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        this.pointSystemManager.saveScadaPointCache();
        ICache cache = this.cacheManager.getCache("", cacheSetting);
        cache.delByKey("BIZ:SCADA:MODEL:PARAMS");
        return new CommonResult();
    }

    @DeleteMapping(value={"/"})
    @ApiOperation(value="\u6839\u636eid\u96c6\u5408\u6279\u91cf\u5220\u9664")
    public CommonResult<String> deleteByIds(String ... ids) {
        boolean result = ((FanInfoManager)this.baseService).removeByIds(Arrays.asList(ids));
        if (!result) {
            return new CommonResult(ResponseErrorEnums.FAIL_OPTION, (Object)"\u5220\u9664\u5b9e\u4f53\u5931\u8d25");
        }
        return new CommonResult();
    }

    @PostMapping(value={"/list"})
    @ApiOperation(value="\u673a\u7ec4\u4fe1\u606f\u5217\u8868", httpMethod="POST", notes="\u673a\u7ec4\u4fe1\u606f\u5217\u8868")
    public List<FanInfo> list(@ApiParam(name="queryFilter", value="\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<FanInfo> queryFilter) throws Exception {
        return ((FanInfoManager)this.baseService).queryNoPage(queryFilter);
    }

    @PostMapping(value={"/updateFanSequence"})
    @ApiOperation(value="\u4fee\u6539\u673a\u7ec4\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u4fee\u6539\u673a\u7ec4\u6392\u5e8f\u53f7")
    public CommonResult<String> updateFanSequence(@ApiParam(name="map", value="key:\u673a\u7ec4id,value:\u6392\u5e8f\u53f7", required=true) @RequestBody HashMap<String, Integer> map) throws Exception {
        ((FanInfoManager)this.baseService).updateSequence(map);
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }

    @PostMapping(value={"/updateFanLineSequence"})
    @ApiOperation(value="\u4fee\u6539\u673a\u7ec4\u73af\u7ebf\u6392\u5e8f\u53f7", httpMethod="POST", notes="\u4fee\u6539\u673a\u7ec4\u73af\u7ebf\u6392\u5e8f\u53f7")
    @ApiImplicitParam(name="map", value="key:\u673a\u7ec4id,value:\u673a\u7ec4\u73af\u7ebf\u6392\u5e8f\u53f7", required=true)
    public CommonResult<String> updateFanLineSequence(@RequestBody HashMap<String, Integer> map) throws Exception {
        ((FanInfoManager)this.baseService).updateFanLineSequence(map);
        return new CommonResult("\u4fee\u6539\u6210\u529f\uff01");
    }

    @GetMapping(value={"/getByCode"})
    @ApiOperation(value="\u6839\u636ecode\u67e5\u8be2\u5b9e\u4f53")
    public FanInfo getByCode(@ApiParam(name="code", value="\u5b9e\u4f53\u7f16\u7801") @RequestParam String code) {
        return ((FanInfoManager)this.baseService).getByFanCode(code);
    }
}

