/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.util;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelExec;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SshUtil {
    private static final Log logger = LogFactory.getLog(SshUtil.class);
    private static Date last_push_date = null;
    private Session sshSession;
    private ChannelSftp channel;
    private static ThreadLocal<SshUtil> sftpLocal = new ThreadLocal();

    private SshUtil(String host, int port, String username, String password) throws Exception {
        JSch jsch = new JSch();
        jsch.getSession(username, host, port);
        this.sshSession = jsch.getSession(username, host, port);
        this.sshSession.setPassword(password);
        this.sshSession.setConfig("userauth.gssapi-with-mic", "no");
        this.sshSession.setConfig("StrictHostKeyChecking", "no");
        this.sshSession.connect();
        this.channel = (ChannelSftp)this.sshSession.openChannel("sftp");
        this.channel.connect();
        logger.info((Object)("\u8fde\u63a5\u6210\u529f!" + this.sshSession));
    }

    public static boolean isConnected(String host, int port, String username, String password) throws Exception {
        SshUtil sshUtil = new SshUtil(host, port, username, password);
        return null != sshUtil && sshUtil.isConnected();
    }

    private boolean isConnected() throws Exception {
        return null != this.channel && this.channel.isConnected();
    }

    public static SshUtil getSftpUtil(String host, int port, String username, String password) throws Exception {
        SshUtil sftpUtil = sftpLocal.get();
        if (null == sftpUtil || !sftpUtil.isConnected()) {
            sftpLocal.set(new SshUtil(host, port, username, password));
        }
        return sftpLocal.get();
    }

    public static void release() {
        if (null != sftpLocal.get()) {
            sftpLocal.get().closeChannel();
            logger.info((Object)("\u5173\u95ed\u8fde\u63a5" + SshUtil.sftpLocal.get().sshSession));
            sftpLocal.set(null);
        }
    }

    public void closeChannel() {
        if (null != this.channel) {
            try {
                this.channel.disconnect();
            }
            catch (Exception e) {
                logger.error((Object)"\u5173\u95edSFTP\u901a\u9053\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            }
        }
        if (null != this.sshSession) {
            try {
                this.sshSession.disconnect();
            }
            catch (Exception e) {
                logger.error((Object)"SFTP\u5173\u95ed session\u5f02\u5e38:", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean exec(String cmd, String url) {
        Channel cmdchannel = null;
        BufferedReader reader = null;
        InputStream in = null;
        try {
            cmdchannel = this.sshSession.openChannel("exec");
            ((ChannelExec)cmdchannel).setCommand("cd " + url);
            ((ChannelExec)cmdchannel).setCommand(cmd);
            ((ChannelExec)cmdchannel).setInputStream(null);
            ((ChannelExec)cmdchannel).setErrStream((OutputStream)System.err);
            cmdchannel.connect();
            in = cmdchannel.getInputStream();
            reader = new BufferedReader(new InputStreamReader(in));
            String buf = null;
            while ((buf = reader.readLine()) != null) {
                System.out.println(buf);
            }
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            cmdchannel.disconnect();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void upload(String directory, String uploadFile) throws Exception {
        try {
            this.channel.ls(directory);
        }
        catch (Exception e) {
            logger.error((Object)"\u3010\u76ee\u5f55\u521b\u5efa\u3011\uff1a", (Throwable)e);
            String[] dirs = directory.split("/");
            String tempPath = "";
            int index = 0;
            this.mkdirDir(dirs, tempPath, dirs.length, index);
        }
        finally {
            this.channel.cd(directory);
            List<File> files = this.getFiles(uploadFile, new ArrayList<File>());
            for (int i = 0; i < files.size(); ++i) {
                File file = files.get(i);
                BufferedInputStream input = new BufferedInputStream(new FileInputStream(file));
                this.channel.put((InputStream)input, file.getName());
                try {
                    if (input != null) {
                        ((InputStream)input).close();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    logger.error((Object)(file.getName() + "\u5173\u95ed\u6587\u4ef6\u65f6.....\u5f02\u5e38!" + e.getMessage()));
                }
                if (file.exists()) {
                    boolean b = file.delete();
                    logger.info((Object)(file.getName() + "\u6587\u4ef6\u4e0a\u4f20\u5b8c\u6bd5!\u5220\u9664\u6807\u8bc6:" + b));
                }
                if (null == last_push_date) {
                    last_push_date = new Date(file.lastModified());
                    continue;
                }
                long modifyDate = file.lastModified();
                if (modifyDate <= last_push_date.getTime()) continue;
                last_push_date = new Date(modifyDate);
            }
        }
    }

    public List<File> getFiles(String realpath, List<File> files) {
        File realFile = new File(realpath);
        if (realFile.isDirectory()) {
            File[] subfiles;
            for (File file : subfiles = realFile.listFiles(new FileFilter(){

                @Override
                public boolean accept(File file) {
                    if (null == last_push_date) {
                        return true;
                    }
                    long modifyDate = file.lastModified();
                    return modifyDate > last_push_date.getTime();
                }
            })) {
                if (file.isDirectory()) {
                    this.getFiles(file.getAbsolutePath(), files);
                    continue;
                }
                files.add(file);
            }
        }
        if (realFile.isFile()) {
            files.add(realFile);
        }
        return files;
    }

    public void mkdirDir(String[] dirs, String tempPath, int length, int index) {
        if (++index < length) {
            tempPath = tempPath + "/" + dirs[index];
        }
        try {
            logger.info((Object)("\u68c0\u6d4b\u76ee\u5f55[" + tempPath + "]"));
            this.channel.cd(tempPath);
            if (index < length) {
                this.mkdirDir(dirs, tempPath, length, index);
            }
        }
        catch (SftpException ex) {
            logger.warn((Object)("\u521b\u5efa\u76ee\u5f55[" + tempPath + "]"));
            try {
                this.channel.mkdir(tempPath);
                this.channel.cd(tempPath);
            }
            catch (SftpException e) {
                e.printStackTrace();
                logger.error((Object)("\u521b\u5efa\u76ee\u5f55[" + tempPath + "]\u5931\u8d25,\u5f02\u5e38\u4fe1\u606f[" + e.getMessage() + "]"));
            }
            logger.info((Object)("\u8fdb\u5165\u76ee\u5f55[" + tempPath + "]"));
            this.mkdirDir(dirs, tempPath, length, index);
        }
    }
}

