/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.model.dao.ModelParamsDao;
import com.artfess.cssc.model.manager.ModelInfoManager;
import com.artfess.cssc.model.manager.ModelParamsManager;
import com.artfess.cssc.model.model.ModelParams;
import com.artfess.cssc.scada.manager.PointSystemManager;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class ModelParamsManagerImpl
extends BaseManagerImpl<ModelParamsDao, ModelParams>
implements ModelParamsManager {
    @Resource
    PointSystemManager pointSystemManager;
    @Resource
    ModelInfoManager modelInfoManager;

    @Override
    @Transactional
    public boolean insertModelParams(ModelParams modelParams) {
        if (BeanUtils.isNotEmpty((Object)((Object)modelParams))) {
            Integer result;
            if (StringUtil.isEmpty((String)modelParams.getModelCode())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)modelParams.getParamType())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)modelParams.getParamDataType())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)modelParams.getParamCode())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameCode(modelParams.getModelCode(), modelParams.getParamType(), modelParams.getParamCode(), modelParams.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u8be5\u6a21\u578b\u7684\u53c2\u6570\u7f16\u7801\u3010" + modelParams.getParamCode() + "\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            if (modelParams.getSn() == null) {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("model_code_", modelParams.getModelCode());
                map.put("param_type_", modelParams.getParamType());
                modelParams.setSn(this.getNextSequence(map));
            }
            return null != (result = Integer.valueOf(((ModelParamsDao)this.baseMapper).insert((Object)modelParams))) && result >= 1;
        }
        return false;
    }

    @Override
    public boolean insertBatchModelParams(List<ModelParams> modelParamsList) {
        if (!CollectionUtils.isEmpty(modelParamsList)) {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("model_code_", modelParamsList.get(0).getModelCode());
            map.put("param_type_", modelParamsList.get(0).getParamType());
            int sn = this.getNextSequence(map) - 1;
            for (ModelParams modelParams : modelParamsList) {
                ++sn;
                if (StringUtil.isEmpty((String)modelParams.getModelCode())) {
                    throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtil.isEmpty((String)modelParams.getParamType())) {
                    throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtil.isEmpty((String)modelParams.getParamDataType())) {
                    throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (StringUtil.isEmpty((String)modelParams.getParamCode())) {
                    throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (this.checkSameCode(modelParams.getModelCode(), modelParams.getParamType(), modelParams.getParamCode(), modelParams.getId())) {
                    throw new RequiredException("\u6dfb\u52a0\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u8be5\u6a21\u578b\u7684\u53c2\u6570\u7f16\u7801\u3010" + modelParams.getParamCode() + "\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
                }
                if (modelParams.getSn() != null) continue;
                modelParams.setSn(sn);
            }
            return this.saveBatch(modelParamsList);
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateModelParams(ModelParams modelParams) {
        if (BeanUtils.isNotEmpty((Object)((Object)modelParams))) {
            if (StringUtil.isEmpty((String)modelParams.getModelCode())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)modelParams.getParamType())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)modelParams.getParamDataType())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u6570\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)modelParams.getParamCode())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameCode(modelParams.getModelCode(), modelParams.getParamType(), modelParams.getParamCode(), modelParams.getId())) {
                throw new RequiredException("\u4fee\u6539\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u8be5\u6a21\u578b\u7684\u53c2\u6570\u7f16\u7801\u3010" + modelParams.getParamCode() + "\u3011\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((ModelParamsDao)this.baseMapper).updateById((Object)modelParams);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public void deleteByModel(String modelId, String modelCode) {
        if (StringUtil.isEmpty((String)modelId) && StringUtil.isEmpty((String)modelCode)) {
            throw new RequiredException("\u5220\u9664\u6a21\u578b\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u6a21\u578bID\u6216\u8005\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        ((QueryWrapper)queryWrapper.eq(StringUtil.isNotEmpty((String)modelId), (Object)"model_id_", (Object)modelId)).eq(StringUtil.isNotEmpty((String)modelCode), (Object)"model_code_", (Object)modelCode);
        ((ModelParamsDao)this.baseMapper).delete((Wrapper)queryWrapper);
        this.pointSystemManager.saveScadaPointCache();
    }

    @Override
    public List<ModelParams> queryParamSecondByFan(String fanCode) {
        Assert.hasText((String)fanCode, (String)"\u673a\u7ec4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        return ((ModelParamsDao)this.baseMapper).queryParamSecondByFan(fanCode);
    }

    private boolean checkSameCode(String modelCode, String paramType, String paramCode, String id) {
        Assert.hasText((String)modelCode, (String)"\u6a21\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.hasText((String)paramType, (String)"\u53c2\u6570\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.hasText((String)paramCode, (String)"\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"model_code_", (Object)modelCode);
        queryWrapper.eq((Object)"param_type_", (Object)paramType);
        queryWrapper.eq((Object)"param_code_", (Object)paramCode);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"ID_", (Object)id);
        int num = ((ModelParamsDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

