/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.model.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.cssc.model.dao.OrderInfoDao;
import com.artfess.cssc.model.manager.OrderInfoManager;
import com.artfess.cssc.model.model.OrderInfo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class OrderInfoManagerImpl
extends BaseManagerImpl<OrderInfoDao, OrderInfo>
implements OrderInfoManager {
    @Override
    @Transactional
    public boolean insertOrderInfo(OrderInfo orderInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)orderInfo))) {
            if (StringUtil.isEmpty((String)orderInfo.getOrderCode())) {
                throw new RequiredException("\u6dfb\u52a0\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff0c\u6307\u4ee4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)orderInfo.getOrderName())) {
                throw new RequiredException("\u6dfb\u52a0\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff0c\u6307\u4ee4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)orderInfo.getOrderType())) {
                throw new RequiredException("\u6dfb\u52a0\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff0c\u6307\u4ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameCode(orderInfo.getOrderCode(), orderInfo.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff0c\u6307\u4ee4\u7f16\u7801\u3010" + orderInfo.getOrderCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((OrderInfoDao)this.baseMapper).insert((Object)orderInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updateOrderInfo(OrderInfo orderInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)orderInfo))) {
            if (StringUtil.isEmpty((String)orderInfo.getOrderCode())) {
                throw new RequiredException("\u6dfb\u52a0\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff0c\u6307\u4ee4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)orderInfo.getOrderName())) {
                throw new RequiredException("\u6dfb\u52a0\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff0c\u6307\u4ee4\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (StringUtil.isEmpty((String)orderInfo.getOrderType())) {
                throw new RequiredException("\u6dfb\u52a0\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff0c\u6307\u4ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            if (this.checkSameCode(orderInfo.getOrderCode(), orderInfo.getId())) {
                throw new RequiredException("\u4fee\u6539\u6307\u4ee4\u4fe1\u606f\u5931\u8d25\uff0c\u6307\u4ee4\u7f16\u7801\u3010" + orderInfo.getOrderCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((OrderInfoDao)this.baseMapper).updateById((Object)orderInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    public OrderInfo getByCode(String orderCode) {
        Assert.hasText((String)orderCode, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_code_", (Object)orderCode);
        return (OrderInfo)((Object)((OrderInfoDao)this.baseMapper).selectOne((Wrapper)queryWrapper));
    }

    private boolean checkSameCode(String code, String id) {
        Assert.hasText((String)code, (String)"\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"order_code_", (Object)code);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"ID_", (Object)id);
        int num = ((OrderInfoDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

