/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.collect.mq;

import com.artfess.base.util.DateUtils;
import com.artfess.cssc.cms.manager.CmsDataManager;
import com.artfess.cssc.cms.model.CmsData;
import com.artfess.cssc.collect.dao.DataLogErrDao;
import com.artfess.cssc.collect.model.DataLogErr;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.rabbitmq.client.Channel;
import java.io.IOException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Iterator;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.support.converter.Jackson2JsonMessageConverter;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class DataCmsDataRabbitMq {
    private static final Logger log = LoggerFactory.getLogger(DataCmsDataRabbitMq.class);
    @Resource
    private CmsDataManager cmsDataManager;
    @Resource
    private DataLogErrDao dataLogErrDao;

    public void process(Message messageorigin, Channel channel) throws IOException {
        DataLogErr dataLogErr;
        String cmsState = "";
        JsonNode root = null;
        try {
            Jackson2JsonMessageConverter jackson2JsonMessageConverter = new Jackson2JsonMessageConverter();
            cmsState = (String)jackson2JsonMessageConverter.fromMessage(messageorigin);
        }
        catch (Exception e) {
            dataLogErr = new DataLogErr();
            dataLogErr.setSysName("cms");
            dataLogErr.setNode("\u63a5\u6536");
            dataLogErr.setErrorTime(LocalDateTime.now());
            dataLogErr.setErrorContent(e.getMessage());
            this.dataLogErrDao.insert((Object)dataLogErr);
            channel.basicNack(messageorigin.getMessageProperties().getDeliveryTag(), false, false);
        }
        try {
            if (StringUtils.isNotEmpty((CharSequence)cmsState)) {
                ObjectMapper mapper = new ObjectMapper();
                root = mapper.readTree(cmsState);
                boolean flag = true;
                if (!root.has("state_list") && !root.has("time")) {
                    flag = false;
                }
                if (!flag) {
                    DataLogErr dataLogErr2 = new DataLogErr();
                    dataLogErr2.setSysName("cms");
                    dataLogErr2.setNode("\u89e3\u6790");
                    dataLogErr2.setErrorTime(LocalDateTime.now());
                    dataLogErr2.setErrorContent("CMS\u5b9e\u65f6\u6570\u636e\u683c\u5f0f\u9519\u8bef\uff01\u6570\u636e\u4e2d\u6ca1\u6709\u65f6\u95f4\u6233\u6216\u6ca1\u6709\u91c7\u96c6\u6570\u636e");
                    this.dataLogErrDao.insert((Object)dataLogErr2);
                    channel.basicNack(messageorigin.getMessageProperties().getDeliveryTag(), false, false);
                    return;
                }
                this.saveCmsData(root);
                channel.basicAck(messageorigin.getMessageProperties().getDeliveryTag(), false);
            } else {
                DataLogErr dataLogErr3 = new DataLogErr();
                dataLogErr3.setSysName("cms");
                dataLogErr3.setNode("\u89e3\u6790");
                dataLogErr3.setErrorTime(LocalDateTime.now());
                dataLogErr3.setErrorContent("cms \u5b9e\u65f6\u6570\u636e\u4e3a\u7a7a\uff01");
                this.dataLogErrDao.insert((Object)dataLogErr3);
                channel.basicNack(messageorigin.getMessageProperties().getDeliveryTag(), false, false);
            }
        }
        catch (Exception e1) {
            dataLogErr = new DataLogErr();
            dataLogErr.setSysName("cms");
            dataLogErr.setNode("\u89e3\u6790");
            dataLogErr.setErrorTime(LocalDateTime.now());
            dataLogErr.setErrorContent(e1.getMessage());
            this.dataLogErrDao.insert((Object)dataLogErr);
            channel.basicNack(messageorigin.getMessageProperties().getDeliveryTag(), false, false);
        }
    }

    private void saveCmsData(JsonNode data) throws Exception {
        try {
            long time = data.get("time").asLong();
            JsonNode fanListJson = data.get("state_list");
            Iterator fanState = fanListJson.iterator();
            ArrayList<CmsData> list = new ArrayList<CmsData>();
            while (fanState.hasNext()) {
                JsonNode stateData = (JsonNode)fanState.next();
                CmsData cmsData = new CmsData();
                cmsData.setFanState(stateData.get("windturbine_state").asText());
                cmsData.setFanCode(stateData.get("windturbine_name").asText());
                cmsData.setDriveChain(stateData.get("drive_chain_list").asText());
                cmsData.setTowerBaseObliquity(stateData.get("tower_base_obliquity_list").asText());
                cmsData.setEngineRoomObliquity(stateData.get("engine_room_obliquity_list").asText());
                cmsData.setBladeVibration(stateData.get("blade_vibration_list").asText());
                cmsData.setBladeStress(stateData.get("blade_stress_list").asText());
                cmsData.setBoltComponent(stateData.get("bolt_component_list").asText());
                cmsData.setTowerSway(stateData.get("tower_sway_list").asText());
                cmsData.setOil(stateData.get("oil").asText());
                cmsData.setCollTimeStamp(time);
                cmsData.setCollTime(DateUtils.timestamToDatetime((long)time));
                cmsData.setCreateTime(LocalDateTime.now());
                list.add(cmsData);
            }
            if (!CollectionUtils.isEmpty(list)) {
                this.cmsDataManager.saveBatch(list);
            }
        }
        catch (Exception e) {
            DataLogErr dataLogErr = new DataLogErr();
            dataLogErr.setSysName("cms");
            dataLogErr.setNode("\u5165\u5e93");
            dataLogErr.setErrorTime(LocalDateTime.now());
            dataLogErr.setErrorContent(e.getMessage());
            this.dataLogErrDao.insert((Object)dataLogErr);
        }
    }

    public static void main(String[] args) throws Exception {
    }
}

