/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.cssc.base.dao.PointInfoDao;
import com.artfess.cssc.base.manager.PointInfoManager;
import com.artfess.cssc.base.model.PointInfo;
import com.artfess.cssc.base.params.PointInfoVo;
import com.artfess.poi.util.ExcelUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PointInfoManagerImpl
extends BaseManagerImpl<PointInfoDao, PointInfo>
implements PointInfoManager {
    @Override
    @Transactional
    public boolean insertPointInfo(PointInfo pointInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)pointInfo))) {
            if (this.checkSameCode(pointInfo.getVarName(), pointInfo.getPointType(), pointInfo.getId())) {
                throw new RequiredException("\u6dfb\u52a0\u70b9\u4f4d\u5931\u8d25\uff0c\u53d8\u91cf\u7f16\u7801\u3010" + pointInfo.getVarName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            HashMap<String, Integer> paramsMap = new HashMap<String, Integer>();
            paramsMap.put("point_type_", pointInfo.getPointType());
            pointInfo.setSn(this.getNextSequence(paramsMap));
            Integer result = ((PointInfoDao)this.baseMapper).insert((Object)pointInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    @Transactional
    public boolean updatePointInfo(PointInfo pointInfo) {
        if (BeanUtils.isNotEmpty((Object)((Object)pointInfo))) {
            if (this.checkSameCode(pointInfo.getVarName(), pointInfo.getPointType(), pointInfo.getId())) {
                throw new RequiredException("\u4fee\u6539\u70b9\u4f4d\u5931\u8d25\uff0c\u53d8\u91cf\u7f16\u7801\u3010" + pointInfo.getVarName() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
            }
            Integer result = ((PointInfoDao)this.baseMapper).updateById((Object)pointInfo);
            return null != result && result >= 1;
        }
        return false;
    }

    @Override
    public PointInfo getByVarName(String varName, Integer pointType) {
        return ((PointInfoDao)this.baseMapper).getByVarName(varName, pointType);
    }

    @Override
    @Transactional
    public void importData(MultipartFile file) throws Exception {
        List list = ExcelUtil.readExcel(PointInfoVo.class, (MultipartFile)file);
        if (BeanUtils.isNotEmpty((Object)list)) {
            if (!this.validateAllRole(list)) {
                String message = "\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5excel\u6570\u636e\u662f\u5426\u6b63\u786e\u3002";
                throw new BaseException(message);
            }
            for (PointInfoVo pointInfoVo : list) {
                PointInfo pointInfo = ((PointInfoDao)this.baseMapper).getByVarName(pointInfoVo.getVarName(), pointInfoVo.getPointType());
                if (!BeanUtils.isEmpty((Object)((Object)pointInfo))) continue;
                PointInfo nPointInfo = PointInfoVo.parse(pointInfoVo);
                nPointInfo.setId(UniqueIdUtil.getSuid());
                HashMap<String, Integer> paramsMap = new HashMap<String, Integer>();
                paramsMap.put("point_type_", nPointInfo.getPointType());
                nPointInfo.setSn(this.getNextSequence(paramsMap));
                this.create((Model)nPointInfo);
            }
        }
    }

    private boolean validateAllRole(List<PointInfoVo> list) {
        for (PointInfoVo pointInfoVo : list) {
            if (StringUtil.isEmpty((String)pointInfoVo.getPointName()) || StringUtil.isEmpty((String)pointInfoVo.getVarName()) || BeanUtils.isEmpty((Object)pointInfoVo.getPointType()) || StringUtil.isEmpty((String)pointInfoVo.getDataType())) {
                return false;
            }
            if (pointInfoVo.getPointType() != 1 && pointInfoVo.getPointType() != 2) {
                return false;
            }
            if (pointInfoVo.getDataType().equals("B") || pointInfoVo.getDataType().equals("F") || pointInfoVo.getDataType().equals("I")) continue;
            return false;
        }
        return true;
    }

    private boolean checkSameCode(String varName, Integer pointType, String id) {
        Assert.hasText((String)varName, (String)"\u53d8\u91cf\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        Assert.notNull((Object)pointType, (String)"\u70b9\u4f4d\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"VAR_NAME_", (Object)varName);
        queryWrapper.eq((Object)"POINT_TYPE_", (Object)pointType);
        queryWrapper.ne(StringUtils.isNotBlank((CharSequence)id), (Object)"ID_", (Object)id);
        int num = ((PointInfoDao)this.baseMapper).selectCount((Wrapper)queryWrapper);
        return num != 0;
    }
}

