/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cssc.base.manager.impl;

import com.artfess.base.exception.RequiredException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.model.CommonResult;
import com.artfess.base.util.BeanUtils;
import com.artfess.base.util.JsonUtil;
import com.artfess.base.util.StringUtil;
import com.artfess.base.util.UniqueIdUtil;
import com.artfess.cssc.base.dao.FanParamsDao;
import com.artfess.cssc.base.dao.ParamsConfDao;
import com.artfess.cssc.base.dao.WfParamsDao;
import com.artfess.cssc.base.manager.FanInfoManager;
import com.artfess.cssc.base.manager.ParamsConfManager;
import com.artfess.cssc.base.manager.WindFactoryManager;
import com.artfess.cssc.base.model.FanInfo;
import com.artfess.cssc.base.model.FanParams;
import com.artfess.cssc.base.model.ParamsConf;
import com.artfess.cssc.base.model.WfParams;
import com.artfess.cssc.base.model.WindFactory;
import com.artfess.cssc.base.params.ParamsConfVo;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class ParamsConfManagerImpl
extends BaseManagerImpl<ParamsConfDao, ParamsConf>
implements ParamsConfManager {
    private static final List<String> types = Arrays.asList("1", "2");
    private static final List<String> ctrTypes = Arrays.asList("input", "select", "checkbox", "radio", "date", "number");
    @Resource
    WindFactoryManager windFactoryManager;
    @Resource
    FanInfoManager fanInfoManager;
    @Resource
    WfParamsDao wfParamsDao;
    @Resource
    FanParamsDao fanParamsDao;

    @Override
    @Transactional
    public Integer removePhysical() {
        return ((ParamsConfDao)this.baseMapper).removePhysical();
    }

    @Override
    public ParamsConf getByCode(String code) {
        if (StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u53c2\u6570\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ParamsConf param = ((ParamsConfDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)((Object)param))) {
            throw new RuntimeException("\u7f16\u7801\u4e3a\u3010" + code + "\u3011\u7684\u53c2\u6570\u4e0d\u5b58\u5728!");
        }
        return param;
    }

    @Override
    public List<ParamsConf> getByType(String type) {
        return ((ParamsConfDao)this.baseMapper).getByType(type);
    }

    @Override
    @Transactional
    public CommonResult<String> addParamsConf(ParamsConfVo param) throws Exception {
        if (((ParamsConfDao)this.baseMapper).getCountByCode(param.getCode()) > 0) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u3010" + param.getCode() + "\u3011\u5728\u7cfb\u7edf\u4e2d\u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\uff01");
        }
        if (StringUtil.isEmpty((String)param.getCode())) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u3010code\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)param.getName())) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u540d\u79f0\u3010name\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)param.getCtrType())) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u63a7\u4ef6\u7c7b\u578b\u3010ctrType\u3011\u5fc5\u586b\uff01");
        }
        if (StringUtil.isEmpty((String)param.getType())) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u7c7b\u578b\u3010type\u3011\u5fc5\u586b\uff01");
        }
        String ctyType = param.getCtrType().trim();
        if (!ctrTypes.contains(ctyType)) {
            throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0cctrType \u53c2\u6570\u914d\u7f6e\u53ea\u80fd\u4e3a\uff1ainput\uff1a\u624b\u52a8\u8f93\u5165\uff1b   select\uff1a\u4e0b\u62c9\u6846\uff1b checkbox\uff1a\u590d\u9009\u6846\uff1b  radio\uff1a\u5355\u9009\u6309\u94ae\uff1b  date\uff1a\u65e5\u671f\uff1b  number\uff1a\u6570\u5b57\uff1b");
        }
        if ("select".equals(ctyType) || "checkbox".equals(ctyType) || "radio".equals(ctyType)) {
            Iterator elements = param.getJson().elements();
            while (elements.hasNext()) {
                JsonNode next = (JsonNode)elements.next();
                if (next.size() >= 2) continue;
                throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0cctrType \u53c2\u6570\u914d\u7f6e\u7c7b\u578b\u4e3a\uff1aselect\uff08\u4e0b\u62c9\u6846\uff09\u3001 checkbox\uff08\u590d\u9009\u6846\uff09\u3001  radio\uff08\u5355\u9009\u6309\u94ae\uff09\u65f6\uff0cjson\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
        ParamsConf params = ParamsConfVo.parse(param);
        params.setId(UniqueIdUtil.getSuid());
        HashMap<String, String> paramsMap = new HashMap<String, String>();
        paramsMap.put("TYPE_", params.getType());
        int sn = this.getNextSequence(paramsMap);
        params.setSn(sn);
        if (types.contains(params.getType())) {
            this.save((Object)params);
            return new CommonResult(true, "\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u6210\u529f\uff01", (Object)"");
        }
        return new CommonResult(false, "\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff01\u53c2\u6570\u914d\u7f6e\u7c7b\u578b\u4e0d\u5bf9\uff0c\u8bf7\u5728(\u98ce\u573a\u53c2\u6570\uff1a1,\u673a\u7ec4\u53c2\u6570 :2)\u9009\u62e9\u5176\u4e2d\u4e00\u4e2a\u6570\u5b57", (Object)"");
    }

    @Transactional
    public void removeByIds(String ... ids) {
        for (String id : ids) {
            ParamsConf params = (ParamsConf)this.get((Serializable)((Object)id));
            if (params == null) continue;
            this.wfParamsDao.removeByCode(params.getCode(), LocalDateTime.now());
            this.fanParamsDao.removeByCode(params.getCode(), LocalDateTime.now());
        }
        super.removeByIds(ids);
    }

    @Override
    @Transactional
    public CommonResult<String> deleteParamsConfByCodes(String codes) throws Exception {
        if (StringUtil.isEmpty((String)codes)) {
            throw new RequiredException("\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] codeArray = codes.split(",");
        StringBuilder str = new StringBuilder();
        String[] idArray = new String[codeArray.length];
        boolean isTrue = false;
        for (int i = 0; i < codeArray.length; ++i) {
            String code = codeArray[i];
            ParamsConf params = ((ParamsConfDao)this.baseMapper).getByCode(code);
            if (BeanUtils.isNotEmpty((Object)((Object)params))) {
                idArray[i] = params.getId();
                isTrue = true;
                continue;
            }
            str.append(code);
            str.append("\uff0c");
        }
        if (BeanUtils.isNotEmpty((Object)idArray)) {
            this.removeByIds(idArray);
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u53c2\u6570\u914d\u7f6e\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> deleteParamsConfByIds(String ids) {
        if (StringUtil.isEmpty((String)ids)) {
            throw new RequiredException("\u53c2\u6570\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        String[] idArray = ids.split(",");
        StringBuilder str = new StringBuilder();
        String[] idStr = new String[idArray.length];
        boolean isTrue = false;
        for (int i = 0; i < idArray.length; ++i) {
            String id = idArray[i];
            ParamsConf params = (ParamsConf)this.get((Serializable)((Object)id));
            if (BeanUtils.isNotEmpty((Object)((Object)params))) {
                idStr[i] = params.getId();
                isTrue = true;
                continue;
            }
            str.append(id);
            str.append("\uff0c");
        }
        if (BeanUtils.isNotEmpty((Object)idStr)) {
            this.removeByIds(idStr);
        }
        String msg = StringUtil.isEmpty((String)str.toString()) ? "\u5220\u9664\u53c2\u6570\u914d\u7f6e\u6210\u529f\uff01" : "\u90e8\u5206\u5220\u9664\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u7f16\u7801\uff1a" + str.toString() + "\u4e0d\u5b58\u5728\uff01";
        return new CommonResult(isTrue, msg, (Object)str.toString());
    }

    @Override
    @Transactional
    public CommonResult<String> updateParamsConf(ParamsConfVo paramVo) throws Exception {
        if (BeanUtils.isEmpty((Object)paramVo.getId())) {
            throw new RequiredException("\u66f4\u65b0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u4e3b\u952eID\u5fc5\u586b\uff01");
        }
        ParamsConf params = (ParamsConf)((Object)((ParamsConfDao)this.baseMapper).selectById((Serializable)((Object)paramVo.getId())));
        if (BeanUtils.isEmpty((Object)((Object)params))) {
            return new CommonResult(false, "\u66f4\u65b0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0c\u53c2\u6570\u914d\u7f6e\u4e3b\u952eID\u3010" + paramVo.getId() + "\u3011\u4e0d\u5b58\u5728\uff01", (Object)"");
        }
        if (StringUtil.isNotEmpty((String)paramVo.getName())) {
            params.setName(paramVo.getName());
        }
        if (StringUtil.isNotEmpty((String)paramVo.getType())) {
            params.setType(paramVo.getType());
        }
        if (StringUtil.isNotEmpty((String)paramVo.getCtrType())) {
            params.setCtlType(paramVo.getCtrType());
            String ctyType = paramVo.getCtrType().trim();
            if ("select".equals(ctyType) || "checkbox".equals(ctyType) || "radio".equals(ctyType)) {
                Iterator elements = paramVo.getJson().elements();
                while (elements.hasNext()) {
                    JsonNode next = (JsonNode)elements.next();
                    if (next.size() >= 2) continue;
                    throw new RequiredException("\u6dfb\u52a0\u53c2\u6570\u914d\u7f6e\u5931\u8d25\uff0cctrType \u53c2\u6570\u914d\u7f6e\u7c7b\u578b\u4e3a\uff1aselect\uff08\u4e0b\u62c9\u6846\uff09\u3001 checkbox\uff08\u590d\u9009\u6846\uff09\u3001  radio\uff08\u5355\u9009\u6309\u94ae\uff09\u65f6\uff0cjson\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
            }
            if (paramVo.getJson() != null && !paramVo.getJson().toString().equals("")) {
                params.setJson(JsonUtil.toJson((Object)paramVo.getJson()));
            }
        }
        this.update((Model)params);
        return new CommonResult(true, "\u66f4\u65b0\u53c2\u6570\u6210\u529f\uff01", (Object)"");
    }

    @Override
    public CommonResult<Boolean> isCodeExist(String code) throws Exception {
        boolean isExist;
        ParamsConf params = ((ParamsConfDao)this.baseMapper).getByCode(code);
        return new CommonResult(isExist, (isExist = BeanUtils.isNotEmpty((Object)((Object)params))) ? "\u8be5\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u5df2\u5b58\u5728\uff01" : "", (Object)isExist);
    }

    @Override
    public WfParams getWfParamsById(String wfId, String code) throws Exception {
        if (StringUtil.isEmpty((String)wfId) || StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u98ce\u573aID\u6216\u98ce\u573a\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        WindFactory windFactory = (WindFactory)this.windFactoryManager.get((Serializable)((Object)wfId));
        if (BeanUtils.isEmpty((Object)((Object)windFactory))) {
            throw new RequiredException(String.format("ID\u4e3a\u3010%s\u3011\u7684\u98ce\u573a\u4e0d\u5b58\u5728\uff01", wfId));
        }
        return this.getWfParamsByWf(windFactory, code);
    }

    private WfParams getWfParamsByWf(WindFactory windFactory, String code) {
        ParamsConf param = ((ParamsConfDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)((Object)param)) || BeanUtils.isNotEmpty((Object)((Object)param)) && !"1".equals(param.getType())) {
            throw new RequiredException("\u98ce\u573a\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        WfParams wfParams = this.wfParamsDao.getByWfIdAndCode(windFactory.getId(), code);
        if (BeanUtils.isEmpty((Object)((Object)wfParams))) {
            wfParams = new WfParams();
            wfParams.setWfId(windFactory.getId());
            wfParams.setCode(code);
        }
        return wfParams;
    }

    @Override
    public FanParams getFanParamsById(String fanId, String code) throws Exception {
        if (StringUtil.isEmpty((String)fanId) || StringUtil.isEmpty((String)code)) {
            throw new RequiredException("\u673a\u7ec4ID\u6216\u673a\u7ec4\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        FanInfo fanInfo = (FanInfo)this.fanInfoManager.get((Serializable)((Object)fanId));
        if (BeanUtils.isEmpty((Object)((Object)fanInfo))) {
            throw new RequiredException(String.format("ID\u4e3a\u3010%s\u3011\u7684\u673a\u7ec4\u4e0d\u5b58\u5728\uff01", fanId));
        }
        return this.getFanParamsByFan(fanInfo, code);
    }

    private FanParams getFanParamsByFan(FanInfo fanInfo, String code) {
        ParamsConf param = ((ParamsConfDao)this.baseMapper).getByCode(code);
        if (BeanUtils.isEmpty((Object)((Object)param)) || BeanUtils.isNotEmpty((Object)((Object)param)) && !"2".equals(param.getType())) {
            throw new RequiredException("\u673a\u7ec4\u53c2\u6570\u914d\u7f6e\u7f16\u7801\u3010" + code + "\u3011\u4e0d\u5b58\u5728\uff01");
        }
        FanParams fanParams = this.fanParamsDao.getByFanIdAndCode(fanInfo.getId(), code);
        if (BeanUtils.isEmpty((Object)((Object)fanParams))) {
            fanParams = new FanParams();
            fanParams.setFanId(fanInfo.getId());
            fanParams.setCode(code);
        }
        return fanParams;
    }
}

