package com.artfess.workflow;

import com.alibaba.druid.spring.boot.autoconfigure.DruidDataSourceAutoConfigure;
import org.mybatis.spring.annotation.MapperScan;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.cloud.client.SpringCloudApplication;
import org.springframework.cloud.netflix.hystrix.dashboard.EnableHystrixDashboard;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@SpringBootApplication(exclude = DruidDataSourceAutoConfigure.class)
@SpringCloudApplication
@Configuration
@MapperScan(basePackages = {"com.artfess.**.dao"})
@ComponentScan({"com.artfess.*", "org.activiti.engine.*"})
@EnableFeignClients(basePackages = {"com.artfess.*"})
@EnableHystrixDashboard
public class Application {
    public static void main(String[] args) {
        SpringApplication.run(Application.class, args);
    }

//	@Bean
//	public ServletRegistrationBean getServlet(){
//	   HystrixMetricsStreamServlet streamServlet = new HystrixMetricsStreamServlet();
//	   ServletRegistrationBean registrationBean = new ServletRegistrationBean(streamServlet);
//	   registrationBean.setLoadOnStartup(1);
//	   registrationBean.addUrlMappings("/actuator/hystrix.stream");
//	   registrationBean.setName("HystrixMetricsStreamServlet");
//	   return registrationBean;
//	}
}