package com.artfess.security.model;

import com.artfess.base.entity.AutoFillModel;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

@ApiModel(value = "SysAuthorization",description = "版本授权管理")
@TableName("PORTAL_SYS_AUTHORIZATION")
public class SysAuthorization extends AutoFillModel<SysAuthorization> {

    @ApiModelProperty(name="id_", notes="主键")
    @TableId("id_")
    protected String id;

    @ApiModelProperty(value = "单位名称")
    @TableField(value = "dept_name_")
    private String deptName;

//    @ApiModelProperty(value = "客户单位ID")
//    @TableField(value = "DEPT_ID")
//    private String deptId;

    @ApiModelProperty(value = "联系人")
    @TableField(value = "link_user_")
    private String user;

    @ApiModelProperty(value = "联系电话")
    @TableField(value = "tel_")
    private String tel;

    @ApiModelProperty(value = "系统版本")
    @TableField(value = "version_code_")
    private String versionCode;

    @ApiModelProperty(value = "用户限制")
    @TableField(value = "user_num_")
    private String userNum;

    @ApiModelProperty(value = "租户数")
    @TableField(value = "tenant_num_")
    private String tenantNum;

    @ApiModelProperty(value = "机构数")
    @TableField(value = "ogn_num_")
    private String ognNum;

    @ApiModelProperty(value = "安装时间")
    @TableField(value = "install_date_")
    private String installDate;

    @ApiModelProperty(value = "用户限制")
    @TableField(value = "end_date_")
    private String endDate;

    @ApiModelProperty(value = "MAC地址")
    @TableField(value = "mac_")
    private String mac;

    @ApiModelProperty(value = "IP地址")
    @TableField(value = "ip_")
    private String ip;

    @ApiModelProperty(value = "授权类型【1.临时、2.永久】")
    @TableField(value = "type_")
    private String type;

    @ApiModelProperty(value = "授权码")
    @TableField(value ="enc_str_",select = false)
    private String encStr;

    @ApiModelProperty(value = "授权码")
    @TableField(value ="system_type_")
    private String systemType;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDeptName() {
        return deptName;
    }

    public void setDeptName(String deptName) {
        this.deptName = deptName;
    }

    public String getUser() {
        return user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getTel() {
        return tel;
    }

    public void setTel(String tel) {
        this.tel = tel;
    }

    public String getVersionCode() {
        return versionCode;
    }

    public void setVersionCode(String versionCode) {
        this.versionCode = versionCode;
    }

    public String getUserNum() {
        return userNum;
    }

    public void setUserNum(String userNum) {
        this.userNum = userNum;
    }

    public String getInstallDate() {
        return installDate;
    }

    public void setInstallDate(String installDate) {
        this.installDate = installDate;
    }

    public String getEndDate() {
        return endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getMac() {
        return mac;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public String getIp() {
        return ip;
    }

    public void setIp(String ip) {
        this.ip = ip;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getEncStr() {
        return encStr;
    }

    public void setEncStr(String encStr) {
        this.encStr = encStr;
    }

//    public String getDeptId() {
//        return deptId;
//    }
//
//    public void setDeptId(String deptId) {
//        this.deptId = deptId;
//    }

    public String getTenantNum() {
        return tenantNum;
    }

    public void setTenantNum(String tenantNum) {
        this.tenantNum = tenantNum;
    }

    public String getOgnNum() {
        return ognNum;
    }

    public void setOgnNum(String ognNum) {
        this.ognNum = ognNum;
    }

    public String getSystemType() {
        return systemType;
    }

    public void setSystemType(String systemType) {
        this.systemType = systemType;
    }
}
