package com.artfess.sysConfig.persistence.manager.impl;

import java.util.List;
import java.util.Map;

import org.springframework.stereotype.Service;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.util.StringUtil;
import com.artfess.sysConfig.persistence.dao.SysLogsDao;
import com.artfess.sysConfig.persistence.manager.SysLogsManager;
import com.artfess.sysConfig.persistence.model.SysLogs;

/**
 * 
 * <pre> 
 * 描述：系统操作日志 处理实现类
 * 构建组：x7
 * 作者:liyg
 * 邮箱:liygui@jee-soft.cn
 * 日期:2018-08-31 10:59:25
 * 版权：广州宏天软件有限公司
 * </pre>
 */
@Service("sysLogsManager")
public class SysLogsManagerImpl extends BaseManagerImpl<SysLogsDao, SysLogs> implements SysLogsManager{
	
	@Override
	public void removeByEexcutionTime(List<Map<String, Object>> params) {
		baseMapper.removeByEexcutionTime(params);
	}
	
	@Override
	public void create(SysLogs log) {
		if(StringUtil.isNotEmpty(log.getOpeName()) && log.getOpeName().length()>480){
			log.setOpeName(log.getOpeName().substring(0, 480));
		}
		this.save(log);
	}
}
