/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.enums;

import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public enum AnalyseTypeEnum {
    YZ("0", "\u4e9a\u6d32\u533a\u57df", ""),
    OZ("1", "\u6b27\u6d32\u533a\u57df", ""),
    MZ("2", "\u7f8e\u6d32\u533a\u57df", ""),
    NCYE("5", "\u5e74\u521d\u4f59\u989d", ""),
    JLR("6", "\u51c0\u5229\u6da6", "900000"),
    XSSR("7", "\u7d2f\u8ba1\u9500\u552e\u6536\u5165", "PL3300S"),
    XSCB("8", "\u7d2f\u8ba1\u9500\u552e\u6210\u672c", "(PL3300S-EBITDA)"),
    PJZCZE("9", "\u5e73\u5747\u8d44\u4ea7\u603b\u989d", "A1000");

    private String type;
    private String desc;
    private String formula;

    private AnalyseTypeEnum(String type, String desc, String formula) {
        this.type = type;
        this.desc = desc;
        this.formula = formula;
    }

    public static String getType(String desc) {
        AnalyseTypeEnum[] values;
        if (StringUtils.isEmpty((CharSequence)desc)) {
            return null;
        }
        for (AnalyseTypeEnum state : values = AnalyseTypeEnum.values()) {
            if (!state.getDesc().equals(desc)) continue;
            return state.getType();
        }
        return null;
    }

    public static AnalyseTypeEnum getAnalyse(String type) {
        AnalyseTypeEnum[] values;
        if (StringUtils.isEmpty((CharSequence)type)) {
            return null;
        }
        for (AnalyseTypeEnum state : values = AnalyseTypeEnum.values()) {
            if (!state.getType().equals(type)) continue;
            return state;
        }
        return null;
    }

    public static List<String> getAreaType() {
        String[] areaType = new String[]{YZ.getType(), OZ.getType(), MZ.getType()};
        return Arrays.asList(areaType);
    }

    public static List<String> mergeType() {
        String[] type = new String[]{NCYE.getType(), JLR.getType(), XSSR.getType(), XSCB.getType(), PJZCZE.getType()};
        return Arrays.asList(type);
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public String getFormula() {
        return this.formula;
    }
}

