package com.artfess.base.enums;

import com.artfess.base.util.StringUtil;
import lombok.Getter;

/**
 * 计算公式
 */
@Getter
public enum HrTargetTypeEnum {
    // 人事统计指标
    ygrsdb(1,"001","员工人数对比","The number of employees contrast","person", "FE146、FE147、FE148","直接员工数、间接员工数、从业员工数"),
    jjygxszb(2,"002","间接员工年度工资销售占比","Sales accounted for indirect staff annual salary","%", "FE157","间接员工"),
    ryjgfx(3,"003","人均销售对比","Personnel structure analysis","€", "FE150、FE151","直接员工、间接员工"),
    pjxc(4,"004","直接间接员工平均职工薪酬对比","In direct contrast indirect employee compensation","€", "FE154、FE156","直接员工、间接员工"),
    xcze(5,"005","直接间接员工薪酬总额对比","In direct contrast indirect total employee compensation","10K€", "FE153、FE155","直接员工、间接员工"),
    zgxcze(6,"006","职工薪酬总额趋势图","Total employee compensation trend chart","10K€", "FE152","职工薪酬总额"),

    ;

    HrTargetTypeEnum(Integer type, String targetId,
                     String targetName, String targetNameEn,
                     String targetUnit, String targetCodes, String staLat){
        this.type = type;
        this.targetId = targetId;
        this.targetName = targetName;
        this.targetNameEn = targetNameEn;
        this.targetUnit = targetUnit;
        this.targetCodes = targetCodes;
        this.staLat = staLat;
    }

    private String targetName;

    private String targetNameEn;

    private String targetUnit;

    private String targetId;

    private Integer type;

    private String targetCodes;

    private String staLat;


    public static HrTargetTypeEnum getTarget(Integer type){
        if(null == type){
            return null;
        }
        HrTargetTypeEnum[] values = values();
        for (HrTargetTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state;
            }
        }
        return null;
    }

    public static HrTargetTypeEnum findByTargetId(String targetId){
        if(!StringUtil.isNotEmpty(targetId)){
            return null;
        }
        HrTargetTypeEnum[] values = values();
        for (HrTargetTypeEnum state : values) {
            if (state.getTargetId().equals(targetId)) {
                return state;
            }
        }
        return null;
    }
}
