package com.artfess.base.enums;

import lombok.Getter;
import org.apache.commons.lang3.StringUtils;

import java.util.Arrays;
import java.util.List;

/**
 * 计算公式
 */
@Getter
public enum AnalyseTypeEnum {
    YZ("0","亚洲区域", ""),

    OZ("1", "欧洲区域", ""),

    MZ("2", "美洲区域", ""),

    NCYE("5", "年初余额", ""),

    JLR("6", "净利润", "900000"),

    XSSR("7", "累计销售收入", "PL3300S"),

    XSCB("8", "累计销售成本", "(PL3300S-EBITDA)"),

    PJZCZE("9", "平均资产总额", "A1000"),
    ;

    AnalyseTypeEnum(String type, String desc, String formula){
        this.type = type;
        this.desc = desc;
        this.formula = formula;
    }

    private String type;

    private String desc;

    private String formula;

    public static String getType(String desc){
        if(StringUtils.isEmpty(desc)){
            return null;
        }
        AnalyseTypeEnum[] values = values();
        for (AnalyseTypeEnum state : values) {
            if (state.getDesc().equals(desc)) {
                return state.getType();
            }
        }
        return null;
    }

    public static AnalyseTypeEnum getAnalyse(String type){
        if(StringUtils.isEmpty(type)){
            return null;
        }
        AnalyseTypeEnum[] values = values();
        for (AnalyseTypeEnum state : values) {
            if (state.getType().equals(type)) {
                return state;
            }
        }
        return null;
    }

    public static List<String> getAreaType(){
        String[] areaType = new String[]{AnalyseTypeEnum.YZ.getType(),AnalyseTypeEnum.OZ.getType(),AnalyseTypeEnum.MZ.getType()};
        return Arrays.asList(areaType);
    }

    public static List<String> mergeType(){
        String[] type = new String[]{AnalyseTypeEnum.NCYE.getType(),
                            AnalyseTypeEnum.JLR.getType(),
                AnalyseTypeEnum.XSSR.getType(),
                AnalyseTypeEnum.XSCB.getType(),
                AnalyseTypeEnum.PJZCZE.getType()
        };
        return Arrays.asList(type);
    }
}
