package com.artfess.uc.api.impl.model.permission;

import com.artfess.base.util.BeanUtils;
import com.artfess.uc.api.constant.GroupTypeConstant;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IGroup;
import com.artfess.uc.api.model.IUser;
import com.artfess.uc.api.service.IUserGroupService;

import javax.annotation.Resource;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;



/**
 * 类 {@code GroupPermission} 用户组权限
 * @company 阿特菲斯信息技术有限公司
 * @author heyifan
 * @email heyf@jee-soft.cn
 * @date 2018年7月5日
 */
public class GroupPermission extends AbstarctPermission {
	
	@Resource
	IUserGroupService defaultUserGroupService;
	@Override
	public String getTitle() {
		return GroupTypeConstant.ORG.name();
	}

	@Override
	public String getType() {
		return GroupTypeConstant.ORG.key();
	}

	

	@Override
	public Set<String> getCurrentProfile() {
		IUser user= ContextUtil.getCurrentUser();
		Map<String, List<IGroup>> groups = defaultUserGroupService.getGroupsMapUserIdOrAccount(user.getUserId());
		if(BeanUtils.isEmpty(groups)) return null;
		Collection<List<IGroup>> list=groups.values();
		Set<String> set=new HashSet<String>();
		for(List<IGroup> listGroup : list){
			List<IGroup> temps=listGroup;
			for(IGroup temp:temps){
				set.add(temp.getGroupId());
			}
		}
		return set;
	}
	


}
