/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.cqlt.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.cqlt.dao.QfOperationReductionsMDao;
import com.artfess.cqlt.manager.QfOperationReductionsDManager;
import com.artfess.cqlt.manager.QfOperationReductionsMManager;
import com.artfess.cqlt.model.QfOperationReductionsD;
import com.artfess.cqlt.model.QfOperationReductionsM;
import com.artfess.i18n.util.I18nUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
public class QfOperationReductionsMManagerImpl
extends BaseManagerImpl<QfOperationReductionsMDao, QfOperationReductionsM>
implements QfOperationReductionsMManager {
    @Autowired
    private QfOperationReductionsDManager operationKpiDManager;

    private void processDetail(List<QfOperationReductionsD> list, String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)id);
        this.operationKpiDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> detail.setMainId(id));
        this.operationKpiDManager.saveBatch(list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean importExcel(List<QfOperationReductionsD> list, String mainId) {
        QfOperationReductionsM qfOperationKpiM = (QfOperationReductionsM)((Object)((QfOperationReductionsMDao)this.baseMapper).selectById((Serializable)((Object)mainId)));
        Assert.notNull((Object)((Object)qfOperationKpiM), (String)I18nUtil.getMessage((String)"filldata.notExist", (Locale)LocaleContextHolder.getLocale()));
        Assert.isTrue((!"1".equals(qfOperationKpiM.getStatus()) ? 1 : 0) != 0, (String)I18nUtil.getMessage((String)"data_operate", (Locale)LocaleContextHolder.getLocale()));
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"main_id_", (Object)mainId);
        this.operationKpiDManager.remove((Wrapper)queryWrapper);
        list.forEach(detail -> {
            detail.setMainId(mainId);
            detail.setFillDate(LocalDate.now());
        });
        boolean b = this.operationKpiDManager.saveBatch(list);
        return b;
    }

    @Override
    public boolean updateStatus(QfOperationReductionsM t) {
        QfOperationReductionsM qfOperationKpiM = (QfOperationReductionsM)((Object)((QfOperationReductionsMDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == qfOperationKpiM) {
            return false;
        }
        qfOperationKpiM.setStatus(qfOperationKpiM.getStatus() == 0 ? 1 : 0);
        int i = ((QfOperationReductionsMDao)this.baseMapper).updateById((Object)qfOperationKpiM);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean insertInfo(QfOperationReductionsM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        List qfOperationKpiMS = ((QfOperationReductionsMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationReductionsMDao)this.baseMapper).insert((Object)t);
        return insert > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateInfo(QfOperationReductionsM t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"fill_year_", (Object)t.getFillYear());
        queryWrapper.eq((Object)"fill_month_", (Object)t.getFillMonth());
        queryWrapper.eq((Object)"report_id_", (Object)t.getReportId());
        queryWrapper.ne((Object)"id_", (Object)t.getId());
        List qfOperationKpiMS = ((QfOperationReductionsMDao)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (!CollectionUtils.isEmpty((Collection)qfOperationKpiMS)) {
            throw new BaseException(I18nUtil.getMessage((String)"QfOperationKpiM.repeat", (Locale)LocaleContextHolder.getLocale()));
        }
        int insert = ((QfOperationReductionsMDao)this.baseMapper).updateById((Object)t);
        return insert > 0;
    }
}

